/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.ui;

import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public final class ShellDragSupport
implements Listener {
    private int x = -1;
    private int y;
    private final Cursor moveCursor;
    private final Shell shell;

    public ShellDragSupport(Composite composite) {
        this.moveCursor = new Cursor((Device)composite.getDisplay(), 5);
        this.shell = composite.getShell();
        composite.addListener(6, (Listener)this);
        composite.addListener(7, (Listener)this);
        composite.addListener(5, (Listener)this);
        composite.addListener(3, (Listener)this);
        composite.addListener(4, (Listener)this);
        composite.addListener(12, (Listener)this);
    }

    public void handleEvent(Event event) {
        Point pt = this.shell.toDisplay(event.x, event.y);
        switch (event.type) {
            case 6: {
                this.shell.setCursor(this.moveCursor);
                break;
            }
            case 7: {
                this.shell.setCursor(null);
                break;
            }
            case 5: {
                if (this.x == -1) break;
                Point location = this.shell.getLocation();
                this.shell.setLocation(location.x + pt.x - this.x, location.y + pt.y - this.y);
            }
            case 3: {
                this.x = pt.x;
                this.y = pt.y;
                break;
            }
            case 4: {
                this.x = -1;
                break;
            }
            case 12: {
                this.moveCursor.dispose();
            }
        }
    }

    Cursor getMoveCursor() {
        return this.moveCursor;
    }
}

