/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.BidiInfo;
import org.eclipse.draw2d.text.BidiProcessor;
import org.eclipse.draw2d.text.CaretInfo;
import org.eclipse.draw2d.text.FlowBorder;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.FlowFigureLayout;
import org.eclipse.draw2d.text.FlowUtilities;
import org.eclipse.draw2d.text.InlineFlow;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.pde.api.tools.annotations.NoExtend;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextLayout;

@NoExtend
public class TextFlow
extends InlineFlow {
    static final String ELLIPSIS = "...";
    private BidiInfo bidiInfo;
    private int selectionEnd = -1;
    private String text;

    public TextFlow() {
        this("");
    }

    public TextFlow(String s) {
        this.text = s;
    }

    @Override
    public boolean addLeadingWordRequirements(int[] width) {
        return this.addLeadingWordWidth(this.getText(), width);
    }

    /*
     * Unable to fully structure code
     */
    boolean addLeadingWordWidth(String text, int[] width) {
        if (text.length() == 0) {
            return false;
        }
        if (Character.isWhitespace(text.charAt(0))) {
            return true;
        }
        text = "a" + (String)text + "a";
        FlowUtilities.LINE_BREAK.setText((String)text);
        index = FlowUtilities.LINE_BREAK.next() - 1;
        if (index != 0) ** GOTO lbl11
        return true;
lbl-1000:
        // 1 sources

        {
            --index;
lbl11:
            // 2 sources

            ** while (Character.isWhitespace((char)text.charAt((int)index)))
        }
lbl12:
        // 1 sources

        v0 = result = index < text.length() - 1;
        if (index == text.length() - 1) {
            --index;
        }
        text = text.substring(1, index + 1);
        if (this.bidiInfo == null) {
            width[0] = width[0] + this.getTextUtilities().getTextExtents((String)text, (Font)this.getFont()).width;
        } else {
            textLayout = FlowUtilities.getTextLayout();
            textLayout.setFont(this.getFont());
            textLayout.setText((String)text);
            width[0] = width[0] + textLayout.getBounds().width;
        }
        return result;
    }

    @Override
    protected void contributeBidi(BidiProcessor proc) {
        this.bidiInfo = null;
        proc.add((FlowFigure)this, this.getText());
    }

    @Override
    protected FlowFigureLayout createDefaultFlowLayout() {
        return new ParagraphTextLayout(this);
    }

    private int findNextLineOffset(Point p, int[] trailing) {
        if (this.getBounds().bottom() <= p.y) {
            return -1;
        }
        TextFragmentBox closestBox = null;
        int index = 0;
        List<? extends TextFragmentBox> fragments = this.getFragmentsWithoutBorder();
        int i = fragments.size() - 1;
        while (i >= 0) {
            TextFragmentBox box = fragments.get(i);
            if (box.getBaseline() - box.getLineRoot().getAscent() > p.y && (closestBox == null || box.getBaseline() < closestBox.getBaseline() || box.getBaseline() == closestBox.getBaseline() && TextFlow.hDistanceBetween(box, p.x) < TextFlow.hDistanceBetween(closestBox, p.x))) {
                closestBox = box;
                index = i;
            }
            --i;
        }
        return this.findOffset(p, trailing, closestBox, index);
    }

    private int findOffset(Point p, int[] trailing, TextFragmentBox box, int boxIndex) {
        if (box == null) {
            return -1;
        }
        TextLayout layout = FlowUtilities.getTextLayout();
        layout.setFont(this.getFont());
        layout.setText(this.getBidiSubstring(box, boxIndex));
        int x = p.x - box.getX();
        if (this.isMirrored()) {
            x = box.getWidth() - x;
        }
        int layoutOffset = layout.getOffset(x, p.y - box.getTextTop(), trailing);
        return box.offset + layoutOffset - this.getBidiPrefixLength(box, boxIndex);
    }

    private int findPreviousLineOffset(Point p, int[] trailing) {
        if (this.getBounds().y > p.y) {
            return -1;
        }
        TextFragmentBox closestBox = null;
        int index = 0;
        List<? extends TextFragmentBox> fragments = this.getFragmentsWithoutBorder();
        int i = fragments.size() - 1;
        while (i >= 0) {
            TextFragmentBox box = fragments.get(i);
            if (box.getBaseline() + box.getLineRoot().getDescent() < p.y && (closestBox == null || box.getBaseline() > closestBox.getBaseline() || box.getBaseline() == closestBox.getBaseline() && TextFlow.hDistanceBetween(box, p.x) < TextFlow.hDistanceBetween(closestBox, p.x))) {
                closestBox = box;
                index = i;
            }
            --i;
        }
        return this.findOffset(p, trailing, closestBox, index);
    }

    int getAscent() {
        return this.getTextUtilities().getAscent(this.getFont());
    }

    public BidiInfo getBidiInfo() {
        return this.bidiInfo;
    }

    private int getBidiPrefixLength(TextFragmentBox box, int index) {
        if (box.getBidiLevel() < 1) {
            return 0;
        }
        if (index > 0 || !this.bidiInfo.leadingJoiner) {
            return 1;
        }
        return 2;
    }

    protected String getBidiSubstring(TextFragmentBox box, int index) {
        if (box.getBidiLevel() < 1) {
            return this.getText().substring(box.offset, box.offset + box.length);
        }
        StringBuilder buffer = new StringBuilder(box.length + 3);
        buffer.append(box.isRightToLeft() ? (char)'\u202e' : '\u202d');
        if (index == 0 && this.bidiInfo.leadingJoiner) {
            buffer.append('\u200d');
        }
        buffer.append(this.getText().substring(box.offset, box.offset + box.length));
        if (index == this.getFragmentsWithoutBorder().size() - 1 && this.bidiInfo.trailingJoiner) {
            buffer.append('\u200d');
        }
        return buffer.toString();
    }

    public CaretInfo getCaretPlacement(int offset, boolean trailing) {
        TextFragmentBox box;
        if (offset < 0 || offset > this.getText().length()) {
            throw new IllegalArgumentException("Offset: " + offset + " is invalid");
        }
        if (offset == this.getText().length()) {
            trailing = false;
        }
        List<? extends TextFragmentBox> fragments = this.getFragmentsWithoutBorder();
        int i = fragments.size();
        do {
            box = fragments.get(--i);
        } while (offset < box.offset && i > 0);
        if (trailing && box.offset + box.length <= offset) {
            box = fragments.get(++i);
            offset = box.offset;
            trailing = false;
        }
        Point where = this.getPointInBox(box, offset, i, trailing);
        CaretInfo info = new CaretInfo(where.x, where.y, box.getAscent(), box.getDescent(), box.getLineRoot().getAscent(), box.getLineRoot().getDescent());
        this.translateToAbsolute(info);
        return info;
    }

    Point getPointInBox(TextFragmentBox box, int offset, int index, boolean trailing) {
        offset -= box.offset;
        offset = Math.min(box.length, offset);
        Point result = new Point(0, box.getTextTop());
        if (this.bidiInfo == null) {
            if (trailing && offset < box.length) {
                ++offset;
            }
            String substring = this.getText().substring(box.offset, box.offset + offset);
            result.x = this.getTextUtilities().getTextExtents((String)substring, (Font)this.getFont()).width;
        } else {
            TextLayout layout = FlowUtilities.getTextLayout();
            layout.setFont(this.getFont());
            String fragString = this.getBidiSubstring(box, index);
            layout.setText(fragString);
            result.x = layout.getLocation((int)(offset += this.getBidiPrefixLength((TextFragmentBox)box, (int)index)), (boolean)trailing).x;
            if (this.isMirrored()) {
                result.x = box.width - result.x;
            }
        }
        result.x += box.getX();
        return result;
    }

    int getDescent() {
        return this.getTextUtilities().getDescent(this.getFont());
    }

    public int getFirstOffsetForLine(int baseline) {
        for (TextFragmentBox textFragmentBox : this.getFragmentsWithoutBorder()) {
            if (baseline != textFragmentBox.getBaseline()) continue;
            return textFragmentBox.offset;
        }
        return -1;
    }

    public List<? extends TextFragmentBox> getFragments() {
        return super.getFragments();
    }

    protected List<? extends TextFragmentBox> getFragmentsWithoutBorder() {
        List<? extends TextFragmentBox> fragments = this.getFragments();
        if (this.getBorder() != null) {
            fragments = fragments.subList(1, fragments.size() - 1);
        }
        return fragments;
    }

    public int getLastOffsetForLine(int baseline) {
        List<? extends TextFragmentBox> fragments = this.getFragmentsWithoutBorder();
        int i = fragments.size() - 1;
        while (i >= 0) {
            TextFragmentBox box = fragments.get(i);
            if (baseline == box.getBaseline()) {
                return box.offset + box.length - 1;
            }
            --i;
        }
        return -1;
    }

    public int getNextOffset(Point p, boolean down, int[] trailing) {
        return down ? this.findNextLineOffset(p, trailing) : this.findPreviousLineOffset(p, trailing);
    }

    public int getNextVisibleOffset(int offset) {
        for (TextFragmentBox textFragmentBox : this.getFragmentsWithoutBorder()) {
            if (textFragmentBox.offset + textFragmentBox.length <= offset) continue;
            return Math.max(textFragmentBox.offset, offset + 1);
        }
        return -1;
    }

    public int getOffset(Point p, int[] trailing, Dimension proximity) {
        if (proximity == null) {
            proximity = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        TextFragmentBox closestBox = null;
        int index = 0;
        int i = 0;
        int size = this.fragments.size();
        if (this.getBorder() instanceof FlowBorder) {
            ++i;
            --size;
        }
        while (i < size) {
            TextFragmentBox box = (TextFragmentBox)this.fragments.get(i);
            int dy = TextFlow.vDistanceBetween(box, p.y);
            if (dy <= proximity.height) {
                int dx = TextFlow.hDistanceBetween(box, p.x);
                if (dy != proximity.height || dx < proximity.width) {
                    proximity.height = dy;
                    proximity.width = dx;
                    closestBox = box;
                    index = i;
                }
            }
            ++i;
        }
        return this.findOffset(p, trailing, closestBox, index);
    }

    public int getPreviousVisibleOffset(int offset) {
        if (offset == -1) {
            offset = Integer.MAX_VALUE;
        }
        List<? extends TextFragmentBox> fragments = this.getFragmentsWithoutBorder();
        int i = fragments.size() - 1;
        while (i >= 0) {
            TextFragmentBox box = fragments.get(i);
            if (box.offset < offset) {
                return Math.min(box.offset + box.length, offset - 1);
            }
            --i;
        }
        return -1;
    }

    public String getText() {
        return this.text;
    }

    int getVisibleAscent() {
        Border border = this.getBorder();
        if (border instanceof FlowBorder) {
            FlowBorder border2 = (FlowBorder)border;
            return border2.getInsets((IFigure)this).top + this.getAscent();
        }
        return this.getAscent();
    }

    int getVisibleDescent() {
        Border border = this.getBorder();
        if (border instanceof FlowBorder) {
            FlowBorder border2 = (FlowBorder)border;
            return border2.getInsets((IFigure)this).bottom + this.getDescent();
        }
        return this.getDescent();
    }

    private static int hDistanceBetween(TextFragmentBox box, int x) {
        if (x < box.getX()) {
            return box.getX() - x;
        }
        return Math.max(0, x - (box.getX() + box.getWidth()));
    }

    public boolean isTextTruncated() {
        for (TextFragmentBox textFragmentBox : this.getFragmentsWithoutBorder()) {
            if (!textFragmentBox.isTruncated()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void paintFigure(Graphics g) {
        g.getClip(Rectangle.SINGLETON);
        int yStart = Rectangle.SINGLETON.y;
        int yEnd = Rectangle.SINGLETON.bottom();
        int i = 0;
        while (i < this.fragments.size()) {
            TextFragmentBox frag = (TextFragmentBox)this.fragments.get(i);
            if (frag.offset != -1 && yStart <= frag.getLineRoot().getVisibleBottom() + 1) {
                if (yEnd < frag.getLineRoot().getVisibleTop()) break;
                Object draw = this.getBidiSubstring(frag, i);
                if (frag.isTruncated()) {
                    draw = (String)draw + ELLIPSIS;
                }
                if (!this.isEnabled()) {
                    Color fgColor = g.getForegroundColor();
                    g.setForegroundColor(ColorConstants.buttonLightest);
                    this.paintText(g, (String)draw, frag.getX() + 1, frag.getBaseline() - this.getAscent() + 1, frag.getBidiLevel());
                    g.setForegroundColor(ColorConstants.buttonDarker);
                    this.paintText(g, (String)draw, frag.getX(), frag.getBaseline() - this.getAscent(), frag.getBidiLevel());
                    g.setForegroundColor(fgColor);
                } else {
                    this.paintText(g, (String)draw, frag.getX(), frag.getBaseline() - this.getAscent(), frag.getBidiLevel());
                }
            }
            ++i;
        }
    }

    @Override
    protected void paintSelection(Graphics graphics) {
        if (this.selectionStart == -1) {
            return;
        }
        graphics.setXORMode(true);
        graphics.setBackgroundColor(ColorConstants.white);
        int i = 0;
        while (i < this.fragments.size()) {
            TextFragmentBox frag = (TextFragmentBox)this.fragments.get(i);
            if (frag.offset + frag.length > this.selectionStart) {
                if (frag.offset > this.selectionEnd) {
                    return;
                }
                if (this.selectionStart <= frag.offset && this.selectionEnd >= frag.offset + frag.length) {
                    int y = frag.getLineRoot().getVisibleTop();
                    int height = frag.getLineRoot().getVisibleBottom() - y;
                    graphics.fillRectangle(frag.getX(), y, frag.getWidth(), height);
                } else if (this.selectionEnd > frag.offset && this.selectionStart < frag.offset + frag.length) {
                    Point p1 = this.getPointInBox(frag, Math.max(frag.offset, this.selectionStart), i, false);
                    Point p2 = this.getPointInBox(frag, Math.min(frag.offset + frag.length, this.selectionEnd) - 1, i, true);
                    Rectangle rect = new Rectangle(p1, p2);
                    --rect.width;
                    rect.y = frag.getLineRoot().getVisibleTop();
                    rect.height = frag.getLineRoot().getVisibleBottom() - rect.y;
                    graphics.fillRectangle(rect);
                }
            }
            ++i;
        }
    }

    protected void paintText(Graphics g, String draw, int x, int y, int bidiLevel) {
        if (bidiLevel == -1) {
            g.drawText(draw, x, y);
        } else {
            TextLayout tl = FlowUtilities.getTextLayout();
            if (this.isMirrored()) {
                tl.setOrientation(0x4000000);
            }
            tl.setFont(g.getFont());
            tl.setText(draw);
            g.drawTextLayout(tl, x, y);
        }
    }

    @Override
    public void setBidiInfo(BidiInfo info) {
        this.bidiInfo = info;
    }

    @Override
    public void setSelection(int start, int end) {
        boolean repaint = false;
        if (this.selectionStart == start) {
            if (this.selectionEnd == end) {
                return;
            }
            repaint = true;
        } else {
            repaint = this.selectionStart != this.selectionEnd || start != end;
        }
        this.selectionStart = start;
        this.selectionEnd = end;
        if (repaint) {
            this.repaint();
        }
    }

    public void setText(String s) {
        if (s != null && !s.equals(this.text)) {
            this.text = s;
            this.revalidateBidi(this);
            this.repaint();
        }
    }

    public String toString() {
        return this.text;
    }

    private static int vDistanceBetween(TextFragmentBox box, int y) {
        int top = box.getBaseline() - box.getLineRoot().getAscent();
        if (y < top) {
            return top - y;
        }
        return Math.max(0, y - (box.getBaseline() + box.getLineRoot().getDescent()));
    }

    protected FlowUtilities getFlowUtilities() {
        return FlowUtilities.INSTANCE;
    }

    protected TextUtilities getTextUtilities() {
        return TextUtilities.INSTANCE;
    }
}

