/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.mirroring;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.p2.internal.repository.mirroring.IArtifactMirrorLog;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;

public class FileMirrorLog
implements IArtifactMirrorLog {
    private static final String INDENT = "\t";
    private static final String SEPARATOR = System.lineSeparator();
    private BufferedWriter out;
    private boolean consoleMessage;
    private int minSeverity;
    private boolean hasRoot;

    public FileMirrorLog(String location, int minSeverity, String root) {
        block4: {
            this.consoleMessage = false;
            this.minSeverity = 0;
            this.hasRoot = false;
            this.minSeverity = minSeverity;
            try {
                File log = new File(location);
                if (log.getParentFile().exists() || log.getParentFile().mkdirs()) {
                    this.out = new BufferedWriter(new FileWriter(log, true));
                    if (root != null) {
                        this.log(root + " - " + String.valueOf(new Date()));
                        this.hasRoot = true;
                    }
                    break block4;
                }
                throw new IOException(Messages.exception_unableToCreateParentDir);
            }
            catch (IOException e) {
                this.exceptionOccurred(null, e);
            }
        }
    }

    @Override
    public void log(IArtifactDescriptor descriptor, IStatus status) {
        if (status.getSeverity() >= this.minSeverity) {
            this.log(descriptor.toString());
            this.log(status, INDENT);
        }
    }

    @Override
    public void log(IStatus status) {
        this.log(status, "");
    }

    private void log(IStatus status, String prefix) {
        if (status.getSeverity() >= this.minSeverity) {
            IStatus[] nestedStatus;
            String exceptionMessage;
            this.log(prefix + status.getMessage());
            String string = exceptionMessage = status.getException() != null ? status.getException().getMessage() : null;
            if (exceptionMessage != null) {
                this.log(prefix + exceptionMessage);
            }
            if ((nestedStatus = status.getChildren()) != null) {
                IStatus[] iStatusArray = nestedStatus;
                int n = nestedStatus.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus s = iStatusArray[n2];
                    this.log(s, prefix + INDENT);
                    ++n2;
                }
            }
        }
    }

    private void log(String message) {
        try {
            this.out.write((this.hasRoot ? INDENT : "") + message + SEPARATOR);
        }
        catch (IOException e) {
            this.exceptionOccurred((this.hasRoot ? INDENT : "") + message, e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            this.exceptionOccurred(null, e);
        }
    }

    private void exceptionOccurred(String message, Exception e) {
        if (!this.consoleMessage) {
            System.err.println(Messages.MirrorLog_Exception_Occurred);
            e.printStackTrace(System.err);
            System.err.println(Messages.MirrorLog_Console_Log);
            this.consoleMessage = true;
        }
        if (message != null) {
            System.out.println(message);
        }
    }
}

