/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.factory.SingletonFactory;

@FunctionalInterface
public interface StringParser<T>
extends Function<String, T> {
    public static final String PRODUCT_GROUP = "org.eclipse.net4j.util.stringParsers";
    public static final StringParser<String> IDENTITY = str -> str;
    public static final StringParser<Character> CHARACTER = str -> Character.valueOf(str.charAt(0));
    public static final StringParser<Boolean> BOOLEAN = string -> Boolean.parseBoolean(string);
    public static final StringParser<Byte> BYTE = str -> str.startsWith("0x") ? Byte.parseByte(str.substring(2), 16) : (str.startsWith("0b") ? Byte.parseByte(str.substring(2), 2) : Byte.parseByte(str));
    public static final StringParser<Short> SHORT = str -> str.startsWith("0x") ? Short.parseShort(str.substring(2), 16) : (str.startsWith("0b") ? Short.parseShort(str.substring(2), 2) : Short.parseShort(str));
    public static final StringParser<Integer> INTEGER = str -> str.startsWith("0x") ? Integer.parseInt(str.substring(2), 16) : (str.startsWith("0b") ? Integer.parseInt(str.substring(2), 2) : Integer.parseInt(str));
    public static final StringParser<Long> LONG = str -> str.startsWith("0x") ? Long.parseLong(str.substring(2), 16) : (str.startsWith("0b") ? Long.parseLong(str.substring(2), 2) : Long.parseLong(str));
    public static final StringParser<Float> FLOAT = string -> Float.valueOf(Float.parseFloat(string));
    public static final StringParser<Double> DOUBLE = string -> Double.parseDouble(string);
    public static final StringParser<BigInteger> BIG_INTEGER = str -> str.startsWith("0x") ? new BigInteger(str.substring(2), 16) : (str.startsWith("0b") ? new BigInteger(str.substring(2), 2) : new BigInteger(str));
    public static final StringParser<BigDecimal> BIG_DECIMAL = string -> new BigDecimal(string);
    public static final StringParser<Path> PATH = str -> FileSystems.getDefault().getPath(str, new String[0]);
    public static final StringParser<File> FILE = string -> new File(string);

    @Override
    public T apply(String var1);

    default public StringParser<T> safe() {
        return str -> str == null ? null : this.apply(str);
    }

    public static <T> StringParser<T> safe(StringParser<T> other) {
        Objects.requireNonNull(other);
        return other.safe();
    }

    public static final class EnumStringParser<T extends Enum<T>>
    implements StringParser<T> {
        public static final boolean DEFAULT_CASE_SENSITIVE = false;
        private final Class<T> enumType;
        private final boolean caseSensitive;

        public EnumStringParser(Class<T> enumType, boolean caseSensitive) {
            this.enumType = enumType;
            this.caseSensitive = caseSensitive;
        }

        public EnumStringParser(Class<T> enumType) {
            this(enumType, false);
        }

        public Class<T> getEnumType() {
            return this.enumType;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        @Override
        public T apply(String str) {
            if (!this.caseSensitive) {
                Enum[] enumArray = (Enum[])this.enumType.getEnumConstants();
                int n = enumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Enum t = enumArray[n2];
                    if (t.name().equalsIgnoreCase(str)) {
                        return (T)t;
                    }
                    ++n2;
                }
                throw new IllegalArgumentException("No enum constant " + this.enumType.getCanonicalName() + "." + str);
            }
            return Enum.valueOf(this.enumType, str);
        }
    }

    public static final class MetaFactory
    extends org.eclipse.net4j.util.factory.MetaFactory {
        private static final String PG = "org.eclipse.net4j.util.stringParsers";
        private static final IFactory[] CHILDREN = new IFactory[]{new SingletonFactory("org.eclipse.net4j.util.stringParsers", "identity", IDENTITY), new SingletonFactory("org.eclipse.net4j.util.stringParsers", String.class.getName(), IDENTITY), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Character.TYPE.getName(), CHARACTER), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Character.class.getName(), CHARACTER), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Boolean.TYPE.getName(), BOOLEAN), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Boolean.class.getName(), BOOLEAN), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Byte.TYPE.getName(), BYTE), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Byte.class.getName(), BYTE), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Short.TYPE.getName(), SHORT), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Short.class.getName(), SHORT), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Integer.TYPE.getName(), INTEGER), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Integer.class.getName(), INTEGER), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Long.TYPE.getName(), LONG), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Long.class.getName(), LONG), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Float.TYPE.getName(), FLOAT), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Float.class.getName(), FLOAT), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Double.TYPE.getName(), DOUBLE), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Double.class.getName(), DOUBLE), new SingletonFactory("org.eclipse.net4j.util.stringParsers", BigInteger.class.getName(), BIG_INTEGER), new SingletonFactory("org.eclipse.net4j.util.stringParsers", BigDecimal.class.getName(), BIG_DECIMAL), new SingletonFactory("org.eclipse.net4j.util.stringParsers", Path.class.getName(), PATH), new SingletonFactory("org.eclipse.net4j.util.stringParsers", File.class.getName(), FILE)};

        public MetaFactory() {
            super("org.eclipse.net4j.util.stringParsers");
        }

        @Override
        public IFactory[] create(String description) throws ProductCreationException {
            return CHILDREN;
        }
    }
}

