/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.CodeStyleFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class CodeStyleCleanUpCore
extends AbstractMultiFix {
    public CodeStyleCleanUpCore() {
    }

    public CodeStyleCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.requireAST();
        Map<String, String> requiredOptions = requireAST ? this.getRequiredOptions() : null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    private boolean requireAST() {
        boolean nonStaticFields = this.isEnabled("cleanup.use_this_for_non_static_field_access");
        boolean nonStaticMethods = this.isEnabled("cleanup.use_this_for_non_static_method_access");
        boolean qualifyStatic = this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class");
        return nonStaticFields && this.isEnabled("cleanup.always_use_this_for_non_static_field_access") || qualifyStatic && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class") || qualifyStatic && this.isEnabled("cleanup.qualify_static_field_accesses_with_declaring_class") || qualifyStatic && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class") || nonStaticMethods && this.isEnabled("cleanup.always_use_this_for_non_static_method_access") || qualifyStatic && this.isEnabled("cleanup.qualify_static_method_accesses_with_declaring_class") || nonStaticFields && this.isEnabled("cleanup.use_this_for_non_static_field_access_only_if_necessary") || nonStaticMethods && this.isEnabled("cleanup.use_this_for_non_static_method_access_only_if_necessary");
    }

    @Override
    public ICleanUpFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean nonStaticFields = this.isEnabled("cleanup.use_this_for_non_static_field_access");
        boolean nonStaticMethods = this.isEnabled("cleanup.use_this_for_non_static_method_access");
        boolean qualifyStatic = this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class");
        return CodeStyleFixCore.createCleanUp(compilationUnit, nonStaticFields && this.isEnabled("cleanup.always_use_this_for_non_static_field_access"), qualifyStatic && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class"), qualifyStatic && this.isEnabled("cleanup.qualify_static_field_accesses_with_declaring_class"), qualifyStatic && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class"), nonStaticMethods && this.isEnabled("cleanup.always_use_this_for_non_static_method_access"), qualifyStatic && this.isEnabled("cleanup.qualify_static_method_accesses_with_declaring_class"), nonStaticFields && this.isEnabled("cleanup.use_this_for_non_static_field_access_only_if_necessary"), nonStaticMethods && this.isEnabled("cleanup.use_this_for_non_static_method_access_only_if_necessary"));
    }

    @Override
    public ICleanUpFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return CodeStyleFixCore.createCleanUp(compilationUnit, problems, this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.always_use_this_for_non_static_field_access"), this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class"), this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class"));
    }

    private Map<String, String> getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class")) {
            result.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "warning");
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class")) {
            result.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", "warning");
        }
        return result;
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.always_use_this_for_non_static_field_access")) {
            result.add(MultiFixMessages.CodeStyleMultiFix_AddThisQualifier_description);
        }
        if (this.isEnabled("cleanup.use_this_for_non_static_method_access") && this.isEnabled("cleanup.always_use_this_for_non_static_method_access")) {
            result.add(MultiFixMessages.CodeStyleCleanUp_QualifyNonStaticMethod_description);
        }
        if (this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.use_this_for_non_static_field_access_only_if_necessary")) {
            result.add(MultiFixMessages.CodeStyleCleanUp_removeFieldThis_description);
        }
        if (this.isEnabled("cleanup.use_this_for_non_static_method_access") && this.isEnabled("cleanup.use_this_for_non_static_method_access_only_if_necessary")) {
            result.add(MultiFixMessages.CodeStyleCleanUp_removeMethodThis_description);
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_field_accesses_with_declaring_class")) {
            result.add(MultiFixMessages.CodeStyleMultiFix_QualifyAccessToStaticField);
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_method_accesses_with_declaring_class")) {
            result.add(MultiFixMessages.CodeStyleCleanUp_QualifyStaticMethod_description);
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class")) {
            result.add(MultiFixMessages.CodeStyleMultiFix_ChangeNonStaticAccess_description);
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class")) {
            result.add(MultiFixMessages.CodeStyleMultiFix_ChangeIndirectAccessToStaticToDirect);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuilder buf = new StringBuilder();
        buf.append("private int value;\n");
        buf.append("public int get() {\n");
        if (this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.always_use_this_for_non_static_field_access")) {
            buf.append("    return this.value + this.value;\n");
        } else if (this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.use_this_for_non_static_field_access_only_if_necessary")) {
            buf.append("    return value + value;\n");
        } else {
            buf.append("    return this.value + value;\n");
        }
        buf.append("}\n");
        buf.append("\n");
        buf.append("public int getZero() {\n");
        if (this.isEnabled("cleanup.use_this_for_non_static_method_access") && this.isEnabled("cleanup.always_use_this_for_non_static_method_access")) {
            buf.append("    return this.get() - this.get();\n");
        } else if (this.isEnabled("cleanup.use_this_for_non_static_method_access") && this.isEnabled("cleanup.use_this_for_non_static_method_access_only_if_necessary")) {
            buf.append("    return get() - get();\n");
        } else {
            buf.append("    return this.get() - get();\n");
        }
        buf.append("}\n");
        buf.append("\n");
        buf.append("class E {\n");
        buf.append("    public static int NUMBER;\n");
        buf.append("    public static void set(int i) {\n");
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_field_accesses_with_declaring_class")) {
            buf.append("        E.NUMBER= i;\n");
        } else {
            buf.append("        NUMBER= i;\n");
        }
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    public void reset() {\n");
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_method_accesses_with_declaring_class")) {
            buf.append("        E.set(0);\n");
        } else {
            buf.append("        set(0);\n");
        }
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("\n");
        buf.append("class ESub extends E {\n");
        buf.append("    public void reset() {\n");
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class")) {
            buf.append("        E.NUMBER= 0;\n");
        } else {
            buf.append("        ESub.NUMBER= 0;\n");
        }
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("\n");
        buf.append("public void dec() {\n");
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class")) {
            buf.append("    E.NUMBER--;\n");
        } else {
            buf.append("    (new E()).NUMBER--;\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        if (570425423 == problem.getProblemId()) {
            return this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.always_use_this_for_non_static_field_access");
        }
        if (CodeStyleFixCore.isIndirectStaticAccess(problem)) {
            return this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class");
        }
        if (CodeStyleFixCore.isNonStaticAccess(problem)) {
            return this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class");
        }
        return false;
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        int id;
        IProblem problem;
        int n;
        int n2;
        IProblem[] iProblemArray;
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.always_use_this_for_non_static_field_access")) {
            result += CodeStyleCleanUpCore.getNumberOfProblems(problems, 570425423);
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class")) {
            iProblemArray = problems;
            n2 = problems.length;
            n = 0;
            while (n < n2) {
                problem = iProblemArray[n];
                id = problem.getID();
                if (id == 570425422 || id == 603979895) {
                    ++result;
                }
                ++n;
            }
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class")) {
            iProblemArray = problems;
            n2 = problems.length;
            n = 0;
            while (n < n2) {
                problem = iProblemArray[n];
                id = problem.getID();
                if (id == 570425420 || id == 603979893) {
                    ++result;
                }
                ++n;
            }
        }
        return result;
    }
}

