/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public final class GMFNotationHelper {
    private GMFNotationHelper() {
    }

    public static int getX(Node gmfView) {
        if (gmfView.getLayoutConstraint() instanceof Bounds) {
            Bounds nodeBounds = (Bounds)gmfView.getLayoutConstraint();
            return nodeBounds.getX();
        }
        return 0;
    }

    public static int getY(Node gmfView) {
        if (gmfView.getLayoutConstraint() instanceof Bounds) {
            Bounds nodeBounds = (Bounds)gmfView.getLayoutConstraint();
            return nodeBounds.getY();
        }
        return 0;
    }

    public static int getWidth(Node gmfView) {
        if (gmfView.getLayoutConstraint() instanceof Bounds) {
            Bounds nodeBounds = (Bounds)gmfView.getLayoutConstraint();
            return nodeBounds.getWidth();
        }
        return 0;
    }

    public static int getHeight(Node gmfView) {
        if (gmfView.getLayoutConstraint() instanceof Bounds) {
            Bounds nodeBounds = (Bounds)gmfView.getLayoutConstraint();
            return nodeBounds.getHeight();
        }
        return 0;
    }

    public static String getNoteDescription(Node note) {
        for (Object obj : note.getStyles()) {
            if (!(obj instanceof ShapeStyle)) continue;
            return ((ShapeStyle)obj).getDescription();
        }
        return "";
    }

    public static Collection<Shape> getNotes(Diagram gmfDiagram) {
        ArrayList<Shape> result = new ArrayList<Shape>();
        TreeIterator it = gmfDiagram.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof Shape) || !GMFNotationHelper.isNote((Node)((Shape)obj))) continue;
            result.add((Shape)obj);
        }
        return result;
    }

    public static Collection<Shape> getTextNotes(Diagram gmfDiagram) {
        ArrayList<Shape> result = new ArrayList<Shape>();
        TreeIterator it = gmfDiagram.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof Shape) || !GMFNotationHelper.isTextNote((Node)((Shape)obj))) continue;
            result.add((Shape)obj);
        }
        return result;
    }

    public static Collection<Edge> getNotesAttachments(Diagram gmfDiagram) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        TreeIterator it = gmfDiagram.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof Edge) || !GMFNotationHelper.isNoteAttachment((Edge)obj)) continue;
            result.add((Edge)obj);
        }
        return result;
    }

    public static boolean isNoteAttachment(Edge obj) {
        return ViewType.NOTEATTACHMENT.equals(obj.getType());
    }

    public static boolean isNote(Node node) {
        return ViewType.NOTE.equals(node.getType());
    }

    public static boolean isTextNote(Node node) {
        return ViewType.TEXT.equals(node.getType());
    }

    @Deprecated
    public static Diagram findGMFDiagram(EObject eObject) {
        TreeIterator it = eObject.eResource().getAllContents();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof Diagram) || ((Diagram)obj).getElement() != eObject) continue;
            return (Diagram)obj;
        }
        return null;
    }

    public static Collection<Diagram> getGMFDiagrams(Resource resource) {
        ArrayList<Diagram> result = new ArrayList<Diagram>();
        TreeIterator it = resource.getAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof Diagram)) continue;
            result.add((Diagram)obj);
        }
        return result;
    }

    public static Node createNote(View container, String noteText) {
        Node note = ViewService.createNode((View)container, (String)ViewType.NOTE, (PreferencesHint)PreferencesHint.USE_DEFAULTS);
        for (Object cur : note.getStyles()) {
            if (!(cur instanceof ShapeStyle)) continue;
            ((ShapeStyle)cur).setDescription(noteText);
        }
        return note;
    }

    public static Node createTextNote(View container, String noteText) {
        Node textnote = ViewService.createNode((View)container, (String)ViewType.TEXT, (PreferencesHint)PreferencesHint.USE_DEFAULTS);
        for (Object cur : textnote.getStyles()) {
            if (!(cur instanceof ShapeStyle)) continue;
            ((ShapeStyle)cur).setDescription(noteText);
        }
        return textnote;
    }

    public static Node createNote(Diagram container, String noteText, IPreferenceStore preferencesStore) {
        Node note = GMFNotationHelper.createNote((View)container, noteText);
        if (note instanceof Shape) {
            Shape shape = (Shape)note;
            shape.setDescription(noteText);
            RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)preferencesStore, (String)"Appearance.noteFillColor");
            int fillColor = FigureUtilities.RGBToInteger((RGB)fillRGB);
            shape.setFillColor(fillColor);
            RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)preferencesStore, (String)"Appearance.noteLineColor");
            int lineColor = FigureUtilities.RGBToInteger((RGB)lineRGB);
            shape.setLineColor(lineColor);
        }
        return note;
    }

    public static LayoutConstraint createLayoutPosition(BigInteger x, BigInteger y, BigInteger width, BigInteger height) {
        Bounds layout = NotationFactory.eINSTANCE.createBounds();
        layout.setX(x.intValue());
        layout.setY(y.intValue());
        layout.setWidth(width.intValue());
        layout.setHeight(height.intValue());
        return layout;
    }

    public static Node findGMFNode(Diagram diagram, EObject modelElement) {
        TreeIterator it = diagram.eAllContents();
        while (it.hasNext()) {
            EObject cur = (EObject)it.next();
            if (!(cur instanceof Node) || ((Node)cur).getElement() != modelElement) continue;
            return (Node)cur;
        }
        return null;
    }

    public static void createNoteAttachment(Node note, Node target) {
        ViewService.createEdge((View)note, (View)target, (String)ViewType.NOTEATTACHMENT, (PreferencesHint)PreferencesHint.USE_DEFAULTS);
    }

    public static Point getAbsoluteLocation(Node node) {
        Point location = new Point(0, 0);
        Node current = node;
        while (current instanceof Node) {
            if (current.getLayoutConstraint() instanceof Location) {
                Location nodeLocation = (Location)current.getLayoutConstraint();
                location.setX(location.x + nodeLocation.getX());
                location.setY(location.y + nodeLocation.getY());
            }
            current = current.eContainer();
        }
        return location;
    }

    public static Bounds getCopy(Bounds bounds) {
        Bounds copy = NotationFactory.eINSTANCE.createBounds();
        copy.setX(bounds.getX());
        copy.setY(bounds.getY());
        copy.setWidth(bounds.getWidth());
        copy.setHeight(bounds.getHeight());
        return copy;
    }

    public static Location getCopy(Location location) {
        Location copy = NotationFactory.eINSTANCE.createLocation();
        copy.setX(location.getX());
        copy.setY(location.getY());
        return copy;
    }

    public static Size getCopy(Size size) {
        Size copy = NotationFactory.eINSTANCE.createSize();
        copy.setWidth(size.getWidth());
        copy.setHeight(size.getHeight());
        return copy;
    }
}

