/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.AttributeMap;
import org.eclipse.mylyn.internal.tasks.core.ITaskRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;

public class RepositoryQuery
extends AbstractTaskContainer
implements IRepositoryQuery,
ITaskRepositoryElement {
    private final String connectorKind;
    protected String lastSynchronizedStamp = "<never>";
    protected String repositoryUrl;
    protected IStatus status;
    private boolean synchronizing;
    private String summary;
    private AttributeMap attributeMap;

    public RepositoryQuery(String connectorKind, String handle) {
        super(handle);
        this.connectorKind = connectorKind;
        this.setSummary(handle);
    }

    @Override
    public String getConnectorKind() {
        return this.connectorKind;
    }

    public String getLastSynchronizedTimeStamp() {
        return this.lastSynchronizedStamp;
    }

    @Override
    public String getPriority() {
        if (super.isEmpty()) {
            return ITask.PriorityLevel.P1.toString();
        }
        String highestPriority = ITask.PriorityLevel.P5.toString();
        for (ITask hit : this.getChildren()) {
            if (highestPriority.compareTo(hit.getPriority()) <= 0) continue;
            highestPriority = hit.getPriority();
        }
        return highestPriority;
    }

    @Override
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public boolean isSynchronizing() {
        return this.synchronizing;
    }

    public void setLastSynchronizedStamp(String lastRefreshTimeStamp) {
        this.lastSynchronizedStamp = lastRefreshTimeStamp;
    }

    public void setRepositoryUrl(String newRepositoryUrl) {
        String url = this.getUrl();
        if (this.repositoryUrl != null && url != null && url.startsWith(this.repositoryUrl)) {
            this.setUrl(newRepositoryUrl + url.substring(this.repositoryUrl.length()));
        }
        this.repositoryUrl = newRepositoryUrl;
    }

    public void setStatus(IStatus status) {
        this.status = status;
    }

    public void setSynchronizing(boolean synchronizing) {
        this.synchronizing = synchronizing;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public synchronized String getAttribute(String key) {
        return this.attributeMap != null ? this.attributeMap.getAttribute(key) : null;
    }

    @Override
    public synchronized Map<String, String> getAttributes() {
        if (this.attributeMap != null) {
            return this.attributeMap.getAttributes();
        }
        return Collections.emptyMap();
    }

    @Override
    public synchronized void setAttribute(String key, String value) {
        if (this.attributeMap == null) {
            this.attributeMap = new AttributeMap();
        }
        this.attributeMap.setAttribute(key, value);
    }

    public boolean getAutoUpdate() {
        String value = this.getAttribute("org.eclipse.mylyn.tasks.core.synchronization.auto");
        return value == null || Boolean.valueOf(value) != false;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.setAttribute("org.eclipse.mylyn.tasks.core.synchronization.auto", Boolean.toString(autoUpdate));
    }
}

