/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.product.ISplashHandlerConstants;

public class UpdateSplashHandlerAction
extends Action
implements ISplashHandlerConstants {
    private IPluginModelBase fModel;
    private IProgressMonitor fMonitor;
    private CoreException fException;
    private String fFieldID;
    private String fFieldSplashID;
    private String fFieldProductID;
    private String fFieldClass;
    private String fFieldTemplate;
    private String fFieldPluginID;

    public UpdateSplashHandlerAction() {
        this.reset();
    }

    public void setFieldID(String fieldID) {
        this.fFieldID = fieldID;
    }

    public void setFieldSplashID(String fieldSplashID) {
        this.fFieldSplashID = fieldSplashID;
    }

    public void setFieldProductID(String fieldProductID) {
        this.fFieldProductID = fieldProductID;
    }

    public void setFieldClass(String fieldClass) {
        this.fFieldClass = fieldClass;
    }

    public void setFieldTemplate(String fieldTemplate) {
        this.fFieldTemplate = fieldTemplate;
    }

    public void setFieldPluginID(String fieldPluginID) {
        this.fFieldPluginID = fieldPluginID;
    }

    public void reset() {
        this.fModel = null;
        this.fMonitor = null;
        this.fException = null;
        this.fFieldID = null;
        this.fFieldClass = null;
        this.fFieldSplashID = null;
        this.fFieldProductID = null;
        this.fFieldTemplate = null;
        this.fFieldPluginID = null;
    }

    public void setModel(IPluginModelBase model) {
        this.fModel = model;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.fMonitor = monitor;
    }

    public void run() {
        try {
            this.updateModel();
        }
        catch (CoreException e) {
            this.fException = e;
        }
    }

    public void hasException() throws CoreException {
        if (this.fException != null) {
            throw this.fException;
        }
    }

    private void updateModel() throws CoreException {
        IPluginExtension extension = this.findFirstExtension("org.eclipse.ui.splashHandlers");
        if (extension == null) {
            this.addExtensionSplashHandlers();
        } else {
            this.modifyExtensionSplashHandlers(extension);
        }
        if (UpdateSplashHandlerAction.isExtensibleTemplateSelected(this.fFieldTemplate)) {
            String fullExtensionPointID;
            IPluginExtension extensionSplash;
            IPluginExtensionPoint extensionPoint = this.findFirstExtensionPoint("splashExtension");
            if (extensionPoint == null) {
                this.addExtensionPointSplashExtension();
            }
            if ((extensionSplash = this.findFirstExtension(fullExtensionPointID = this.fFieldPluginID + ".splashExtension")) == null) {
                this.addExtensionSplash();
            }
        }
    }

    private void addExtensionSplash() throws CoreException {
        String fullExtensionPointID = this.fFieldPluginID + ".splashExtension";
        this.fMonitor.beginTask(NLS.bind((String)PDEUIMessages.UpdateSplashHandlerInModelAction_msgAddingExtension, (Object)fullExtensionPointID), 1);
        IPluginExtension extension = this.createExtensionSplash();
        this.fModel.getPluginBase().add(extension);
        this.fMonitor.done();
    }

    private void addExtensionPointSplashExtension() throws CoreException {
        this.fMonitor.beginTask(NLS.bind((String)PDEUIMessages.UpdateSplashHandlerInModelAction_msgAddingExtensionPoint, (Object)"splashExtension"), 1);
        IPluginExtensionPoint extensionPoint = this.createExtensionPointSplash();
        this.fModel.getPluginBase().add(extensionPoint);
        this.fMonitor.done();
    }

    private IPluginExtensionPoint createExtensionPointSplash() throws CoreException {
        IPluginExtensionPoint extensionPoint = this.fModel.getFactory().createExtensionPoint();
        extensionPoint.setId("splashExtension");
        extensionPoint.setName(PDEUIMessages.UpdateSplashHandlerInModelAction_splashExtensionPointName);
        extensionPoint.setSchema("schema/splashExtension.exsd");
        return extensionPoint;
    }

    private IPluginExtension findFirstExtension(String extensionPointID) {
        IPluginExtension[] extensions;
        IPluginExtension[] iPluginExtensionArray = extensions = this.fModel.getPluginBase().getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            String point = extension.getPoint();
            if (extensionPointID.equals(point)) {
                return extension;
            }
            ++n2;
        }
        return null;
    }

    private IPluginExtensionPoint findFirstExtensionPoint(String extensionPointID) {
        IPluginExtensionPoint[] extensionPoints;
        IPluginExtensionPoint[] iPluginExtensionPointArray = extensionPoints = this.fModel.getPluginBase().getExtensionPoints();
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtensionPoint extensionPoint = iPluginExtensionPointArray[n2];
            String point = extensionPoint.getId();
            if (extensionPointID.equals(point)) {
                return extensionPoint;
            }
            ++n2;
        }
        return null;
    }

    private void addExtensionSplashHandlers() throws CoreException {
        this.fMonitor.beginTask(NLS.bind((String)PDEUIMessages.UpdateSplashHandlerInModelAction_msgAddingExtension, (Object)"org.eclipse.ui.splashHandlers"), 1);
        IPluginExtension extension = this.createExtensionSplashHandlers();
        this.fModel.getPluginBase().add(extension);
        this.fMonitor.done();
    }

    private IPluginExtension createExtensionSplashHandlers() throws CoreException {
        IPluginExtension extension = this.fModel.getFactory().createExtension();
        extension.setPoint("org.eclipse.ui.splashHandlers");
        this.createExtensionChildrenSplashHandlers(extension);
        return extension;
    }

    private void createExtensionChildrenSplashHandlers(IPluginExtension extension) throws CoreException {
        this.addElementSplashHandler(extension);
        this.addElementProductBinding(extension);
    }

    private void addElementSplashHandler(IPluginExtension extension) throws CoreException {
        IPluginElement splashHandlerElement = this.createElementSplashHandler(extension);
        if (splashHandlerElement != null) {
            extension.add(0, (IPluginObject)splashHandlerElement);
        }
    }

    private void addElementProductBinding(IPluginExtension extension) throws CoreException {
        IPluginElement productBindingElement = this.createElementProductBinding(extension);
        if (productBindingElement != null) {
            extension.add(1, (IPluginObject)productBindingElement);
        }
    }

    private IPluginElement createElementSplashHandler(IPluginExtension extension) throws CoreException {
        IPluginElement element = extension.getModel().getFactory().createElement((IPluginObject)extension);
        element.setName("splashHandler");
        element.setAttribute("id", this.fFieldID);
        element.setAttribute("class", this.fFieldClass);
        return element;
    }

    private IPluginElement createElementProductBinding(IPluginExtension extension) throws CoreException {
        IPluginElement element = extension.getModel().getFactory().createElement((IPluginObject)extension);
        element.setName("splashHandlerProductBinding");
        element.setAttribute("productId", this.fFieldProductID);
        element.setAttribute("splashId", this.fFieldSplashID);
        return element;
    }

    private void modifyExtensionSplashHandlers(IPluginExtension extension) throws CoreException {
        this.fMonitor.beginTask(NLS.bind((String)PDEUIMessages.UpdateSplashHandlerInModelAction_msgModifyingExtension, (Object)"org.eclipse.ui.splashHandlers"), 1);
        this.modifyExtensionChildrenSplashHandlers(extension);
        this.fMonitor.done();
    }

    private void modifyExtensionChildrenSplashHandlers(IPluginExtension extension) throws CoreException {
        IPluginElement splashHandlerElement = this.findSplashHandlerElement(extension);
        if (splashHandlerElement == null) {
            this.addElementSplashHandler(extension);
        } else {
            this.syncSplashHandlerElement(splashHandlerElement);
        }
        IPluginElement productBindingElement = this.findProductBindingElement(extension);
        this.removeMatchingProductBindingElements(extension);
        if (productBindingElement == null) {
            this.addElementProductBinding(extension);
        } else {
            this.syncProductBindingElement(productBindingElement);
        }
    }

    private void removeMatchingProductBindingElements(IPluginExtension extension) throws CoreException {
        IPluginObject[] pluginObjects;
        if (extension.getChildCount() == 0) {
            return;
        }
        IPluginObject[] iPluginObjectArray = pluginObjects = extension.getChildren();
        int n = pluginObjects.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginElement element;
            IPluginObject pluginObject = iPluginObjectArray[n2];
            if (pluginObject instanceof IPluginElement && (element = (IPluginElement)pluginObject).getName().equals("splashHandlerProductBinding")) {
                IPluginAttribute splashIDAttribute = element.getAttribute("splashId");
                IPluginAttribute productIDAttribute = element.getAttribute("productId");
                if (productIDAttribute == null || !PDETextHelper.isDefined((String)productIDAttribute.getValue()) || splashIDAttribute == null || !PDETextHelper.isDefined((String)splashIDAttribute.getValue())) {
                    extension.remove((IPluginObject)element);
                } else if (productIDAttribute.getValue().equals(this.fFieldProductID) && !splashIDAttribute.getValue().equals(this.fFieldSplashID)) {
                    extension.remove((IPluginObject)element);
                }
            }
            ++n2;
        }
    }

    private IPluginElement findSplashHandlerElement(IPluginExtension extension) {
        IPluginObject[] pluginObjects;
        if (extension.getChildCount() == 0) {
            return null;
        }
        IPluginObject[] iPluginObjectArray = pluginObjects = extension.getChildren();
        int n = pluginObjects.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginAttribute idAttribute;
            IPluginElement element;
            IPluginObject pluginObject = iPluginObjectArray[n2];
            if (pluginObject instanceof IPluginElement && (element = (IPluginElement)pluginObject).getName().equals("splashHandler") && (idAttribute = element.getAttribute("id")) != null && PDETextHelper.isDefined((String)idAttribute.getValue()) && idAttribute.getValue().equals(this.fFieldID)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private void syncSplashHandlerElement(IPluginElement element) throws CoreException {
        IPluginAttribute classAttribute = element.getAttribute("class");
        if (classAttribute != null && PDETextHelper.isDefined((String)classAttribute.getValue()) && classAttribute.getValue().equals(this.fFieldClass)) {
            return;
        }
        element.setAttribute("class", this.fFieldClass);
    }

    private void syncProductBindingElement(IPluginElement element) throws CoreException {
        IPluginAttribute productIDAttribute = element.getAttribute("productId");
        if (productIDAttribute != null && PDETextHelper.isDefined((String)productIDAttribute.getValue()) && productIDAttribute.getValue().equals(this.fFieldProductID)) {
            return;
        }
        element.setAttribute("productId", this.fFieldProductID);
    }

    private IPluginElement findProductBindingElement(IPluginExtension extension) {
        IPluginObject[] pluginObjects;
        if (extension.getChildCount() == 0) {
            return null;
        }
        IPluginObject[] iPluginObjectArray = pluginObjects = extension.getChildren();
        int n = pluginObjects.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginAttribute splashIDAttribute;
            IPluginElement element;
            IPluginObject pluginObject = iPluginObjectArray[n2];
            if (pluginObject instanceof IPluginElement && (element = (IPluginElement)pluginObject).getName().equals("splashHandlerProductBinding") && (splashIDAttribute = element.getAttribute("splashId")) != null && PDETextHelper.isDefined((String)splashIDAttribute.getValue()) && splashIDAttribute.getValue().equals(this.fFieldSplashID)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private IPluginExtension createExtensionSplash() throws CoreException {
        String fullExtensionPointID = this.fFieldPluginID + ".splashExtension";
        IPluginExtension extension = this.fModel.getFactory().createExtension();
        extension.setPoint(fullExtensionPointID);
        this.createExtensionChildrenSplash(extension);
        return extension;
    }

    private void createExtensionChildrenSplash(IPluginExtension extension) throws CoreException {
        IPluginElement splashElementRCP;
        IPluginElement splashElementLanguages;
        IPluginElement splashElementEnterprise;
        IPluginElement splashElementEmbedded;
        String iconsDir = "icons/";
        IPluginElement splashElementAf = this.createElementSplash(extension, "af", iconsDir + "af.png", PDEUIMessages.UpdateSplashHandlerInModelAction_nameApplicationFramework);
        if (splashElementAf != null) {
            extension.add((IPluginObject)splashElementAf);
        }
        if ((splashElementEmbedded = this.createElementSplash(extension, "embedded", iconsDir + "embedded.png", PDEUIMessages.UpdateSplashHandlerInModelAction_nameEmbedded)) != null) {
            extension.add((IPluginObject)splashElementEmbedded);
        }
        if ((splashElementEnterprise = this.createElementSplash(extension, "enterprise", iconsDir + "enterprise.png", PDEUIMessages.UpdateSplashHandlerInModelAction_nameEnterprise)) != null) {
            extension.add((IPluginObject)splashElementEnterprise);
        }
        if ((splashElementLanguages = this.createElementSplash(extension, "languages", iconsDir + "languages.png", PDEUIMessages.UpdateSplashHandlerInModelAction_nameLanguages)) != null) {
            extension.add((IPluginObject)splashElementLanguages);
        }
        if ((splashElementRCP = this.createElementSplash(extension, "rcp", iconsDir + "rcp.png", PDEUIMessages.UpdateSplashHandlerInModelAction_nameRCP)) != null) {
            extension.add((IPluginObject)splashElementRCP);
        }
    }

    private IPluginElement createElementSplash(IPluginExtension extension, String id, String icon, String tooltip) throws CoreException {
        IPluginElement element = extension.getModel().getFactory().createElement((IPluginObject)extension);
        element.setName("splashExtension");
        element.setAttribute("id", id);
        element.setAttribute("icon", icon);
        element.setAttribute("tooltip", tooltip);
        return element;
    }

    public static boolean isExtensibleTemplateSelected(String template) {
        return template.equals(F_SPLASH_SCREEN_TYPE_CHOICES[2][0]);
    }
}

