/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class AddModuleToServerCommand
extends AbstractDataModelOperation {
    private String serverInstanceId;
    private String moduleProjectName = null;
    private String earProjectName = null;
    private String module = null;
    private String earModule = null;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IServerWorkingCopy serverwc;
        IStatus status;
        IEnvironment env;
        block22: {
            IModule moduleToAdd;
            IServer server;
            block23: {
                env = this.getEnvironment();
                status = Status.OK_STATUS;
                server = null;
                if (this.serverInstanceId != null) {
                    server = ServerCore.findServer((String)this.serverInstanceId);
                }
                if (server == null) {
                    status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_INSTANCE_NOT_FOUND);
                    env.getStatusHandler().reportError(status);
                    return status;
                }
                serverwc = null;
                IProject moduleProject = ProjectUtilities.getProject((String)this.moduleProjectName);
                if (J2EEUtils.isJavaComponent((IProject)moduleProject)) break block22;
                IProject projectToAdd = null;
                if (this.earProjectName != null && this.earModule != null && this.earProjectName.length() > 0 && this.earModule.length() > 0) {
                    projectToAdd = ProjectUtilities.getProject((String)this.earProjectName);
                    moduleToAdd = ServerUtils.getModule((IProject)projectToAdd, (String)this.earModule);
                } else {
                    projectToAdd = moduleProject;
                    moduleToAdd = ServerUtils.getModule((IProject)projectToAdd, (String)this.module);
                }
                if (moduleToAdd != null) break block23;
                projectToAdd.build(10, null);
                moduleToAdd = ServerUtils.getModule((IProject)projectToAdd);
                if (moduleToAdd != null) break block23;
                status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_ADD_MODULE, (Object[])new String[]{this.module}));
                env.getStatusHandler().reportError(status);
                IStatus iStatus = status;
                try {
                    if (serverwc != null) {
                        serverwc.save(true, null);
                    }
                }
                catch (CoreException ce) {
                    status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_ADD_MODULE, (Object[])new String[]{this.module}), (Throwable)ce);
                    env.getStatusHandler().reportError(status);
                    return status;
                }
                return iStatus;
            }
            try {
                try {
                    if (!ServerUtil.containsModule((IServer)server, (IModule)moduleToAdd, null)) {
                        IModule[] imodules = new IModule[]{moduleToAdd};
                        serverwc = server.createWorkingCopy();
                        ServerUtil.modifyModules((IServerWorkingCopy)serverwc, (IModule[])imodules, null, null);
                    }
                }
                catch (CoreException e) {
                    status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_ADD_MODULE, (Object[])new String[]{this.module}), (Throwable)e);
                    env.getStatusHandler().reportError(status);
                    IStatus iStatus = status;
                    try {
                        if (serverwc != null) {
                            serverwc.save(true, null);
                        }
                    }
                    catch (CoreException ce) {
                        status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_ADD_MODULE, (Object[])new String[]{this.module}), (Throwable)ce);
                        env.getStatusHandler().reportError(status);
                        return status;
                    }
                    return iStatus;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (serverwc != null) {
                        serverwc.save(true, null);
                    }
                }
                catch (CoreException ce) {
                    status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_ADD_MODULE, (Object[])new String[]{this.module}), (Throwable)ce);
                    env.getStatusHandler().reportError(status);
                    return status;
                }
                throw throwable;
            }
        }
        try {
            if (serverwc != null) {
                serverwc.save(true, null);
            }
        }
        catch (CoreException ce) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_ADD_MODULE, (Object[])new String[]{this.module}), (Throwable)ce);
            env.getStatusHandler().reportError(status);
            return status;
        }
        return status;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setProject(String project) {
        this.moduleProjectName = project;
    }

    public void setEarProject(String earProject) {
        this.earProjectName = earProject;
    }

    public void setEarModule(String earModule) {
        this.earModule = earModule;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }
}

