/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.style.java;

import java.util.Collection;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.web.ui.internal.JsUIPlugin;
import org.eclipse.wst.jsdt.web.ui.internal.style.java.JSDTCodeScanner;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.provisional.style.AbstractLineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public class LineStyleProviderForJSDT
extends AbstractLineStyleProvider
implements LineStyleProvider {
    private JSDTCodeScanner fScanner;
    private IPropertyChangeListener fPreferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            LineStyleProviderForJSDT.this.handlePropertyChange(event);
        }
    };

    public LineStyleProviderForJSDT() {
        this.fScanner = new JSDTCodeScanner();
    }

    protected void addTextAttribute(String colorKey) {
        IPreferenceStore javaStore = this.getJavaColorPreferences();
        if (javaStore != null && colorKey != null) {
            TextAttribute ta = null;
            if (colorKey == "keyword") {
                RGB foreground = PreferenceConverter.getColor((IPreferenceStore)javaStore, (String)"java_keyword");
                boolean bold = javaStore.getBoolean("java_keyword_bold");
                boolean italics = javaStore.getBoolean("java_keyword_italic");
                boolean strikethrough = javaStore.getBoolean("java_keyword_strikethrough");
                boolean underline = javaStore.getBoolean("java_keyword_underline");
                int style = 0;
                if (bold) {
                    style |= 1;
                }
                if (italics) {
                    style |= 2;
                }
                if (strikethrough) {
                    style |= 0x20000000;
                }
                if (underline) {
                    style |= 0x40000000;
                }
                ta = this.createTextAttribute(foreground, null, style);
            } else if (colorKey == "string") {
                RGB foreground = PreferenceConverter.getColor((IPreferenceStore)javaStore, (String)"java_string");
                boolean bold = javaStore.getBoolean("java_string_bold");
                boolean italics = javaStore.getBoolean("java_string_italic");
                boolean strikethrough = javaStore.getBoolean("java_string_strikethrough");
                boolean underline = javaStore.getBoolean("java_string_underline");
                int style = 0;
                if (bold) {
                    style |= 1;
                }
                if (italics) {
                    style |= 2;
                }
                if (strikethrough) {
                    style |= 0x20000000;
                }
                if (underline) {
                    style |= 0x40000000;
                }
                ta = this.createTextAttribute(foreground, null, style);
            } else if (colorKey == "single_line_comment") {
                RGB foreground = PreferenceConverter.getColor((IPreferenceStore)javaStore, (String)"java_single_line_comment");
                boolean bold = javaStore.getBoolean("java_single_line_comment_bold");
                boolean italics = javaStore.getBoolean("java_single_line_comment_italic");
                boolean strikethrough = javaStore.getBoolean("java_single_line_comment_strikethrough");
                boolean underline = javaStore.getBoolean("java_single_line_comment_underline");
                int style = 0;
                if (bold) {
                    style |= 1;
                }
                if (italics) {
                    style |= 2;
                }
                if (strikethrough) {
                    style |= 0x20000000;
                }
                if (underline) {
                    style |= 0x40000000;
                }
                ta = this.createTextAttribute(foreground, null, style);
            } else if (colorKey == "multi_line_comment") {
                RGB foreground = PreferenceConverter.getColor((IPreferenceStore)javaStore, (String)"java_multi_line_comment");
                boolean bold = javaStore.getBoolean("java_multi_line_comment_bold");
                boolean italics = javaStore.getBoolean("java_multi_line_comment_italic");
                boolean strikethrough = javaStore.getBoolean("java_multi_line_comment_strikethrough");
                boolean underline = javaStore.getBoolean("java_multi_line_comment_underline");
                int style = 0;
                if (bold) {
                    style |= 1;
                }
                if (italics) {
                    style |= 2;
                }
                if (strikethrough) {
                    style |= 0x20000000;
                }
                if (underline) {
                    style |= 0x40000000;
                }
                ta = this.createTextAttribute(foreground, null, style);
            } else if (colorKey == "default") {
                RGB foreground = PreferenceConverter.getColor((IPreferenceStore)javaStore, (String)"java_default");
                boolean bold = javaStore.getBoolean("java_default_bold");
                boolean italics = javaStore.getBoolean("java_default_italic");
                boolean strikethrough = javaStore.getBoolean("java_default_strikethrough");
                boolean underline = javaStore.getBoolean("java_default_underline");
                int style = 0;
                if (bold) {
                    style |= 1;
                }
                if (italics) {
                    style |= 2;
                }
                if (strikethrough) {
                    style |= 0x20000000;
                }
                if (underline) {
                    style |= 0x40000000;
                }
                ta = this.createTextAttribute(foreground, null, style);
            } else if (colorKey == "commentBorder" || colorKey == "jsp_content") {
                ta = (TextAttribute)this.getTextAttributes().get(colorKey);
                String prefString = this.getHTMLColorPreferences().getString(colorKey);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    RGB foreground = ColorHelper.toRGB((String)stylePrefs[0]);
                    RGB background = ColorHelper.toRGB((String)stylePrefs[1]);
                    boolean bold = Boolean.valueOf(stylePrefs[2]);
                    boolean italic = Boolean.valueOf(stylePrefs[3]);
                    boolean strikethrough = Boolean.valueOf(stylePrefs[4]);
                    boolean underline = Boolean.valueOf(stylePrefs[5]);
                    int style = 0;
                    if (bold) {
                        style |= 1;
                    }
                    if (italic) {
                        style |= 2;
                    }
                    if (strikethrough) {
                        style |= 0x20000000;
                    }
                    if (underline) {
                        style |= 0x40000000;
                    }
                    ta = this.createTextAttribute(foreground, background, style);
                }
            }
            if (ta != null) {
                this.getTextAttributes().put(colorKey, ta);
                this.fScanner.setTokenData(colorKey, ta);
            }
        }
    }

    private void addRange(Collection presentation, int offset, int length, TextAttribute attr) {
        TextAttribute ta = (TextAttribute)this.getTextAttributes().get("jsp_content");
        Color bgColor = ta.getBackground();
        if (bgColor == null) {
            bgColor = attr.getBackground();
        }
        StyleRange result = new StyleRange(offset, length, attr.getForeground(), bgColor, attr.getStyle());
        if ((attr.getStyle() & 0x20000000) != 0) {
            result.strikeout = true;
        }
        if ((attr.getStyle() & 0x40000000) != 0) {
            result.underline = true;
        }
        presentation.add(result);
    }

    protected IPreferenceStore getColorPreferences() {
        return JsUIPlugin.getDefault().getPreferenceStore();
    }

    private IPreferenceStore getJavaColorPreferences() {
        return PreferenceConstants.getPreferenceStore();
    }

    private IPreferenceStore getHTMLColorPreferences() {
        return HTMLUIPlugin.getDefault().getPreferenceStore();
    }

    private TextAttribute getTokenTextAttribute(IToken token) {
        TextAttribute ta = null;
        Object data = token.getData();
        ta = data instanceof TextAttribute ? (TextAttribute)data : (TextAttribute)this.getTextAttributes().get("default");
        return ta;
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        String styleKey = null;
        if (event != null) {
            String prefKey = event.getProperty();
            if ("commentBorder".equals(prefKey)) {
                styleKey = "commentBorder";
            } else if ("commentText".equals(prefKey)) {
                styleKey = "commentText";
            } else if ("java_keyword".equals(prefKey) || "java_keyword_bold".equals(prefKey) || "java_keyword_italic".equals(prefKey)) {
                styleKey = "keyword";
            } else if ("java_string".equals(prefKey) || "java_string_bold".equals(prefKey) || "java_string_italic".equals(prefKey)) {
                styleKey = "string";
            } else if ("java_single_line_comment".equals(prefKey) || "java_single_line_comment_bold".equals(prefKey) || "java_single_line_comment_italic".equals(prefKey)) {
                styleKey = "single_line_comment";
            } else if ("java_multi_line_comment".equals(prefKey) || "java_multi_line_comment_bold".equals(prefKey) || "java_multi_line_comment_italic".equals(prefKey)) {
                styleKey = "multi_line_comment";
            } else if ("java_default".equals(prefKey) || "java_default_bold".equals(prefKey) || "java_default_italic".equals(prefKey)) {
                styleKey = "default";
            }
        }
        if (styleKey != null) {
            this.addTextAttribute(styleKey);
            this.fRecHighlighter.refreshDisplay();
            this.fScanner.initializeRules();
        }
    }

    protected void loadColors() {
        this.addTextAttribute("commentBorder");
        this.addTextAttribute("commentText");
        this.addTextAttribute("jsp_content");
        this.addTextAttribute("keyword");
        this.addTextAttribute("string");
        this.addTextAttribute("single_line_comment");
        this.addTextAttribute("multi_line_comment");
        this.addTextAttribute("default");
        this.fScanner.initializeRules();
    }

    public boolean prepareRegions(ITypedRegion typedRegion, int ssssrequestedStart, int ssssrequestedLength, Collection holdResults) {
        boolean result = true;
        this.getTextAttributes();
        try {
            int lastStart = typedRegion.getOffset();
            int length = 0;
            IToken lastToken = Token.UNDEFINED;
            this.fScanner.setRange((IDocument)this.getDocument(), lastStart, typedRegion.getLength());
            while (true) {
                IToken token;
                if ((token = this.fScanner.nextToken()).isEOF()) {
                    if (!lastToken.isUndefined() && length != 0) {
                        this.addRange(holdResults, lastStart, length, this.getTokenTextAttribute(lastToken));
                    }
                    break;
                }
                if (token.isWhitespace()) {
                    length += this.fScanner.getTokenLength();
                    continue;
                }
                if (lastToken.isUndefined()) {
                    lastToken = token;
                    length += this.fScanner.getTokenLength();
                    continue;
                }
                if (token != lastToken) {
                    this.addRange(holdResults, lastStart, length, this.getTokenTextAttribute(lastToken));
                    lastToken = token;
                    lastStart = this.fScanner.getTokenOffset();
                    length = this.fScanner.getTokenLength();
                    continue;
                }
                length += this.fScanner.getTokenLength();
            }
        }
        catch (Exception exception) {
            result = false;
        }
        return result;
    }

    protected TextAttribute getAttributeFor(ITextRegion region) {
        return null;
    }

    protected void registerPreferenceManager() {
        this.getColorPreferences().addPropertyChangeListener(this.fPreferenceListener);
        this.getJavaColorPreferences().addPropertyChangeListener(this.fPreferenceListener);
        this.getHTMLColorPreferences().addPropertyChangeListener(this.fPreferenceListener);
    }

    public void release() {
        super.release();
        this.fScanner = null;
    }

    protected void unRegisterPreferenceManager() {
        this.getColorPreferences().removePropertyChangeListener(this.fPreferenceListener);
        this.getJavaColorPreferences().removePropertyChangeListener(this.fPreferenceListener);
        this.getHTMLColorPreferences().removePropertyChangeListener(this.fPreferenceListener);
    }
}

