/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.archiveoperations;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EjbClientJarCreationOperation;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.IEjbClientJarCreationDataModelProperties;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBCreationResourceHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class EjbClientJarCreationDataModelProvider
extends AbstractDataModelProvider
implements IEjbClientJarCreationDataModelProperties {
    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME");
        propertyNames.add("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME");
        propertyNames.add("IEjbClientProjectCreationDataModelProperties.CLIENT_URI ");
        return propertyNames;
    }

    public IDataModelOperation getDefaultOperation() {
        return new EjbClientJarCreationOperation(this.model);
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IEjbClientProjectCreationDataModelProperties.CLIENT_URI ")) {
            String projectName = this.model.getStringProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME").replace(' ', '_');
            return String.valueOf(projectName) + "Client.jar";
        }
        if (propertyName.equals("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME")) {
            String projectName = this.model.getStringProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME");
            return String.valueOf(projectName) + "Client";
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean status = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME")) {
            String projectName = this.model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME");
            if (projectName != null) {
                projectName = projectName.replace(' ', '_');
            }
            this.setProperty("IEjbClientProjectCreationDataModelProperties.CLIENT_URI ", String.valueOf(projectName) + "Client.jar");
        }
        return status;
    }

    public IStatus validate(String propertyName) {
        IStatus status = OK_STATUS;
        if (status.isOK()) {
            String clientProjectName;
            String ejbProjectName;
            if (propertyName.equals("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME") && (ejbProjectName = this.getStringProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME")).equals(clientProjectName = this.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME"))) {
                return WTPCommonPlugin.createErrorStatus((String)EJBCreationResourceHandler.CLIENT_SAME_NAME_AS_EJB);
            }
            if (propertyName.equals("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME")) {
                if (this.hasExistingClientJar()) {
                    return WTPCommonPlugin.createErrorStatus((String)EJBCreationResourceHandler.EJB_JAR_already_has_client_Jar_);
                }
                status = this.checkForValidProjectName(this.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME"));
            }
        }
        return status;
    }

    private IStatus checkForValidProjectName(String aProjectName) {
        return ResourcesPlugin.getWorkspace().validateName(aProjectName, 4);
    }

    protected IProject getEJBProject() {
        String projectName = this.getStringProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME");
        return ProjectUtilities.getProject((String)projectName);
    }

    public boolean hasExistingClientJar() {
        IProject project = this.getEJBProject();
        if (project.exists() && project.isAccessible()) {
            EJBArtifactEdit edit = null;
            try {
                edit = EJBArtifactEdit.getEJBArtifactEditForRead(project);
                return edit != null && edit.hasEJBClientJARProject();
                {
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        return false;
    }
}

