/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.provisional.contenttype;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class ContentTypeIdForJSP {
    public static final String ContentTypeID_JSP = ContentTypeIdForJSP.getConstantString();
    public static final String ContentTypeID_JSPFRAGMENT = ContentTypeIdForJSP.getFragmentConstantString();
    public static final String ContentTypeID_JSPTAG = ContentTypeIdForJSP.getTagConstantString();
    static char[][] JSP_EXTENSIONS;
    static char[][] JSP_FILENAMES;
    static char[][] JSPF_EXTENSIONS;
    static char[][] JSPF_FILENAMES;
    private static String JSP;
    private static String JSPF;
    private static ContentTypeChangeListener typeChangeListener;

    static {
        JSP = "jsp";
        JSPF = "jspf";
        typeChangeListener = new ContentTypeChangeListener();
    }

    private ContentTypeIdForJSP() {
    }

    static String getConstantString() {
        return "org.eclipse.jst.jsp.core.jspsource";
    }

    static String getFragmentConstantString() {
        return "org.eclipse.jst.jsp.core.jspfragmentsource";
    }

    static String getTagConstantString() {
        return "org.eclipse.jst.jsp.core.tagsource";
    }

    public static IContentTypeManager.IContentTypeChangeListener getTypeChangeListener() {
        return typeChangeListener;
    }

    public static int indexOfJSPFExtension(String fileName) {
        char[] name = fileName.toCharArray();
        int fileNameLength = fileName.length();
        char[][] jspfExtensions = ContentTypeIdForJSP.getJSPFExtensions();
        int i = 0;
        int length = jspfExtensions.length;
        while (i < length) {
            block7: {
                char[] extension = jspfExtensions[i];
                int extensionLength = extension.length;
                int extensionStart = fileNameLength - extensionLength;
                int dotIndex = extensionStart - 1;
                if (dotIndex >= 0 && name[dotIndex] == '.') {
                    int j = 0;
                    while (j < extensionLength) {
                        if (name[extensionStart + j] == extension[j]) {
                            ++j;
                            continue;
                        }
                        break block7;
                    }
                    return dotIndex;
                }
            }
            ++i;
        }
        char[][] filenames = JSPF_FILENAMES;
        if (filenames != null) {
            int i2 = 0;
            while (i2 < filenames.length) {
                if (Arrays.equals(name, filenames[i2])) {
                    return i2;
                }
                ++i2;
            }
        }
        return -1;
    }

    public static int indexOfJSPExtension(String fileName) {
        char[] name = fileName.toCharArray();
        int fileNameLength = fileName.length();
        char[][] jspExtensions = ContentTypeIdForJSP.getJSPExtensions();
        int i = 0;
        int length = jspExtensions.length;
        while (i < length) {
            block7: {
                char[] extension = jspExtensions[i];
                int extensionLength = extension.length;
                int extensionStart = fileNameLength - extensionLength;
                int dotIndex = extensionStart - 1;
                if (dotIndex >= 0 && name[dotIndex] == '.') {
                    int j = 0;
                    while (j < extensionLength) {
                        if (name[extensionStart + j] == extension[j]) {
                            ++j;
                            continue;
                        }
                        break block7;
                    }
                    return dotIndex;
                }
            }
            ++i;
        }
        char[][] filenames = JSP_FILENAMES;
        if (filenames != null) {
            int i2 = 0;
            while (i2 < filenames.length) {
                if (Arrays.equals(name, filenames[i2])) {
                    return i2;
                }
                ++i2;
            }
        }
        return -1;
    }

    public static char[][] getJSPExtensions() {
        if (JSP_EXTENSIONS == null) {
            IContentType jspContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.getConstantString());
            HashSet<String> fileExtensions = new HashSet<String>();
            HashSet<String> fileNames = new HashSet<String>();
            IContentType[] contentTypes = Platform.getContentTypeManager().getAllContentTypes();
            int i = 0;
            int length = contentTypes.length;
            while (i < length) {
                if (contentTypes[i].isKindOf(jspContentType)) {
                    String[] fileExtension = contentTypes[i].getFileSpecs(8);
                    int j = 0;
                    while (j < fileExtension.length) {
                        fileExtensions.add(fileExtension[j]);
                        ++j;
                    }
                    String[] names = contentTypes[i].getFileSpecs(4);
                    int j2 = 0;
                    while (j2 < names.length) {
                        fileNames.add(names[j2]);
                        ++j2;
                    }
                }
                ++i;
            }
            int length2 = fileExtensions.size();
            char[][] extensions = new char[length2][];
            extensions[0] = JSP.toCharArray();
            int index = 1;
            for (String fileExtension : fileExtensions) {
                if (JSP.equalsIgnoreCase(fileExtension)) continue;
                extensions[index++] = fileExtension.toCharArray();
            }
            JSP_EXTENSIONS = extensions;
            char[][] names = new char[fileNames.size()][];
            Iterator iterator = fileNames.iterator();
            int i2 = 0;
            while (iterator.hasNext()) {
                names[i2++] = ((String)iterator.next()).toCharArray();
            }
            JSP_FILENAMES = names;
        }
        return JSP_EXTENSIONS;
    }

    public static char[][] getJSPFExtensions() {
        if (JSPF_EXTENSIONS == null) {
            IContentType contentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.getFragmentConstantString());
            HashSet<String> fileExtensions = new HashSet<String>();
            HashSet<String> fileNames = new HashSet<String>();
            IContentType[] contentTypes = Platform.getContentTypeManager().getAllContentTypes();
            int i = 0;
            int length = contentTypes.length;
            while (i < length) {
                if (contentTypes[i].isKindOf(contentType)) {
                    String[] fileExtension = contentTypes[i].getFileSpecs(8);
                    int j = 0;
                    while (j < fileExtension.length) {
                        fileExtensions.add(fileExtension[j]);
                        ++j;
                    }
                    String[] names = contentTypes[i].getFileSpecs(4);
                    int j2 = 0;
                    while (j2 < names.length) {
                        fileNames.add(names[j2]);
                        ++j2;
                    }
                }
                ++i;
            }
            int length2 = fileExtensions.size();
            char[][] extensions = new char[length2][];
            extensions[0] = JSPF.toCharArray();
            int index = 1;
            for (String fileExtension : fileExtensions) {
                if (JSPF.equalsIgnoreCase(fileExtension)) continue;
                extensions[index++] = fileExtension.toCharArray();
            }
            JSPF_EXTENSIONS = extensions;
            char[][] names = new char[fileNames.size()][];
            Iterator iterator = fileNames.iterator();
            int i2 = 0;
            while (iterator.hasNext()) {
                names[i2++] = ((String)iterator.next()).toCharArray();
            }
            JSPF_FILENAMES = names;
        }
        return JSPF_EXTENSIONS;
    }

    static class ContentTypeChangeListener
    implements IContentTypeManager.IContentTypeChangeListener {
        ContentTypeChangeListener() {
        }

        public void contentTypeChanged(IContentTypeManager.ContentTypeChangeEvent event) {
            String id = event.getContentType().getId();
            if (ContentTypeIdForJSP.getConstantString().equals(id) || ContentTypeIdForJSP.getFragmentConstantString().equals(id) || ContentTypeIdForJSP.getTagConstantString().equals(id)) {
                JSP_EXTENSIONS = null;
            }
        }
    }
}

