/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.propertypages;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.propertypages.JavaExceptionBreakpointAdvancedPage;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.jdt.internal.ui.filtertable.Filter;
import org.eclipse.jdt.internal.ui.filtertable.JavaFilterTable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ExceptionFilterEditor {
    protected static final String DEFAULT_PACKAGE = "(default package)";
    private final IJavaExceptionBreakpoint fBreakpoint;
    private JavaFilterTable fJavaFilterTable;

    public ExceptionFilterEditor(Composite parent, JavaExceptionBreakpointAdvancedPage page) {
        this.fBreakpoint = (IJavaExceptionBreakpoint)page.getBreakpoint();
        Composite outer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        outer.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        outer.setLayoutData((Object)gd);
        outer.setFont(parent.getFont());
        Label label = new Label(outer, 0);
        label.setText(PropertyPageMessages.ExceptionFilterEditor_5);
        label.setFont(parent.getFont());
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        TableLayout tableLayout = new TableLayout();
        ColumnLayoutData[] columnLayoutData = new ColumnLayoutData[]{new ColumnWeightData(100)};
        tableLayout.addColumnData(columnLayoutData[0]);
        this.createFilterTable(outer);
    }

    private void createFilterTable(Composite outer) {
        this.fJavaFilterTable = new JavaFilterTable(new JavaFilterTable.FilterStorage(){

            public void setStoredFilters(IPreferenceStore store, Filter[] filters) {
                ArrayList<String> inclusionFilters = new ArrayList<String>(filters.length);
                ArrayList<String> exclusionFilters = new ArrayList<String>(filters.length);
                Filter[] filterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    Filter filter = filterArray[n2];
                    String name = filter.getName();
                    if (name.equals(ExceptionFilterEditor.DEFAULT_PACKAGE)) {
                        name = "";
                    }
                    if (filter.isChecked()) {
                        inclusionFilters.add(name);
                    } else {
                        exclusionFilters.add(name);
                    }
                    ++n2;
                }
                try {
                    ExceptionFilterEditor.this.fBreakpoint.setInclusionFilters(inclusionFilters.toArray(new String[inclusionFilters.size()]));
                    ExceptionFilterEditor.this.fBreakpoint.setExclusionFilters(exclusionFilters.toArray(new String[exclusionFilters.size()]));
                }
                catch (CoreException ce) {
                    JDIDebugUIPlugin.log(ce);
                }
            }

            public Filter[] getStoredFilters(boolean defaults) {
                if (defaults) {
                    return new Filter[0];
                }
                try {
                    String filter;
                    String[] iFilters = ExceptionFilterEditor.this.fBreakpoint.getInclusionFilters();
                    String[] eFilters = ExceptionFilterEditor.this.fBreakpoint.getExclusionFilters();
                    ArrayList<Filter> storedFilters = new ArrayList<Filter>(iFilters.length + eFilters.length);
                    String[] stringArray = iFilters;
                    int n = iFilters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        filter = stringArray[n2];
                        storedFilters.add(ExceptionFilterEditor.this.toFilter(filter, true));
                        ++n2;
                    }
                    stringArray = eFilters;
                    n = eFilters.length;
                    n2 = 0;
                    while (n2 < n) {
                        filter = stringArray[n2];
                        storedFilters.add(ExceptionFilterEditor.this.toFilter(filter, false));
                        ++n2;
                    }
                    return (Filter[])storedFilters.toArray(Filter[]::new);
                }
                catch (CoreException ce) {
                    JDIDebugUIPlugin.log(ce);
                    return new Filter[0];
                }
            }
        }, new JavaFilterTable.FilterTableConfig().setAddFilter(new JavaFilterTable.ButtonLabel(PropertyPageMessages.ExceptionFilterEditor_6, PropertyPageMessages.ExceptionFilterEditor_7)).setAddType(new JavaFilterTable.ButtonLabel(PropertyPageMessages.ExceptionFilterEditor_8, PropertyPageMessages.ExceptionFilterEditor_9)).setAddPackage(new JavaFilterTable.ButtonLabel(PropertyPageMessages.ExceptionFilterEditor_10, PropertyPageMessages.ExceptionFilterEditor_11)).setRemove(new JavaFilterTable.ButtonLabel(PropertyPageMessages.ExceptionFilterEditor_12, PropertyPageMessages.ExceptionFilterEditor_13)).setAddPackageDialog(new JavaFilterTable.DialogLabels(PropertyPageMessages.ExceptionFilterEditor_15, PropertyPageMessages.ExceptionFilterEditor_18)).setAddTypeDialog(new JavaFilterTable.DialogLabels(PropertyPageMessages.ExceptionFilterEditor_19, PropertyPageMessages.ExceptionFilterEditor_22)).setErrorAddTypeDialog(new JavaFilterTable.DialogLabels(PropertyPageMessages.ExceptionFilterEditor_19, PropertyPageMessages.ExceptionFilterEditor_20)));
        this.fJavaFilterTable.createTable(outer);
    }

    private Filter toFilter(String stringFilter, boolean include) {
        if (stringFilter.length() == 0) {
            return new Filter(DEFAULT_PACKAGE, include);
        }
        return new Filter(stringFilter, include);
    }

    protected void doStore() {
        this.fJavaFilterTable.performOk(null);
    }
}

