/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.refactoring;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;

public class ConnectionProfileMoveChange
extends Change {
    private IConnectionProfile mProfileToMove;
    private IConnectionProfile mSourceRepository;
    private MoveArguments mArguments;

    public ConnectionProfileMoveChange(IConnectionProfile profile, MoveArguments arguments) {
        this.mProfileToMove = profile;
        this.mSourceRepository = profile.getParentProfile();
        this.mArguments = arguments;
    }

    public Object getModifiedElement() {
        return new Object[]{this.mArguments.getDestination()};
    }

    public Object[] getAffectedObjects() {
        Object o = null;
        o = this.mSourceRepository == null ? ProfileManager.getInstance() : this.mSourceRepository;
        return new Object[]{o};
    }

    public String getName() {
        return MessageFormat.format(ConnectivityUIPlugin.getDefault().getResourceString("CPMoveChange.name"), this.mProfileToMove.getName());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.mProfileToMove == null) {
            result.addFatalError(ConnectivityUIPlugin.getDefault().getResourceString("CPMoveChange.error.ProfileDoesNotExist"));
        }
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        CompositeChange undo = new CompositeChange(this.getName());
        undo.markAsSynthetic();
        undo.add(this.moveProfile());
        return undo;
    }

    private Change moveProfile() throws CoreException {
        IConnectionProfile oldParent = this.mProfileToMove.getParentProfile();
        IConnectionProfileRepository oldRepo = ((ConnectionProfile)this.mProfileToMove).getRepository();
        IConnectionProfileRepository newRepo = this.getTargetRepository();
        try {
            if (oldRepo == null) {
                InternalProfileManager.getInstance().removeProfile(this.mProfileToMove);
            } else {
                oldRepo.removeProfile(this.mProfileToMove);
            }
            try {
                if (newRepo == null) {
                    InternalProfileManager.getInstance().addProfile(this.mProfileToMove);
                } else {
                    newRepo.addProfile(this.mProfileToMove);
                }
            }
            catch (ConnectionProfileException e) {
                if (oldRepo == null) {
                    InternalProfileManager.getInstance().addProfile(this.mProfileToMove);
                } else {
                    oldRepo.addProfile(this.mProfileToMove);
                }
                throw e;
            }
        }
        catch (ConnectionProfileException e) {
            Status status = new Status(4, ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), -1, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        Object o = null;
        o = oldParent == null ? ProfileManager.getInstance() : oldParent;
        return new ConnectionProfileMoveChange(this.mProfileToMove, new MoveArguments(o, this.mArguments.getUpdateReferences()));
    }

    private IConnectionProfileRepository getTargetRepository() throws CoreException {
        Object destination = this.mArguments.getDestination();
        if (destination instanceof ProfileManager) {
            return null;
        }
        if (destination instanceof IConnectionProfile) {
            IManagedConnection imc = ((IConnectionProfile)destination).getManagedConnection(IConnectionProfileRepository.class.getName());
            if (imc == null) {
                Status status = new Status(4, ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), -1, ConnectivityUIPlugin.getDefault().getResourceString("CPCopyChange.error.InvalidTarget"), null);
                throw new CoreException((IStatus)status);
            }
            if (!imc.isConnected() || imc.getConnection() == null || imc.getConnection().getRawConnection() == null) {
                Status status = new Status(4, ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), -1, ConnectivityUIPlugin.getDefault().getResourceString("CPCopyChange.error.RepositoryNotConnected", new Object[]{((IConnectionProfile)destination).getName()}), null);
                throw new CoreException((IStatus)status);
            }
            return (IConnectionProfileRepository)imc.getConnection().getRawConnection();
        }
        Status status = new Status(4, ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), -1, ConnectivityUIPlugin.getDefault().getResourceString("CPCopyChange.error.InvalidTarget"), null);
        throw new CoreException((IStatus)status);
    }
}

