/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.internal.ui.connection;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizardPage;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAProfileMessages;
import org.eclipse.datatools.enablement.sybase.asa.actions.JDBCHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MultiASAWizardPage
extends BaseWizardPage {
    public Properties mCacheProps = null;
    private Button mCheckButton;
    private CheckboxTableViewer mList;
    private Button mSelectAll;
    private Button mDeselectAll;

    public MultiASAWizardPage(String pageName) {
        super(pageName);
        this.setTitle(JDBCASAProfileMessages.getString((String)"MultiASAWizardPage.title"));
        this.setDescription(JDBCASAProfileMessages.getString((String)"MultiASAWizardPage.description"));
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.makeColumnsEqualWidth = true;
        content.setLayout((Layout)layout);
        this.mCheckButton = new Button(content, 8);
        GridData pingData = new GridData();
        pingData.horizontalSpan = 2;
        pingData.horizontalAlignment = 1;
        this.mCheckButton.setLayoutData((Object)pingData);
        this.mCheckButton.setText(JDBCASAProfileMessages.getString((String)"MultiASAWizardPage.checkButton.label"));
        Label label = new Label(content, 0);
        GridData labelData = new GridData();
        labelData.horizontalSpan = 2;
        label.setLayoutData((Object)labelData);
        label.setText(JDBCASAProfileMessages.getString((String)"MultiASAWizardPage.Label.ChooseDbs"));
        this.mList = CheckboxTableViewer.newCheckList((Composite)content, (int)2050);
        GridData listData = new GridData(4, 4, true, true);
        listData.horizontalSpan = 2;
        this.mList.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private String[] mDatabases = null;

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof String[]) {
                    this.mDatabases = (String[])newInput;
                }
            }

            public Object[] getElements(Object inputElement) {
                return this.mDatabases;
            }
        });
        this.mList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.mList.getTable().setLayoutData((Object)listData);
        this.mList.getTable().setEnabled(false);
        this.mSelectAll = new Button(content, 8);
        this.mSelectAll.setText(JDBCASAProfileMessages.getString((String)"MultiASAWizardPage.selectAllButton.label"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        this.mSelectAll.setLayoutData((Object)gridData);
        this.mSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MultiASAWizardPage.this.selectAll();
            }
        });
        this.mDeselectAll = new Button(content, 8);
        this.mDeselectAll.setText(JDBCASAProfileMessages.getString((String)"MultiASAWizardPage.deselectAllButton.label"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        this.mDeselectAll.setLayoutData((Object)gridData);
        this.mDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MultiASAWizardPage.this.unselectAll();
            }
        });
        this.mCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Connection conn = MultiASAWizardPage.this.getConnectionForTempProfile();
                if (conn != null) {
                    String[] dbs = JDBCHelper.getDBNamesFromASA(conn);
                    MultiASAWizardPage.this.mList.setInput((Object)dbs);
                    MultiASAWizardPage.this.mList.getTable().setEnabled(true);
                    if (dbs.length == 1) {
                        MultiASAWizardPage.this.mSelectAll.setEnabled(false);
                        MultiASAWizardPage.this.mDeselectAll.setEnabled(false);
                        MultiASAWizardPage.this.mList.getTable().setEnabled(false);
                        MultiASAWizardPage.this.mList.setAllChecked(true);
                    } else {
                        MultiASAWizardPage.this.mSelectAll.setEnabled(true);
                        MultiASAWizardPage.this.mDeselectAll.setEnabled(true);
                        MultiASAWizardPage.this.mList.getTable().setEnabled(true);
                        MultiASAWizardPage.this.mList.setAllChecked(false);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setControl((Control)content);
    }

    private Connection getConnectionForTempProfile() {
        IConnectionProfile cp = this.getTemporaryProfile();
        IConnection con = cp.createConnection("org.eclipse.datatools.connectivity.connectionFactory.pingFactory");
        if (con != null && con.getConnectException() == null) {
            Connection conn = (Connection)con.getRawConnection();
            return conn;
        }
        MessageDialog.openError((Shell)this.getShell(), (String)JDBCASAProfileMessages.getString((String)"MultiASAWizardPage.Error.title.CannotConnect"), (String)JDBCASAProfileMessages.getString((String)"MultiASAWizardPage.Error.msg.CannotConnect"));
        return null;
    }

    private IConnectionProfile getTemporaryProfile() {
        Properties props;
        ConnectionProfile tempProfile = new ConnectionProfile("tempJDBCForPing", "empty", "org.eclipse.datatools.enablement.sybase.asa.connectionProfile");
        NewConnectionProfileWizard wiz = (NewConnectionProfileWizard)this.getWizard();
        this.mCacheProps = props = wiz.getProfileProperties();
        tempProfile.setBaseProperties(props);
        return tempProfile;
    }

    public void clearList() {
        this.mList.setInput((Object)new String[0]);
        this.mList.getTable().setEnabled(false);
        this.mCacheProps.clear();
        this.mCacheProps = null;
    }

    private void selectAll() {
        Object[] names = (String[])this.mList.getInput();
        this.mList.setCheckedElements(names);
    }

    private void unselectAll() {
        String[] names = (String[])this.mList.getInput();
        int i = 0;
        while (i < names.length) {
            this.mList.setChecked((Object)names[i], false);
            ++i;
        }
    }

    public boolean getSkippable() {
        NewConnectionProfileWizard wiz = (NewConnectionProfileWizard)this.getWizard();
        Properties props = wiz.getProfileProperties();
        String dbname = props.getProperty("org.eclipse.datatools.connectivity.db.databaseName");
        return dbname != null && dbname.length() > 0;
    }

    public String[] getDBNames() {
        Object[] checked = this.mList.getCheckedElements();
        List<Object> list = Arrays.asList(checked);
        return list.toArray(new String[list.size()]);
    }

    public List getSummaryData() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        Object[] checked = this.mList.getCheckedElements();
        if (checked != null && checked.length > 0) {
            if (checked.length == 1) {
                data.add(new String[]{JDBCASAProfileMessages.getString((String)"JDBCASAPropertyWizardPage.summary.databaseName.label"), this.getDBNames()[0]});
            } else {
                data.add(new String[]{JDBCASAProfileMessages.getString((String)"MultiASAWizardPage.Summary.Label"), ""});
                int i = 0;
                while (i < checked.length) {
                    data.add(new String[]{"", (String)checked[i]});
                    ++i;
                }
            }
        } else {
            NewConnectionProfileWizard wiz = (NewConnectionProfileWizard)this.getWizard();
            Properties props = wiz.getProfileProperties();
            String dbname = props.getProperty("org.eclipse.datatools.connectivity.db.databaseName");
            data.add(new String[]{JDBCASAProfileMessages.getString((String)"JDBCASAPropertyWizardPage.summary.databaseName.label"), dbname});
        }
        return data;
    }
}

