/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.hyperlink;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.hyperlink.TaglibHyperlinkDetector;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

class TLDFileHyperlink
implements IHyperlink {
    private IResource fResource;
    private IRegion fHyperlinkRegion;
    private String fSearchName;
    private int fSearchType;

    public TLDFileHyperlink(IResource resource, int searchType, String searchName, IRegion hyperlinkRegion) {
        this.fResource = resource;
        this.fSearchName = searchName;
        this.fSearchType = searchType;
        this.fHyperlinkRegion = hyperlinkRegion;
    }

    private IMarker createMarker(IFile file, IRegion region) throws CoreException {
        IMarker marker = file.createMarker("org.eclipse.jst.jsp.uihyperlink");
        marker.setAttribute("transient", (Object)Boolean.TRUE);
        marker.setAttribute("sourceId", (Object)this.getClass().getName());
        marker.setAttribute("charStart", region.getOffset());
        marker.setAttribute("charEnd", region.getOffset() + region.getLength());
        return marker;
    }

    public IRegion getHyperlinkRegion() {
        return this.fHyperlinkRegion;
    }

    public String getHyperlinkText() {
        return NLS.bind((String)JSPUIMessages.Open, (Object)this.fResource.getFullPath().toString());
    }

    public String getTypeLabel() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void open() {
        IWorkbenchWindow window = JSPUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) return;
        IWorkbenchPage page = window.getActivePage();
        if (this.fResource.getType() != 1) return;
        IFile file = (IFile)this.fResource;
        IMarker marker = null;
        IDOMModel domModel = null;
        try {
            try {
                IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(file);
                if (!(model instanceof IDOMModel) || (domModel = (IDOMModel)model) == null) return;
                IRegion targetRegion = TaglibHyperlinkDetector.findDefinition(domModel, this.fSearchName, this.fSearchType);
                if (targetRegion != null) {
                    try {
                        marker = this.createMarker(file, targetRegion);
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                }
                if (marker != null) {
                    try {
                        try {
                            IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
                            return;
                        }
                        catch (PartInitException e1) {
                            Logger.logException(e1);
                            try {
                                marker.delete();
                                return;
                            }
                            catch (CoreException e) {
                                Logger.logException(e);
                            }
                        }
                        return;
                    }
                    finally {
                        try {
                            marker.delete();
                        }
                        catch (CoreException e) {
                            Logger.logException(e);
                        }
                    }
                }
                IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                return;
            }
            catch (IOException iOException) {
                if (domModel == null) return;
                domModel.releaseFromRead();
                return;
            }
            catch (CoreException coreException) {
                if (domModel == null) return;
                domModel.releaseFromRead();
                return;
            }
        }
        finally {
            if (domModel != null) {
                domModel.releaseFromRead();
            }
        }
    }
}

