/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.common.snippets.internal.SnippetsMessages;
import org.eclipse.wst.common.snippets.internal.ui.ValueChangedListener;
import org.eclipse.wst.common.snippets.internal.util.AccessibleTableViewer;

public class StringPropertyTableViewer {
    protected Map[] columnData = null;
    protected String[] fColumnNames = null;
    protected boolean fEditFirstColumn = true;
    protected String fSelection;
    protected List fSelectionChangedListeners;
    protected AccessibleTableViewer fTableViewer = null;
    protected List fValueChangedListeners;

    public StringPropertyTableViewer() {
    }

    public StringPropertyTableViewer(Composite parent, String[] columnNames) {
        this.setColumnNames(columnNames);
        this.createContents(parent);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getSelectionChangedListeners().add(listener);
    }

    public void addValueChangedListener(ValueChangedListener listener) {
        this.getValueChangedListeners().add(listener);
    }

    public void clear() {
        int i = 0;
        while (i < this.getColumnNames().length) {
            this.getColumnData()[i].clear();
            ++i;
        }
        this.refresh();
    }

    public Control createContents(Composite parent) {
        this.fTableViewer = new AccessibleTableViewer(new Table(parent, 68356));
        this.fTableViewer.setSingleClickCellSelect(true);
        this.fTableViewer.getTable().setHeaderVisible(true);
        this.fTableViewer.getTable().setLinesVisible(true);
        this.fTableViewer.addSelectionChangedListener(new MultiCastingSelectionChangedListener());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new StringPropertyLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableLayout tlayout = new TableLayout();
        CellEditor[] cellEditors = new CellEditor[this.getColumnNames().length];
        this.columnData = new Map[this.getColumnNames().length];
        int i = 0;
        while (i < this.getColumnNames().length) {
            this.getColumnData()[i] = new LinkedHashMap();
            tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
            TableColumn tc = new TableColumn(this.fTableViewer.getTable(), 0);
            tc.setText(this.getColumnNames()[i]);
            tc.setResizable(true);
            tc.setWidth(40);
            cellEditors[i] = new TextCellEditor((Composite)this.fTableViewer.getTable());
            ++i;
        }
        this.fTableViewer.getTable().setLayout((Layout)tlayout);
        this.fTableViewer.setCellEditors(cellEditors);
        this.fTableViewer.setColumnProperties(this.getColumnNames());
        ICellModifier cellmodifier = new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (StringPropertyTableViewer.this.getEditFirstColumn()) {
                    return true;
                }
                if (StringPropertyTableViewer.this.getColumnNames().length > 1) {
                    int i = 1;
                    while (i < StringPropertyTableViewer.this.getColumnNames().length) {
                        if (property.equals(StringPropertyTableViewer.this.getColumnNames()[i])) {
                            return true;
                        }
                        ++i;
                    }
                }
                return false;
            }

            public Object getValue(Object element, String property) {
                String value = null;
                int i = 0;
                while (i < StringPropertyTableViewer.this.getColumnNames().length) {
                    if (property.equals(StringPropertyTableViewer.this.getColumnNames()[i])) {
                        value = (String)StringPropertyTableViewer.this.getColumnData()[i].get(element);
                    }
                    ++i;
                }
                if (value == null) {
                    value = "";
                }
                return value;
            }

            public void modify(Object element, String property, Object value) {
                TableItem item = (TableItem)element;
                String key = (String)item.getData();
                if (property.equals(StringPropertyTableViewer.this.getColumnNames()[0]) && value.toString().trim().length() < 1 || StringPropertyTableViewer.this.isNameExcluding(key, value.toString().trim())) {
                    return;
                }
                if (StringPropertyTableViewer.this.getColumnData()[0].containsKey(key)) {
                    int i = 0;
                    while (i < StringPropertyTableViewer.this.getColumnNames().length) {
                        if (property.equals(StringPropertyTableViewer.this.getColumnNames()[i])) {
                            item.setText(i, (String)value);
                            String oldValue = (String)StringPropertyTableViewer.this.getColumnData()[i].get(key);
                            StringPropertyTableViewer.this.getColumnData()[i].put(key, value);
                            StringPropertyTableViewer.this.fireValueChanged(new String(key), property, oldValue, new String((String)value));
                        }
                        ++i;
                    }
                }
            }
        };
        this.fTableViewer.setCellModifier(cellmodifier);
        this.fTableViewer.setInput(new ArrayList(this.getColumnData()[0].keySet()));
        return this.getControl();
    }

    public void finishEditing() {
        this.fTableViewer.finishEditing();
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        ISelectionChangedListener[] listeners = new ISelectionChangedListener[this.getSelectionChangedListeners().size()];
        this.getSelectionChangedListeners().toArray(listeners);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].selectionChanged(event);
            ++i;
        }
    }

    protected void fireValueChanged(String key, String property, String oldValue, String newValue) {
        ValueChangedListener[] listeners = new ValueChangedListener[this.getValueChangedListeners().size()];
        this.getValueChangedListeners().toArray(listeners);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].valueChanged(key, property, oldValue, newValue);
            ++i;
        }
    }

    public Map[] getColumnData() {
        return this.columnData;
    }

    public String[] getColumnNames() {
        if (this.fColumnNames == null) {
            return new String[]{SnippetsMessages.Variable_Name_3, SnippetsMessages.Value_4};
        }
        return this.fColumnNames;
    }

    public Control getControl() {
        return this.getTable();
    }

    public boolean getEditFirstColumn() {
        return this.fEditFirstColumn;
    }

    public String getSelection() {
        return this.fSelection;
    }

    protected List getSelectionChangedListeners() {
        if (this.fSelectionChangedListeners == null) {
            this.fSelectionChangedListeners = new ArrayList();
        }
        return this.fSelectionChangedListeners;
    }

    public Table getTable() {
        if (this.fTableViewer == null) {
            return null;
        }
        return this.fTableViewer.getTable();
    }

    public List getValueChangedListeners() {
        if (this.fValueChangedListeners == null) {
            this.fValueChangedListeners = new ArrayList();
        }
        return this.fValueChangedListeners;
    }

    protected boolean isNameExcluding(Object element, Object value) {
        return this.isValueExcluding(element, 0, value);
    }

    protected boolean isValueExcluding(Object element, int column, Object value) {
        Iterator keys = this.getColumnData()[0].keySet().iterator();
        boolean duplicated = false;
        Object key = null;
        while (keys.hasNext()) {
            key = keys.next();
            if (key.equals(element) || !this.getColumnData()[column].get(key).toString().trim().equals(value)) continue;
            duplicated = true;
        }
        return duplicated;
    }

    public void refresh() {
        if (this.fTableViewer != null) {
            this.fTableViewer.setInput(new ArrayList(this.getColumnData()[0].keySet()));
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getSelectionChangedListeners().remove(listener);
    }

    public void removeValueChangedListener(ValueChangedListener listener) {
        this.getValueChangedListeners().remove(listener);
    }

    public void setColumnData(HashMap[] newColumnData) {
        this.columnData = newColumnData;
    }

    public void setColumnNames(String[] columnNames) {
        this.fColumnNames = columnNames;
    }

    public void setEditFirstColumn(boolean editFirstColumn) {
        this.fEditFirstColumn = editFirstColumn;
    }

    public void setSelection(String selection) {
        this.fSelection = selection;
    }

    protected class MultiCastingSelectionChangedListener
    implements ISelectionChangedListener {
        protected MultiCastingSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection sel = event.getSelection();
            if (sel != null && !sel.isEmpty() && sel instanceof IStructuredSelection) {
                StringPropertyTableViewer.this.setSelection((String)((IStructuredSelection)sel).getFirstElement());
            } else {
                StringPropertyTableViewer.this.setSelection(null);
            }
            StringPropertyTableViewer.this.fireSelectionChanged(event);
        }
    }

    protected class StringPropertyLabelProvider
    implements ITableLabelProvider {
        protected StringPropertyLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = null;
            text = element == null ? "" : (String)StringPropertyTableViewer.this.getColumnData()[columnIndex].get(element);
            if (text == null) {
                text = "";
            }
            return text;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

