/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.datamodel;

import org.eclipse.wst.ws.internal.datamodel.Connection;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Rel;

public class BasicConnection
implements Connection {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private Rel fRel;
    private Element fElement;
    private Connection fOpposingConnection;
    public static final int OUTBOUND = 0;
    public static final int INBOUND = 1;

    public static Connection[] createPair(Rel outboundRel, Element targetElement, Rel inboundRel, Element sourceElement) {
        BasicConnection outboundConnection = new BasicConnection(outboundRel, targetElement);
        BasicConnection inboundConnection = new BasicConnection(inboundRel, sourceElement);
        outboundConnection.fOpposingConnection = inboundConnection;
        inboundConnection.fOpposingConnection = outboundConnection;
        return new Connection[]{outboundConnection, inboundConnection};
    }

    public BasicConnection(Rel rel, Element element) {
        this.fRel = rel;
        this.fElement = element;
        this.fOpposingConnection = null;
    }

    @Override
    public Rel getRel() {
        return this.fRel;
    }

    @Override
    public Element getElement() {
        return this.fElement;
    }

    @Override
    public Connection getOpposingConnection() {
        return this.fOpposingConnection;
    }

    public String toString() {
        return this.fElement.getName();
    }
}

