/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm;

import java.beans.Introspector;
import java.util.List;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.context.AbstractQName;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbQName;
import org.eclipse.jpt.jaxb.core.context.TypeName;
import org.eclipse.jpt.jaxb.core.context.XmlRootElement;
import org.eclipse.jpt.jaxb.core.context.XmlSeeAlso;
import org.eclipse.jpt.jaxb.core.context.java.JavaType;
import org.eclipse.jpt.jaxb.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jaxb.core.internal.context.AbstractJaxbContextNode;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELJaxbPackage;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmTypeMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlBindings;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlRootElement;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlSeeAlso;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.OxmXmlRootElementImpl;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.OxmXmlSeeAlsoImpl;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EAbstractTypeMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlRootElement;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlSeeAlso;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlType;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.OxmFactory;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractOxmTypeMapping
extends AbstractJaxbContextNode
implements OxmTypeMapping {
    protected EAbstractTypeMapping eTypeMapping;
    protected TypeName typeName;
    protected JavaResourceType javaResourceType;
    protected JavaType javaType;
    protected boolean defaultXmlTransient = false;
    protected Boolean specifiedXmlTransient;
    protected boolean xmlTransient;
    protected final JaxbQName qName;
    protected XmlRootElement defaultXmlRootElement;
    protected OxmXmlRootElement specifiedXmlRootElement;
    protected XmlRootElement xmlRootElement;
    protected XmlSeeAlso defaultXmlSeeAlso;
    protected OxmXmlSeeAlso specifiedXmlSeeAlso;
    protected XmlSeeAlso xmlSeeAlso;

    public AbstractOxmTypeMapping(OxmXmlBindings parent, EAbstractTypeMapping eTypeMapping) {
        super((JaxbNode)parent);
        this.eTypeMapping = eTypeMapping;
        this.initTypeName();
        this.initXmlTransient();
        this.qName = this.buildQName();
        this.initXmlRootElement();
        this.initXmlSeeAlso();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncJavaType();
        this.syncXmlTransient();
        this.qName.synchronizeWithResourceModel();
        this.syncXmlRootElement();
        this.syncXmlSeeAlso();
    }

    public void update() {
        super.update();
        this.updateTypeName();
        this.updateJavaType();
        this.updateXmlTransient();
        this.qName.update();
        this.updateXmlRootElement();
        this.updateXmlSeeAlso();
    }

    @Override
    public EAbstractTypeMapping getETypeMapping() {
        return this.eTypeMapping;
    }

    @Override
    public OxmXmlBindings getXmlBindings() {
        return (OxmXmlBindings)super.getParent();
    }

    @Override
    public ELJaxbPackage getJaxbPackage() {
        return this.getXmlBindings().getOxmFile().getJaxbPackage();
    }

    public TypeName getTypeName() {
        return this.typeName;
    }

    protected void setTypeName_(TypeName typeName) {
        TypeName old = this.typeName;
        this.typeName = typeName;
        if (this.firePropertyChanged("typeName", old, typeName)) {
            this.setJavaType(null);
        }
    }

    protected void initTypeName() {
        this.typeName = this.buildTypeName();
    }

    protected abstract void updateTypeName();

    protected abstract TypeName buildTypeName();

    @Override
    public JavaType getJavaType() {
        return this.javaType;
    }

    protected void setJavaType(JavaType javaType) {
        JavaType oldJavaType = this.javaType;
        this.javaType = javaType;
        this.firePropertyChanged("javaType", oldJavaType, javaType);
    }

    protected void syncJavaType() {
        if (this.javaType != null) {
            this.javaType.synchronizeWithResourceModel();
        }
    }

    protected void updateJavaType() {
        if (StringTools.isBlank((String)this.typeName.getFullyQualifiedName())) {
            this.setJavaType(null);
        } else {
            JavaResourceAbstractType resourceType = this.resolveJavaResourceType();
            if (resourceType != null) {
                if (this.javaType == null || this.javaType.getJavaResourceType() != resourceType) {
                    this.setJavaType(this.buildJavaType(resourceType));
                } else if (this.javaType != null) {
                    this.javaType.update();
                }
            } else {
                this.setJavaType(null);
            }
        }
    }

    protected abstract JavaType buildJavaType(JavaResourceAbstractType var1);

    protected JavaResourceAbstractType resolveJavaResourceType() {
        String fqName = this.getTypeName().getFullyQualifiedName();
        if (StringTools.isBlank((String)fqName)) {
            return null;
        }
        return this.getJaxbProject().getJavaResourceType(fqName);
    }

    public JavaTypeMapping getJavaTypeMapping() {
        return this.javaType == null ? null : this.javaType.getMapping();
    }

    @Override
    public boolean isDefaultXmlTransient() {
        return this.defaultXmlTransient;
    }

    protected void setDefaultXmlTransient_(boolean newValue) {
        boolean old = this.defaultXmlTransient;
        this.defaultXmlTransient = newValue;
        this.firePropertyChanged("defaultXmlTransient", old, newValue);
    }

    @Override
    public Boolean getSpecifiedXmlTransient() {
        return this.specifiedXmlTransient;
    }

    @Override
    public void setSpecifiedXmlTransient(Boolean newValue) {
        this.setSpecifiedXmlTransient_(newValue);
        this.eTypeMapping.setXmlTransient(newValue);
    }

    protected void setSpecifiedXmlTransient_(Boolean newValue) {
        Boolean old = this.specifiedXmlTransient;
        this.specifiedXmlTransient = newValue;
        this.firePropertyChanged("specifiedXmlTransient", old, newValue);
    }

    public boolean isXmlTransient() {
        return this.xmlTransient;
    }

    protected void setXmlTransient_(boolean newValue) {
        boolean oldValue = this.xmlTransient;
        this.xmlTransient = newValue;
        this.firePropertyChanged("xmlTransient", oldValue, newValue);
    }

    protected void initXmlTransient() {
        this.specifiedXmlTransient = this.eTypeMapping.getXmlTransient();
    }

    protected void syncXmlTransient() {
        this.setSpecifiedXmlTransient_(this.eTypeMapping.getXmlTransient());
    }

    protected void updateXmlTransient() {
        JavaTypeMapping javaMapping;
        boolean defaultXmlTransient = false;
        if (!this.getXmlBindings().isXmlMappingMetadataComplete() && (javaMapping = this.getJavaTypeMapping()) != null) {
            defaultXmlTransient = javaMapping.isXmlTransient();
        }
        this.setDefaultXmlTransient_(defaultXmlTransient);
        boolean xmlTransient = this.specifiedXmlTransient != null ? this.specifiedXmlTransient : this.defaultXmlTransient;
        this.setXmlTransient_(xmlTransient);
    }

    public JaxbQName getQName() {
        return this.qName;
    }

    protected JaxbQName buildQName() {
        return new XmlTypeQName((JaxbContextNode)this);
    }

    @Override
    public XmlRootElement getDefaultXmlRootElement() {
        return this.defaultXmlRootElement;
    }

    protected void setDefaultXmlRootElement_(XmlRootElement xmlRootElement) {
        XmlRootElement old = this.defaultXmlRootElement;
        this.defaultXmlRootElement = xmlRootElement;
        this.firePropertyChanged("defaultXmlRootElement", old, xmlRootElement);
    }

    @Override
    public OxmXmlRootElement getSpecifiedXmlRootElement() {
        return this.specifiedXmlRootElement;
    }

    protected void setSpecifiedXmlRootElement_(OxmXmlRootElement xmlRootElement) {
        OxmXmlRootElement old = this.specifiedXmlRootElement;
        this.specifiedXmlRootElement = xmlRootElement;
        this.firePropertyChanged("specifiedXmlRootElement", old, xmlRootElement);
    }

    @Override
    public OxmXmlRootElement addSpecifiedXmlRootElement() {
        EXmlRootElement eXmlRootElement = OxmFactory.eINSTANCE.createEXmlRootElement();
        OxmXmlRootElement xmlRootElement = this.buildSpecifiedXmlRootElement(eXmlRootElement);
        this.setSpecifiedXmlRootElement_(xmlRootElement);
        this.eTypeMapping.setXmlRootElement(eXmlRootElement);
        return xmlRootElement;
    }

    @Override
    public void removeSpecifiedXmlRootElement() {
        this.eTypeMapping.setXmlRootElement(null);
        this.setSpecifiedXmlRootElement_(null);
    }

    protected OxmXmlRootElement buildSpecifiedXmlRootElement(EXmlRootElement eXmlRootElement) {
        return new OxmXmlRootElementImpl(this, eXmlRootElement);
    }

    public XmlRootElement getXmlRootElement() {
        return this.xmlRootElement;
    }

    protected void setXmlRootElement_(XmlRootElement xmlRootElement) {
        XmlRootElement old = this.xmlRootElement;
        this.xmlRootElement = xmlRootElement;
        this.firePropertyChanged("xmlRootElement", old, xmlRootElement);
    }

    protected void initXmlRootElement() {
        EXmlRootElement eXmlRootElement = this.eTypeMapping.getXmlRootElement();
        this.specifiedXmlRootElement = eXmlRootElement == null ? null : this.buildSpecifiedXmlRootElement(eXmlRootElement);
    }

    protected void syncXmlRootElement() {
        EXmlRootElement eXmlRootElement = this.eTypeMapping.getXmlRootElement();
        if (eXmlRootElement != null) {
            if (this.specifiedXmlRootElement != null) {
                this.specifiedXmlRootElement.synchronizeWithResourceModel();
            } else {
                this.setSpecifiedXmlRootElement_(this.buildSpecifiedXmlRootElement(eXmlRootElement));
            }
        } else if (this.specifiedXmlRootElement != null) {
            this.setSpecifiedXmlRootElement_(null);
        }
    }

    protected void updateXmlRootElement() {
        JavaTypeMapping javaMapping;
        XmlRootElement defaultXmlRootElement = null;
        if (!this.getXmlBindings().isXmlMappingMetadataComplete() && (javaMapping = this.getJavaTypeMapping()) != null) {
            defaultXmlRootElement = javaMapping.getXmlRootElement();
        }
        this.setDefaultXmlRootElement_(defaultXmlRootElement);
        OxmXmlRootElement xmlRootElement = this.specifiedXmlRootElement != null ? this.specifiedXmlRootElement : this.defaultXmlRootElement;
        this.setXmlRootElement_(xmlRootElement);
        if (this.specifiedXmlRootElement != null) {
            this.specifiedXmlRootElement.update();
        }
    }

    @Override
    public XmlSeeAlso getDefaultXmlSeeAlso() {
        return this.defaultXmlSeeAlso;
    }

    protected void setDefaultXmlSeeAlso_(XmlSeeAlso xmlSeeAlso) {
        XmlSeeAlso old = this.defaultXmlSeeAlso;
        this.defaultXmlSeeAlso = xmlSeeAlso;
        this.firePropertyChanged("defaultXmlSeeAlso", old, xmlSeeAlso);
    }

    @Override
    public OxmXmlSeeAlso getSpecifiedXmlSeeAlso() {
        return this.specifiedXmlSeeAlso;
    }

    protected void setSpecifiedXmlSeeAlso_(OxmXmlSeeAlso xmlSeeAlso) {
        OxmXmlSeeAlso old = this.specifiedXmlSeeAlso;
        this.specifiedXmlSeeAlso = xmlSeeAlso;
        this.firePropertyChanged("specifiedXmlSeeAlso", old, xmlSeeAlso);
    }

    @Override
    public OxmXmlSeeAlso addSpecifiedXmlSeeAlso() {
        EXmlSeeAlso eXmlSeeAlso = OxmFactory.eINSTANCE.createEXmlSeeAlso();
        OxmXmlSeeAlso xmlSeeAlso = this.buildSpecifiedXmlSeeAlso(eXmlSeeAlso);
        this.setSpecifiedXmlSeeAlso_(xmlSeeAlso);
        this.eTypeMapping.setXmlSeeAlso(eXmlSeeAlso);
        return xmlSeeAlso;
    }

    @Override
    public void removeSpecifiedXmlSeeAlso() {
        this.eTypeMapping.setXmlSeeAlso(null);
        this.setSpecifiedXmlSeeAlso_(null);
    }

    protected OxmXmlSeeAlso buildSpecifiedXmlSeeAlso(EXmlSeeAlso eXmlSeeAlso) {
        return new OxmXmlSeeAlsoImpl(this, eXmlSeeAlso);
    }

    public XmlSeeAlso getXmlSeeAlso() {
        return this.xmlSeeAlso;
    }

    protected void setXmlSeeAlso_(XmlSeeAlso xmlSeeAlso) {
        XmlSeeAlso old = this.xmlSeeAlso;
        this.xmlSeeAlso = xmlSeeAlso;
        this.firePropertyChanged("xmlSeeAlso", old, xmlSeeAlso);
    }

    protected void initXmlSeeAlso() {
        EXmlSeeAlso eXmlSeeAlso = this.eTypeMapping.getXmlSeeAlso();
        this.specifiedXmlSeeAlso = eXmlSeeAlso == null ? null : this.buildSpecifiedXmlSeeAlso(eXmlSeeAlso);
    }

    protected void syncXmlSeeAlso() {
        EXmlSeeAlso eXmlSeeAlso = this.eTypeMapping.getXmlSeeAlso();
        if (eXmlSeeAlso != null) {
            if (this.specifiedXmlSeeAlso != null) {
                this.specifiedXmlSeeAlso.synchronizeWithResourceModel();
            } else {
                this.setSpecifiedXmlSeeAlso_(this.buildSpecifiedXmlSeeAlso(eXmlSeeAlso));
            }
        } else if (this.specifiedXmlSeeAlso != null) {
            this.setSpecifiedXmlSeeAlso_(null);
        }
    }

    protected void updateXmlSeeAlso() {
        JavaTypeMapping javaMapping;
        XmlSeeAlso defaultXmlSeeAlso = null;
        if (!this.getXmlBindings().isXmlMappingMetadataComplete() && (javaMapping = this.getJavaTypeMapping()) != null) {
            defaultXmlSeeAlso = javaMapping.getXmlSeeAlso();
        }
        this.setDefaultXmlSeeAlso_(defaultXmlSeeAlso);
        OxmXmlSeeAlso xmlSeeAlso = this.specifiedXmlSeeAlso != null ? this.specifiedXmlSeeAlso : this.defaultXmlSeeAlso;
        this.setXmlSeeAlso_(xmlSeeAlso);
        if (this.specifiedXmlSeeAlso != null) {
            this.specifiedXmlSeeAlso.update();
        }
    }

    public Iterable<String> getReferencedXmlTypeNames() {
        return this.isXmlTransient() ? this.getTransientReferencedXmlTypeNames() : this.getNonTransientReferencedXmlTypeNames();
    }

    protected Iterable<String> getTransientReferencedXmlTypeNames() {
        return EmptyIterable.instance();
    }

    protected Iterable<String> getNonTransientReferencedXmlTypeNames() {
        if (this.xmlSeeAlso != null) {
            return this.xmlSeeAlso.getReferencedXmlTypeNames();
        }
        return EmptyIterable.instance();
    }

    public XsdTypeDefinition getXsdTypeDefinition() {
        XsdElementDeclaration xsdElement;
        XsdSchema xsdSchema;
        ELJaxbPackage jaxbPackage = this.getJaxbPackage();
        XsdSchema xsdSchema2 = xsdSchema = jaxbPackage == null ? null : jaxbPackage.getXsdSchema();
        if (xsdSchema == null) {
            return null;
        }
        if (!StringTools.isBlank((String)this.qName.getName())) {
            return xsdSchema.getTypeDefinition(this.qName.getNamespace(), this.qName.getName());
        }
        if (this.xmlRootElement != null && (xsdElement = xsdSchema.getElementDeclaration(this.xmlRootElement.getQName().getNamespace(), this.xmlRootElement.getQName().getName())) != null) {
            return xsdElement.getType();
        }
        return null;
    }

    public boolean hasRootElementInHierarchy() {
        return this.xmlRootElement != null;
    }

    protected class EXmlTypeProxy
    implements AbstractQName.ResourceProxy {
        protected EXmlTypeProxy() {
        }

        protected EXmlType getEXmlType(boolean createIfNull) {
            EXmlType eXmlType = AbstractOxmTypeMapping.this.eTypeMapping.getXmlType();
            if (eXmlType == null && createIfNull) {
                eXmlType = OxmFactory.eINSTANCE.createEXmlType();
                AbstractOxmTypeMapping.this.eTypeMapping.setXmlType(eXmlType);
            }
            return eXmlType;
        }

        public String getNamespace() {
            EXmlType eXmlType = this.getEXmlType(false);
            return eXmlType == null ? null : eXmlType.getNamespace();
        }

        public void setNamespace(String namespace) {
            this.getEXmlType(true).setNamespace(namespace);
        }

        public boolean namespaceTouches(int pos) {
            EXmlType eXmlType = this.getEXmlType(false);
            return eXmlType == null ? false : eXmlType.namespaceTouches(pos);
        }

        public TextRange getNamespaceValidationTextRange() {
            EXmlType eXmlType = this.getEXmlType(false);
            return eXmlType == null ? null : eXmlType.getNamespaceValidationTextRange();
        }

        public String getName() {
            EXmlType eXmlType = this.getEXmlType(false);
            return eXmlType == null ? null : eXmlType.getName();
        }

        public void setName(String name) {
            this.getEXmlType(true).setName(name);
        }

        public boolean nameTouches(int pos) {
            EXmlType eXmlType = this.getEXmlType(false);
            return eXmlType == null ? false : eXmlType.nameTouches(pos);
        }

        public TextRange getNameValidationTextRange() {
            EXmlType eXmlType = this.getEXmlType(false);
            return eXmlType == null ? null : eXmlType.getNameValidationTextRange();
        }
    }

    protected class XmlTypeQName
    extends AbstractQName {
        protected XmlTypeQName(JaxbContextNode parent) {
            super(parent, (AbstractQName.ResourceProxy)new EXmlTypeProxy());
        }

        protected JaxbPackage getJaxbPackage() {
            return AbstractOxmTypeMapping.this.getJaxbPackage();
        }

        protected String buildDefaultNamespace() {
            String namespace;
            JavaTypeMapping javaMapping;
            if (!AbstractOxmTypeMapping.this.getXmlBindings().isXmlMappingMetadataComplete() && (javaMapping = AbstractOxmTypeMapping.this.getJavaTypeMapping()) != null && (namespace = javaMapping.getQName().getSpecifiedNamespace()) != null) {
                return namespace;
            }
            return AbstractOxmTypeMapping.this.getXmlBindings().getXmlSchema().getNamespace();
        }

        protected String buildDefaultName() {
            String name;
            JavaTypeMapping javaMapping;
            if (!AbstractOxmTypeMapping.this.getXmlBindings().isXmlMappingMetadataComplete() && (javaMapping = AbstractOxmTypeMapping.this.getJavaTypeMapping()) != null && (name = javaMapping.getQName().getSpecifiedName()) != null) {
                return name;
            }
            return Introspector.decapitalize(AbstractOxmTypeMapping.this.getTypeName().getSimpleName());
        }

        protected Iterable<String> getNamespaceProposals() {
            XsdSchema schema = this.getXsdSchema();
            if (schema == null) {
                return EmptyIterable.instance();
            }
            return schema.getNamespaceProposals();
        }

        protected Iterable<String> getNameProposals() {
            XsdSchema schema = this.getXsdSchema();
            if (schema == null) {
                return EmptyIterable.instance();
            }
            return schema.getTypeNameProposals(this.getNamespace());
        }

        public String getReferencedComponentTypeDescription() {
            return JptJaxbCoreMessages.XML_TYPE_DESC;
        }

        protected void validateName(List<IMessage> messages, IReporter reporter) {
            if ("".equals(this.getName()) && !ObjectTools.equals((Object)this.getNamespace(), (Object)this.buildDefaultNamespace())) {
                messages.add(this.buildValidationMessage(this.proxy.getNamespaceValidationTextRange(), JptJaxbCoreValidationMessages.XML_TYPE__UNMATCHING_NAMESPACE_FOR_ANONYMOUS_TYPE));
            }
        }

        protected void validateReference(List<IMessage> messages, IReporter reporter) {
            XsdTypeDefinition schemaType;
            XsdSchema schema;
            String name = this.getName();
            String namespace = this.getNamespace();
            if (!StringTools.isBlank((String)name) && (schema = this.getXsdSchema()) != null && (schemaType = schema.getTypeDefinition(namespace, name)) == null) {
                messages.add(this.getUnresolveSchemaComponentMessage());
            }
        }
    }
}

