/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.IProfileExtensionProvider;
import org.eclipse.datatools.connectivity.IPropertiesPersistenceHook;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class ProfileExtensionProvider
implements IProfileExtensionProvider {
    public static final String ATTR_ID = "id";
    public static final String ATTR_PROFILE = "profile";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_PROPERTIES_PERSISTENCE_HOOK = "propertiesPersistenceHook";
    private String mId;
    private String mName;
    private String mProfile;
    private IPropertiesPersistenceHook mPropertiesPersistenceHook;
    private IConfigurationElement mElement;

    public ProfileExtensionProvider(IConfigurationElement element) {
        this.init(element);
    }

    @Override
    public IConnectionProfileProvider getConnectionProfileProvider() {
        return ConnectionProfileManager.getInstance().getProvider(this.mProfile);
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public IPropertiesPersistenceHook getPropertiesPersistenceHook() {
        this.loadPropertiesPersistenceHook();
        return this.mPropertiesPersistenceHook;
    }

    private void init(IConfigurationElement element) {
        Assert.isTrue((boolean)"profileExtension".equals(element.getName()));
        this.mElement = element;
        this.mId = element.getAttribute(ATTR_ID);
        this.mName = element.getAttribute(ATTR_NAME);
        this.mProfile = element.getAttribute(ATTR_PROFILE);
    }

    private void loadPropertiesPersistenceHook() {
        block4: {
            if (this.mPropertiesPersistenceHook == null) {
                this.mPropertiesPersistenceHook = ConnectionProfileProvider.DEFAULT_PROPERTIES_PERSISTENCE_HOOK;
                if (this.mElement.getAttribute(ATTR_PROPERTIES_PERSISTENCE_HOOK) != null) {
                    try {
                        this.mPropertiesPersistenceHook = (IPropertiesPersistenceHook)this.mElement.createExecutableExtension(ATTR_PROPERTIES_PERSISTENCE_HOOK);
                    }
                    catch (CoreException e) {
                        if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block4;
                        System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHook", new Object[]{this.mProfile, this.mId}));
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

