/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.ui.internal.tabs.processor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.jaxp.debug.ui.internal.preferences.ProcessorsPreferencePage;
import org.eclipse.wst.xsl.jaxp.debug.ui.internal.tabs.processor.ProcessorMessages;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorInstall;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorType;
import org.eclipse.wst.xsl.jaxp.launching.ITransformerFactory;
import org.eclipse.wst.xsl.jaxp.launching.JAXPRuntime;

public class ProcessorBlock
extends AbstractLaunchConfigurationTab {
    private Button usePreferencesRadio;
    private Button alterPreferencesButton;
    private Button overridePreferencesRadio;
    private Combo runCombo;
    private Button installedProcessorsButton;
    private ComboViewer runComboViewer;
    private ComboViewer factoryComboViewer;
    private ITransformerFactory currentFactory;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite group = new Composite(parent, 0);
        this.setControl((Control)group);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        group.setFont(font);
        this.usePreferencesRadio = new Button(group, 16);
        this.usePreferencesRadio.setText(ProcessorMessages.ProcessorBlock_1);
        this.usePreferencesRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessorBlock.this.preferencesSelected();
                ProcessorBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.alterPreferencesButton = new Button(group, 8);
        this.alterPreferencesButton.setText(ProcessorMessages.ProcessorBlock_2);
        GridData gd = new GridData(128);
        gd.widthHint = 150;
        this.alterPreferencesButton.setLayoutData((Object)gd);
        this.alterPreferencesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessorsPreferencePage page = new ProcessorsPreferencePage();
                ProcessorBlock.this.showPrefPage("org.eclipse.wst.xslt.launching.ui.preferences.ProcessorPreferencePage", (IPreferencePage)page);
            }
        });
        this.overridePreferencesRadio = new Button(group, 16);
        this.overridePreferencesRadio.setText(ProcessorMessages.ProcessorBlock_4);
        this.overridePreferencesRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessorBlock.this.overrideSelected();
                ProcessorBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.installedProcessorsButton = new Button(group, 8);
        this.installedProcessorsButton.setText(ProcessorMessages.ProcessorsComboBlock_1);
        gd = new GridData(128);
        gd.widthHint = 150;
        this.installedProcessorsButton.setLayoutData((Object)gd);
        this.installedProcessorsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessorsPreferencePage page = new ProcessorsPreferencePage();
                ProcessorBlock.this.showPrefPage("org.eclipse.wst.xslt.launching.ui.preferences.ProcessorPreferencePage", (IPreferencePage)page);
            }
        });
        Composite settingsComp = new Composite(group, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 2;
        settingsComp.setLayout((Layout)gl);
        gd = new GridData(768);
        gd.horizontalIndent = 15;
        gd.horizontalSpan = 2;
        settingsComp.setLayoutData((Object)gd);
        settingsComp.setFont(font);
        Label label = new Label(settingsComp, 0);
        label.setText(ProcessorMessages.ProcessorBlock_6);
        this.runCombo = new Combo(settingsComp, 12);
        this.runCombo.setLayoutData((Object)new GridData(768));
        this.runComboViewer = new ComboViewer(this.runCombo);
        this.runComboViewer.setContentProvider((IContentProvider)new ComboContentProvider());
        this.runComboViewer.setLabelProvider((IBaseLabelProvider)new ComboLabelProvider());
        this.runComboViewer.setInput((Object)JAXPRuntime.getProcessors());
        this.runComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    IProcessorInstall processor = (IProcessorInstall)sel.getFirstElement();
                    if (processor.getProcessorType().getTransformerFactories().length > 1) {
                        ProcessorBlock.this.factoryComboViewer.getCombo().setVisible(true);
                    } else {
                        ProcessorBlock.this.factoryComboViewer.getCombo().setVisible(false);
                    }
                    ProcessorBlock.this.factoryComboViewer.setInput((Object)processor.getProcessorType());
                    boolean found = false;
                    ITransformerFactory[] iTransformerFactoryArray = processor.getProcessorType().getTransformerFactories();
                    int n = iTransformerFactoryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITransformerFactory tf = iTransformerFactoryArray[n2];
                        if (tf.equals(ProcessorBlock.this.currentFactory)) {
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!found) {
                        ProcessorBlock.this.currentFactory = processor.getProcessorType().getDefaultTransformerFactory();
                        if (ProcessorBlock.this.currentFactory != null) {
                            ProcessorBlock.this.factoryComboViewer.setSelection((ISelection)new StructuredSelection((Object)ProcessorBlock.this.currentFactory));
                        }
                    }
                }
                ProcessorBlock.this.updateLaunchConfigurationDialog();
            }
        });
        Combo factoryCombo = new Combo(settingsComp, 12);
        factoryCombo.setLayoutData((Object)new GridData(80, -1));
        this.factoryComboViewer = new ComboViewer(factoryCombo);
        this.factoryComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private IProcessorType type;

            public Object[] getElements(Object inputElement) {
                return this.type.getTransformerFactories();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.type = (IProcessorType)newInput;
            }
        });
        this.factoryComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                ITransformerFactory f = (ITransformerFactory)element;
                return f.getName();
            }
        });
        this.factoryComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProcessorBlock.this.currentFactory = (ITransformerFactory)((IStructuredSelection)event.getSelection()).getFirstElement();
                ProcessorBlock.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void preferencesSelected() {
        this.alterPreferencesButton.setEnabled(true);
        this.installedProcessorsButton.setEnabled(false);
        this.runCombo.setEnabled(false);
        this.factoryComboViewer.getCombo().setEnabled(false);
        this.runComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.getRunProcessorPreference()), true);
    }

    private void overrideSelected() {
        this.alterPreferencesButton.setEnabled(false);
        this.installedProcessorsButton.setEnabled(true);
        this.factoryComboViewer.getCombo().setEnabled(true);
        this.runCombo.setEnabled(true);
    }

    private void showPrefPage(String id, IPreferencePage page) {
        XSLDebugUIPlugin.showPreferencePage((String)id, (IPreferencePage)page);
        this.runComboViewer.setInput((Object)JAXPRuntime.getProcessors());
        this.runComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.getRunProcessorPreference()), true);
    }

    public String getName() {
        return ProcessorMessages.ProcessorBlock_7;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            boolean useDefaultProcessor = configuration.getAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_USE_DEFAULT_PROCESSOR", true);
            if (useDefaultProcessor) {
                this.usePreferencesRadio.setSelection(true);
                this.overridePreferencesRadio.setSelection(false);
                this.preferencesSelected();
            } else {
                this.usePreferencesRadio.setSelection(false);
                this.overridePreferencesRadio.setSelection(true);
                this.overrideSelected();
                IProcessorInstall runInstall = null;
                String runId = configuration.getAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_PROCESSOR", null);
                if (runId != null) {
                    runInstall = JAXPRuntime.getProcessor((String)runId);
                }
                if (runInstall == null) {
                    runInstall = this.getRunProcessorPreference();
                }
                this.runComboViewer.setSelection((ISelection)new StructuredSelection((Object)runInstall));
                String factoryId = configuration.getAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_TRANSFORMER_FACTORY", null);
                if (factoryId == null) {
                    this.currentFactory = runInstall.getProcessorType().getDefaultTransformerFactory();
                } else {
                    ITransformerFactory[] iTransformerFactoryArray = runInstall.getProcessorType().getTransformerFactories();
                    int n = iTransformerFactoryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITransformerFactory tf = iTransformerFactoryArray[n2];
                        if (tf.getFactoryClass().equals(factoryId)) {
                            this.currentFactory = tf;
                            break;
                        }
                        ++n2;
                    }
                }
                if (this.currentFactory == null) {
                    this.currentFactory = runInstall.getProcessorType().getDefaultTransformerFactory();
                }
                if (this.currentFactory != null) {
                    this.factoryComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.currentFactory), true);
                }
            }
        }
        catch (CoreException e) {
            XSLDebugUIPlugin.log((CoreException)e);
        }
    }

    private IProcessorInstall getRunProcessorPreference() {
        return JAXPRuntime.getDefaultProcessor();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        boolean usePreferences = this.usePreferencesRadio.getSelection();
        configuration.setAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_USE_DEFAULT_PROCESSOR", usePreferences);
        if (!usePreferences) {
            IProcessorInstall runprocessor = (IProcessorInstall)((IStructuredSelection)this.runComboViewer.getSelection()).getFirstElement();
            configuration.setAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_PROCESSOR", runprocessor.getId());
            configuration.setAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_TRANSFORMER_FACTORY", this.currentFactory == null ? null : this.currentFactory.getFactoryClass());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_USE_DEFAULT_PROCESSOR", true);
        configuration.setAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_PROCESSOR", null);
    }

    private static class ComboContentProvider
    implements IStructuredContentProvider {
        private ComboContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return JAXPRuntime.getProcessors();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ComboLabelProvider
    extends LabelProvider {
        private ComboLabelProvider() {
        }

        public String getText(Object element) {
            IProcessorInstall install = (IProcessorInstall)element;
            return install.getName();
        }
    }
}

