/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.ExamplePlugin;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.Messages;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.IDatabaseSetting;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.sql.identifier.DefaultIdentifierValidator;
import org.eclipse.datatools.sqltools.sql.identifier.IIdentifierValidator;
import org.eclipse.datatools.sqltools.sql.identifier.ValidatorMessage;

public class ASAIdentifierValidator
extends DefaultIdentifierValidator {
    public static final int MAXIMUM_ID_LENGTH = 128;
    private static IIdentifierValidator _instance = null;

    public static synchronized IIdentifierValidator getInstance() {
        if (_instance == null) {
            return new ASAIdentifierValidator();
        }
        return _instance;
    }

    protected ValidatorMessage checkIdentiferLength(String value, int identifierType) {
        if (value != null && value.length() > 128) {
            return new ValidatorMessage(2, Messages.IdentifierValidator_asa_invalidlength);
        }
        return new ValidatorMessage(0, "");
    }

    protected String[] getValidStart(int identfierType) {
        return new String[]{"_", "@", "$", "#"};
    }

    public int getMaximumIdLength(int idType) {
        return 128;
    }

    protected boolean supportsDelimitedIdentifier(int identifierType) {
        return true;
    }

    protected ValidatorMessage checkCustomization(String value, int identiferType, DatabaseIdentifier databaseIdentifier) {
        boolean quoted = this.isQuotedIdentifierSet(databaseIdentifier);
        if (!quoted && value.indexOf("//") > -1) {
            return new ValidatorMessage(2, Messages.IdentifierValidator_invalid_part);
        }
        return null;
    }

    protected ValidatorMessage checkIdentifierPart(String value, int identifierType, DatabaseIdentifier dbIdentifier) {
        if (value.length() == 1) {
            return null;
        }
        int i = 1;
        while (i < value.length()) {
            if (!this.isSQLIdentifierPart(value.charAt(i))) {
                return new ValidatorMessage(2, Messages.IdentifierValidator_invalid_part);
            }
            ++i;
        }
        return null;
    }

    protected boolean isSQLIdentifierPart(char c) {
        if (!Character.isLetterOrDigit(c)) {
            String[] validPart = new String[]{"@", "#", "_"};
            int i = 0;
            while (i < validPart.length) {
                if (String.valueOf(c).equals(validPart[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    private boolean isQuotedIdentifierSet(DatabaseIdentifier databaseIdentifier) {
        boolean quoted_id = true;
        SQLDevToolsConfiguration conf = SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)databaseIdentifier);
        IDatabaseSetting setting = conf.getDatabaseSetting(databaseIdentifier);
        if (setting != null) {
            try {
                Boolean value = (Boolean)setting.getConnectionConfigProperty("C_QUOTED_IDENTIFIER");
                quoted_id = value;
            }
            catch (IDatabaseSetting.NotSupportedSettingException notSupportedSettingException) {
                ExamplePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", Messages.NotSupportedSettingException_cause));
            }
        }
        return quoted_id;
    }
}

