/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.net.URI;
import java.nio.file.Path;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class CopyLocationAction
extends Action {
    private final StructuredViewer fViewer;
    private String fLocation;

    public CopyLocationAction(StructuredViewer viewer) {
        this.fViewer = viewer;
        this.setText(Messages.CopyLocationAction_copyLocation);
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        viewer.addPostSelectionChangedListener(event -> this.updateEnablement(event.getStructuredSelection()));
        this.updateEnablement(viewer.getStructuredSelection());
    }

    public void run() {
        Clipboard clipboard = new Clipboard(this.fViewer.getControl().getDisplay());
        try {
            clipboard.setContents(new Object[]{this.fLocation}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            clipboard.dispose();
        }
    }

    private void updateEnablement(IStructuredSelection selection) {
        this.fLocation = null;
        if (selection.size() == 1) {
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof TargetBundle) {
                URI location;
                TargetBundle targetBundle = (TargetBundle)firstElement;
                BundleInfo bundleInfo = targetBundle.getBundleInfo();
                if (bundleInfo != null && (location = bundleInfo.getLocation()) != null && "file".equals(location.getScheme())) {
                    this.fLocation = Path.of(location).toString();
                }
            } else if (firstElement instanceof TargetFeature) {
                TargetFeature targetFeature = (TargetFeature)firstElement;
                this.fLocation = targetFeature.getLocation();
            } else if (firstElement instanceof BundleDescription) {
                BundleDescription bundleDescription = (BundleDescription)firstElement;
                this.fLocation = bundleDescription.getLocation();
            }
        }
        this.setEnabled(this.fLocation != null);
    }
}

