/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.internal.impl;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConsumerPlugin;
import org.eclipse.datatools.connectivity.oda.consumer.nls.Messages;
import org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers;

public class LogPathHelper {
    private static final String LOG_SUBFOLDER_NAME = "logs";
    private static final String BUNDLE_NAME = "org.eclipse.datatools.connectivity.oda.consumer";
    private static IPath sm_consumerLogPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static IPath getPluginLogPath(ResourceIdentifiers resourceIdentifiers) throws IllegalStateException {
        if (sm_consumerLogPath != null) return sm_consumerLogPath;
        OdaConsumerPlugin thePlugin = OdaConsumerPlugin.getDefault();
        IPath consumerLogPath = null;
        if (thePlugin != null) {
            consumerLogPath = thePlugin.getStateLocation().append(LOG_SUBFOLDER_NAME);
        } else {
            URI logUri = null;
            if (resourceIdentifiers != null) {
                logUri = resourceIdentifiers.resolveResourceLocation(LOG_SUBFOLDER_NAME);
            }
            if (logUri == null) {
                throw new IllegalStateException(Messages.bind((String)Messages.helper_unknownPluginLogPath, (Object)resourceIdentifiers));
            }
            consumerLogPath = new Path(logUri.getPath()).append(BUNDLE_NAME);
        }
        Class<LogPathHelper> clazz = LogPathHelper.class;
        synchronized (LogPathHelper.class) {
            if (sm_consumerLogPath != null) return sm_consumerLogPath;
            sm_consumerLogPath = consumerLogPath;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return sm_consumerLogPath;
        }
    }

    static File getConsumerLogParent(String subdirName, ResourceIdentifiers resourceIdentifiers) {
        IPath pluginLogPath = LogPathHelper.getPluginLogPath(resourceIdentifiers);
        if (subdirName == null || subdirName.length() == 0) {
            return pluginLogPath.toFile();
        }
        return pluginLogPath.append(subdirName).toFile();
    }

    public static String getAbsoluteLogDirName(String logDirectory) {
        return LogPathHelper.getAbsoluteLogDirName(logDirectory, null);
    }

    public static String getAbsoluteLogDirName(String logDirectory, ResourceIdentifiers resourceIdentifiers) {
        if (logDirectory == null || logDirectory.length() == 0) {
            return null;
        }
        File logParent = new File(logDirectory);
        if (logParent.isAbsolute()) {
            return logDirectory;
        }
        return LogPathHelper.getConsumerLogParent(logDirectory, resourceIdentifiers).getPath();
    }
}

