/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.manipulation.internal.javadoc;

import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.text.readers.SingleCharacterReader;

public class CoreJavaDocCommentReader
extends SingleCharacterReader {
    private IBuffer fBuffer;
    private String fSource;
    private int fCurrPos;
    private int fStartPos;
    private int fEndPos;
    private boolean fWasNewLine;

    public CoreJavaDocCommentReader(IBuffer buf, int start, int end) {
        this.fBuffer = buf;
        this.fStartPos = start + 3;
        this.fEndPos = end - 2;
        this.reset();
    }

    public CoreJavaDocCommentReader(String source, int start, int end) {
        this.fSource = source;
        this.fStartPos = start + 3;
        this.fEndPos = end - 2;
        this.reset();
    }

    public int read() {
        if (this.fCurrPos < this.fEndPos) {
            char ch = this.getChar(this.fCurrPos++);
            if (this.fWasNewLine && !IndentManipulation.isLineDelimiterChar((char)ch)) {
                while (this.fCurrPos < this.fEndPos && Character.isWhitespace(ch)) {
                    ch = this.getChar(this.fCurrPos++);
                }
                if (ch == '*') {
                    if (this.fCurrPos < this.fEndPos) {
                        while ((ch = this.getChar(this.fCurrPos++)) == '*') {
                        }
                    } else {
                        return -1;
                    }
                }
            }
            this.fWasNewLine = IndentManipulation.isLineDelimiterChar((char)ch);
            return ch;
        }
        return -1;
    }

    public void close() {
        this.fSource = null;
        this.fBuffer = null;
    }

    public void reset() {
        this.fCurrPos = this.fStartPos;
        this.fWasNewLine = true;
        if (this.fCurrPos < this.fEndPos && '\r' == this.getChar(this.fCurrPos)) {
            ++this.fCurrPos;
        }
        if (this.fCurrPos < this.fEndPos && '\n' == this.getChar(this.fCurrPos)) {
            ++this.fCurrPos;
        }
    }

    private char getChar(int pos) {
        if (this.fBuffer != null) {
            return this.fBuffer.getChar(pos);
        }
        return this.fSource.charAt(pos);
    }

    public int getOffset() {
        return this.fCurrPos;
    }
}

