/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly;

import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyHyperlinkDetector;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyPart;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyTextHover;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class DisassemblyViewerConfiguration
extends TextSourceViewerConfiguration {
    private DisassemblyPart fPart;

    public DisassemblyViewerConfiguration(DisassemblyPart part) {
        super(EditorsUI.getPreferenceStore());
        this.fPart = part;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        SimpleDamagerRepairer dr = new SimpleDamagerRepairer();
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IUndoManager getUndoManager(ISourceViewer sourceViewer) {
        return null;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new DisassemblyTextHover(this.fPart);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (this.fPart == null || inheritedDetectors == null) {
            return inheritedDetectors;
        }
        int inheritedDetectorsLength = inheritedDetectors.length;
        IHyperlinkDetector[] detectors = new IHyperlinkDetector[inheritedDetectorsLength + 1];
        detectors[0] = new DisassemblyHyperlinkDetector(this.fPart);
        int i = 0;
        while (i < inheritedDetectorsLength) {
            detectors[i + 1] = inheritedDetectors[i];
            ++i;
        }
        return detectors;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return null;
    }

    public class SimpleDamagerRepairer
    implements IPresentationDamager,
    IPresentationRepairer {
        public void setDocument(IDocument document) {
        }

        public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
            int start = e.fOffset;
            int end = e.getOffset() + (e.getText() == null ? 0 : e.getText().length());
            return new Region(start, end - start);
        }

        public void createPresentation(TextPresentation presentation, ITypedRegion damage) {
        }
    }
}

