/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.handles;

import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.swt.graphics.Cursor;

public abstract class AbstractHandle
extends Figure
implements Handle,
AncestorListener {
    private GraphicalEditPart editpart;
    private DragTracker dragTracker;
    private Locator locator;

    public AbstractHandle() {
    }

    public AbstractHandle(GraphicalEditPart owner, Locator loc) {
        this.setOwner(owner);
        this.setLocator(loc);
    }

    public AbstractHandle(GraphicalEditPart owner, Locator loc, Cursor c) {
        this(owner, loc);
        this.setCursor(c);
    }

    public void addNotify() {
        super.addNotify();
        this.getOwnerFigure().addAncestorListener((AncestorListener)this);
    }

    public void ancestorMoved(IFigure ancestor) {
        this.revalidate();
    }

    public void ancestorAdded(IFigure ancestor) {
    }

    public void ancestorRemoved(IFigure ancestor) {
    }

    protected abstract DragTracker createDragTracker();

    @Override
    public Point getAccessibleLocation() {
        Point p = this.getBounds().getCenter();
        this.translateToAbsolute((Translatable)p);
        return p;
    }

    @Deprecated
    public Cursor getDragCursor() {
        return this.getCursor();
    }

    @Override
    public DragTracker getDragTracker() {
        if (this.dragTracker == null) {
            this.dragTracker = this.createDragTracker();
        }
        return this.dragTracker;
    }

    public Locator getLocator() {
        return this.locator;
    }

    protected GraphicalEditPart getOwner() {
        return this.editpart;
    }

    protected IFigure getOwnerFigure() {
        return this.getOwner().getFigure();
    }

    public void removeNotify() {
        this.getOwnerFigure().removeAncestorListener((AncestorListener)this);
        super.removeNotify();
    }

    @Deprecated
    public void setDragCursor(Cursor c) throws Exception {
        this.setCursor(c);
    }

    public void setDragTracker(DragTracker t) {
        this.dragTracker = t;
    }

    protected void setLocator(Locator locator) {
        this.locator = locator;
    }

    protected void setOwner(GraphicalEditPart editpart) {
        this.editpart = editpart;
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        this.getLocator().relocate((IFigure)this);
        super.validate();
    }
}

