/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.apache.jxpath.ri.compiler;

import org.eclipse.rap.e4.apache.jxpath.ri.EvalContext;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.InitialContext;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.NodeSetContext;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.PredicateContext;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.SimplePathInterpreter;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.UnionContext;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.CoreOperation;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.Expression;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.LocationPath;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.Path;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.Step;
import org.eclipse.rap.e4.apache.jxpath.ri.model.NodePointer;

public class ExpressionPath
extends Path {
    private Expression expression;
    private Expression[] predicates;
    private boolean basicKnown = false;
    private boolean basic;

    public ExpressionPath(Expression expression, Expression[] predicates, Step[] steps) {
        super(steps);
        this.expression = expression;
        this.predicates = predicates;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Expression[] getPredicates() {
        return this.predicates;
    }

    @Override
    public boolean computeContextDependent() {
        if (this.expression.isContextDependent()) {
            return true;
        }
        if (this.predicates != null) {
            int i = 0;
            while (i < this.predicates.length) {
                if (this.predicates[i].isContextDependent()) {
                    return true;
                }
                ++i;
            }
        }
        return super.computeContextDependent();
    }

    public synchronized boolean isSimpleExpressionPath() {
        if (!this.basicKnown) {
            this.basicKnown = true;
            this.basic = this.isSimplePath() && this.areBasicPredicates(this.getPredicates());
        }
        return this.basic;
    }

    public String toString() {
        Step[] steps;
        StringBuffer buffer = new StringBuffer();
        if (this.expression instanceof CoreOperation || this.expression instanceof ExpressionPath || this.expression instanceof LocationPath) {
            buffer.append('(');
            buffer.append(this.expression);
            buffer.append(')');
        } else {
            buffer.append(this.expression);
        }
        if (this.predicates != null) {
            int i = 0;
            while (i < this.predicates.length) {
                buffer.append('[');
                buffer.append(this.predicates[i]);
                buffer.append(']');
                ++i;
            }
        }
        if ((steps = this.getSteps()) != null) {
            int i = 0;
            while (i < steps.length) {
                buffer.append("/");
                buffer.append(steps[i]);
                ++i;
            }
        }
        return buffer.toString();
    }

    @Override
    public Object compute(EvalContext context) {
        return this.expressionPath(context, false);
    }

    @Override
    public Object computeValue(EvalContext context) {
        return this.expressionPath(context, true);
    }

    protected Object expressionPath(EvalContext evalContext, boolean firstMatch) {
        EvalContext ctx;
        NodePointer ptr;
        Object value = this.expression.compute(evalContext);
        EvalContext context = value instanceof InitialContext ? (InitialContext)value : (value instanceof EvalContext ? new UnionContext(evalContext, new EvalContext[]{(EvalContext)value}) : evalContext.getRootContext().getConstantContext(value));
        if (firstMatch && this.isSimpleExpressionPath() && !(context instanceof NodeSetContext) && (ptr = (NodePointer)(ctx = context).getSingleNodePointer()) != null && (ptr.getIndex() == Integer.MIN_VALUE || this.predicates == null || this.predicates.length == 0)) {
            return SimplePathInterpreter.interpretSimpleExpressionPath(evalContext, ptr, this.predicates, this.getSteps());
        }
        if (this.predicates != null) {
            int j = 0;
            while (j < this.predicates.length) {
                if (j != 0) {
                    context = new UnionContext(context, new EvalContext[]{context});
                }
                context = new PredicateContext(context, this.predicates[j]);
                ++j;
            }
        }
        return firstMatch ? this.getSingleNodePointerForSteps(context) : this.evalSteps(context);
    }
}

