/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.di.internal.extensions;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;

@Component(service={ExtendedObjectSupplier.class, EventHandler.class}, property={"dependency.injection.annotation=org.eclipse.e4.core.di.extensions.Service", "event.topics=org/eclipse/e4/core/contexts/IEclipseContext/DISPOSE"})
public class ServiceSupplier
extends ExtendedObjectSupplier
implements EventHandler {
    LoggerFactory factory;
    Logger logger;
    private volatile BundleTracker<ServiceSupplierContext> supplierContextTracker;

    @Activate
    void activate(final BundleContext bundleContext) {
        this.supplierContextTracker = new BundleTracker(bundleContext, 60, (BundleTrackerCustomizer)new BundleTrackerCustomizer<ServiceSupplierContext>(){

            public ServiceSupplierContext addingBundle(Bundle bundle, BundleEvent event) {
                return new ServiceSupplierContext(bundle, bundleContext, (t, e) -> ServiceSupplier.this.logError("Injection failed", e));
            }

            public void modifiedBundle(Bundle bundle, BundleEvent event, ServiceSupplierContext object) {
                switch (event.getType()) {
                    case 256: {
                        object.serviceTracker.values().forEach(ServiceTracker::close);
                        break;
                    }
                    case 2: 
                    case 4: {
                        object.refreshServices();
                        break;
                    }
                }
            }

            public void removedBundle(Bundle bundle, BundleEvent event, ServiceSupplierContext object) {
                object.dispose();
            }
        });
        this.supplierContextTracker.open();
    }

    @Deactivate
    void deactivate(BundleContext bundleContext) {
        this.supplierContextTracker.close();
    }

    public Object get(IObjectDescriptor descriptor, IRequestor requestor, boolean track, boolean group) {
        ParameterizedType t;
        ServiceSupplierContext supplierContext;
        Type desiredType = descriptor.getDesiredType();
        Bundle bundle = FrameworkUtil.getBundle((Class)requestor.getRequestingObjectClass());
        if (bundle == null || (supplierContext = (ServiceSupplierContext)this.supplierContextTracker.getObject(bundle)) == null || supplierContext.disposed) {
            return IInjector.NOT_A_VALUE;
        }
        Service qualifier = (Service)descriptor.getQualifier(Service.class);
        if (desiredType instanceof ParameterizedType && ((t = (ParameterizedType)desiredType).getRawType() == Collections.class || t.getRawType() == List.class)) {
            return this.handleCollection(supplierContext, t.getActualTypeArguments()[0], requestor, track && qualifier.dynamic(), qualifier);
        }
        return this.handleSingle(supplierContext, desiredType, requestor, track && qualifier.dynamic(), qualifier);
    }

    private Object handleSingle(ServiceSupplierContext supplierContext, Type t, IRequestor requestor, boolean track, Service qualifier) {
        Class clazz;
        if (t instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)t;
            clazz = (Class)p.getRawType();
        } else {
            clazz = (Class)t;
        }
        Class cls = clazz;
        try {
            Filter filter = supplierContext.getFilter(qualifier.filterExpression());
            ServiceSupplierTracker tracker = supplierContext.getTracker(cls);
            return tracker.getAndTrack(filter, (IRequestor)(track ? requestor : null), s -> {
                Optional service = s.findFirst();
                if (service.isPresent()) {
                    return service.get();
                }
                return IInjector.NOT_A_VALUE;
            });
        }
        catch (InvalidSyntaxException e) {
            this.logError("Invalid filter expression", e);
            return IInjector.NOT_A_VALUE;
        }
    }

    private Object handleCollection(ServiceSupplierContext supplierContext, Type t, IRequestor requestor, boolean track, Service qualifier) {
        Class clazz;
        if (t instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)t;
            clazz = (Class)p.getRawType();
        } else {
            clazz = (Class)t;
        }
        Class cls = clazz;
        try {
            Filter filter = supplierContext.getFilter(qualifier.filterExpression());
            ServiceSupplierTracker tracker = supplierContext.getTracker(cls);
            return tracker.getAndTrack(filter, (IRequestor)(track ? requestor : null), s -> s.collect(Collectors.toList()));
        }
        catch (InvalidSyntaxException e) {
            this.logError("Invalid filter expression", e);
            return IInjector.NOT_A_VALUE;
        }
    }

    void logError(String message, Throwable e) {
        Logger log = this.logger;
        if (log != null) {
            log.error(message, (Object)e);
        } else {
            e.printStackTrace();
        }
    }

    public void handleEvent(Event event) {
        this.supplierContextTracker.getTracked().values().stream().flatMap(ctx -> ctx.serviceTracker.values().stream()).forEach(ServiceSupplierTracker::cleanup);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    void setLogger(LoggerFactory factory) {
        this.factory = factory;
        this.logger = factory.getLogger(((Object)((Object)this)).getClass());
    }

    void unsetLogger(LoggerFactory loggerFactory) {
        if (this.factory == loggerFactory) {
            this.factory = null;
            this.logger = null;
        }
    }

    private static final class ServiceSupplierContext {
        private final Bundle bundle;
        private final BundleContext serviceBundleContext;
        final Map<Class<?>, ServiceSupplierTracker<?>> serviceTracker = new ConcurrentHashMap();
        volatile boolean disposed;
        private final Thread.UncaughtExceptionHandler exceptionHandler;

        ServiceSupplierContext(Bundle bundle, BundleContext serviceBundleContext, Thread.UncaughtExceptionHandler exceptionHandler) {
            this.bundle = bundle;
            this.serviceBundleContext = serviceBundleContext;
            this.exceptionHandler = exceptionHandler;
        }

        public Filter getFilter(String filterExpression) throws InvalidSyntaxException {
            if (filterExpression == null || filterExpression.isEmpty() || this.disposed) {
                return null;
            }
            return this.serviceBundleContext.createFilter(filterExpression);
        }

        public <T> ServiceSupplierTracker<T> getTracker(Class<T> serviceClass) {
            return this.serviceTracker.computeIfAbsent(serviceClass, cls -> {
                BundleContext bundleContext = this.bundle.getBundleContext();
                if (bundleContext == null || this.bundle.getState() == 16) {
                    bundleContext = this.serviceBundleContext;
                }
                ServiceSupplierTracker tracker = new ServiceSupplierTracker(bundleContext, serviceClass, this.exceptionHandler);
                tracker.open();
                return tracker;
            });
        }

        void refreshServices() {
            for (Map.Entry<Class<?>, ServiceSupplierTracker<?>> entry : this.serviceTracker.entrySet()) {
                this.serviceTracker.compute(entry.getKey(), (k, v) -> {
                    if (v != null) {
                        v.close();
                        v.update(null);
                    }
                    return null;
                });
            }
        }

        void dispose() {
            this.disposed = true;
            this.refreshServices();
        }
    }

    private static final class ServiceSupplierTracker<T>
    extends ServiceTracker<T, T> {
        Set<IRequestor> trackedRequestors = ConcurrentHashMap.newKeySet();
        private final Thread.UncaughtExceptionHandler exceptionHandler;
        private final AtomicReference<CompletableFuture<?>> pending = new AtomicReference();

        public ServiceSupplierTracker(BundleContext context, Class<T> clazz, Thread.UncaughtExceptionHandler exceptionHandler) {
            super(context, clazz, null);
            this.exceptionHandler = exceptionHandler;
        }

        public synchronized <R> R getAndTrack(Filter f, IRequestor requestor, Function<Stream<T>, R> extractor) {
            this.cleanup();
            Stream<Object> stream = this.getTracked().entrySet().stream().filter(entry -> f == null || f.match((ServiceReference)entry.getKey())).map(Map.Entry::getValue);
            R value = extractor.apply(stream);
            if (requestor != null) {
                this.trackedRequestors.add(requestor);
            }
            return value;
        }

        void cleanup() {
            Iterator<IRequestor> iterator = this.trackedRequestors.iterator();
            while (iterator.hasNext()) {
                IRequestor requestor = iterator.next();
                if (requestor.isValid()) continue;
                iterator.remove();
            }
        }

        public T addingService(ServiceReference<T> reference) {
            Object service = super.addingService(reference);
            if (service != null) {
                this.update(() -> this.getService(reference) != null);
            }
            return (T)service;
        }

        public void removedService(ServiceReference<T> reference, T service) {
            super.removedService(reference, service);
            this.update(() -> this.getService(reference) == null);
        }

        public void modifiedService(ServiceReference<T> reference, T service) {
            super.modifiedService(reference, service);
            this.update(null);
        }

        private void update(BooleanSupplier check) {
            IRequestor[] requestors = (IRequestor[])this.trackedRequestors.toArray(IRequestor[]::new);
            if (requestors.length == 0) {
                return;
            }
            CompletableFuture<Void> execution = new CompletableFuture<Void>();
            CompletableFuture pendingExecution = this.pending.getAndSet(execution);
            if (pendingExecution != null) {
                pendingExecution.cancel(true);
            }
            execution.completeAsync(() -> {
                if (check != null) {
                    do {
                        Thread.yield();
                    } while (!check.getAsBoolean() && !execution.isCancelled());
                }
                if (!execution.isCancelled()) {
                    this.refreshRequestors(requestors);
                }
                return null;
            }).handle((v, e) -> {
                if (e instanceof CancellationException) {
                    return null;
                }
                if (e != null) {
                    this.exceptionHandler.uncaughtException(Thread.currentThread(), (Throwable)e);
                }
                this.pending.compareAndSet(execution, null);
                return null;
            });
        }

        private synchronized void refreshRequestors(IRequestor[] requestors) {
            IRequestor[] iRequestorArray = requestors;
            int n = requestors.length;
            int n2 = 0;
            while (n2 < n) {
                IRequestor requestor = iRequestorArray[n2];
                if (requestor.isValid()) {
                    try {
                        requestor.resolveArguments(false);
                        requestor.execute();
                    }
                    catch (RuntimeException e) {
                        this.exceptionHandler.uncaughtException(Thread.currentThread(), e);
                    }
                } else {
                    this.trackedRequestors.remove(requestor);
                }
                ++n2;
            }
        }
    }
}

