/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.oxm;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.oxm.OXMJavaClassImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaClassImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;

public class OXMJavaModelImpl
extends JavaModelImpl
implements JavaModel {
    private Map<String, JavaClass> javaModelClasses = new HashMap<String, JavaClass>();
    private static String DEFAULT = "DEFAULT";
    private static String JAVA_LANG_OBJECT = "java.lang.Object";

    public OXMJavaModelImpl(ClassLoader loader, JavaClass[] javaClasses) {
        super(loader);
        for (int i = 0; i < javaClasses.length; ++i) {
            this.javaModelClasses.put(javaClasses[i].getQualifiedName(), javaClasses[i]);
        }
    }

    @Override
    public JavaClass getClass(Class<?> jClass) {
        if (jClass == null) {
            return null;
        }
        String className = jClass.getCanonicalName();
        JavaClass cachedClass = this.javaModelClasses.get(className);
        if (cachedClass != null) {
            return cachedClass;
        }
        try {
            Class realClass;
            if (jClass.isArray()) {
                className = jClass.getName();
            }
            if ((realClass = PrivilegedAccessHelper.getClassForName(className, true, this.classLoader)) != null) {
                JavaModelImpl jm = new JavaModelImpl(this.classLoader);
                JavaClassImpl jc = new JavaClassImpl(realClass, jm);
                return jc;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new OXMJavaClassImpl(jClass.getCanonicalName());
    }

    @Override
    public JavaClass getClass(String className) {
        if (className == null) {
            return null;
        }
        if (className.contains(DEFAULT)) {
            return this.getClass(JAVA_LANG_OBJECT);
        }
        JavaClass cachedClass = this.javaModelClasses.get(className);
        if (cachedClass != null) {
            return cachedClass;
        }
        try {
            Class realClass = PrivilegedAccessHelper.getClassForName(className, true, this.classLoader);
            if (realClass != null) {
                JavaModelImpl jm = new JavaModelImpl(this.classLoader);
                JavaClassImpl jc = new JavaClassImpl(realClass, jm);
                return jc;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new OXMJavaClassImpl(className);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public JaxbClassLoader getJaxbClassLoader() {
        ClassLoader parent = this.getClassLoader().getParent();
        if (parent instanceof JaxbClassLoader) {
            return (JaxbClassLoader)parent;
        }
        return null;
    }
}

