/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model;

import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.FormLayout.model.FormSizeConstantInfo;

public final class FormSizeInfo {
    private final boolean m_horizontal;
    private Size m_componentSize;
    private FormSizeConstantInfo m_constantSize;
    private boolean m_hasLowerSize;
    private FormSizeConstantInfo m_lowerSize;
    private FormSizeConstantInfo m_upperSize;
    private boolean m_hasUpperSize;

    public FormSizeInfo(Size size, boolean horizontal) throws Exception {
        this.m_horizontal = horizontal;
        Class<?> sizeClass = size.getClass();
        String sizeClassName = sizeClass.getName();
        if (sizeClassName.equals("com.jgoodies.forms.layout.ConstantSize")) {
            this.m_constantSize = FormSizeInfo.createConstant(size);
        } else if (sizeClassName.equals("com.jgoodies.forms.layout.Sizes$ComponentSize")) {
            this.m_componentSize = size;
        } else {
            Assert.isTrue((boolean)sizeClassName.equals("com.jgoodies.forms.layout.BoundedSize"));
            Size basic = (Size)ReflectionUtils.getFieldObject((Object)size, (String)"basis");
            Assert.isTrue((basic == Sizes.DEFAULT || basic == Sizes.MINIMUM || basic == Sizes.PREFERRED ? 1 : 0) != 0);
            this.m_componentSize = basic;
            Size lower = (Size)ReflectionUtils.getFieldObject((Object)size, (String)"lowerBound");
            this.setLowerSize(FormSizeInfo.createConstant(lower));
            Size upper = (Size)ReflectionUtils.getFieldObject((Object)size, (String)"upperBound");
            this.setUpperSize(FormSizeInfo.createConstant(upper));
        }
    }

    private static FormSizeConstantInfo createConstant(Size size) throws Exception {
        if (size != null) {
            Assert.instanceOf(ConstantSize.class, (Object)size);
            double value = ReflectionUtils.getFieldDouble((Object)size, (String)"value");
            ConstantSize.Unit unit = (ConstantSize.Unit)ReflectionUtils.getFieldObject((Object)size, (String)"unit");
            return new FormSizeConstantInfo(value, unit);
        }
        return null;
    }

    public String toString() {
        return this.getDisplayString();
    }

    public String getDisplayString() {
        Object size;
        if (this.m_componentSize == null) {
            return this.m_constantSize.getSource(true, this.m_horizontal);
        }
        if (this.m_componentSize == Sizes.DEFAULT) {
            size = "default";
        } else if (this.m_componentSize == Sizes.PREFERRED) {
            size = "preferred";
        } else {
            Assert.isTrue((this.m_componentSize == Sizes.MINIMUM ? 1 : 0) != 0);
            size = "minimum";
        }
        if (this.m_hasLowerSize) {
            size = this.m_lowerSize.getSource(true, this.m_horizontal) + "<" + (String)size;
        }
        if (this.m_hasUpperSize) {
            size = (String)size + "<" + this.m_upperSize.getSource(true, this.m_horizontal);
        }
        return size;
    }

    public boolean isString() {
        return !this.m_hasLowerSize || !this.m_hasUpperSize;
    }

    public String getSource() {
        if (this.isString()) {
            Object size;
            if (this.m_componentSize == null) {
                return this.m_constantSize.getSource(true, this.m_horizontal);
            }
            if (this.m_componentSize == Sizes.DEFAULT) {
                size = "default";
            } else if (this.m_componentSize == Sizes.PREFERRED) {
                size = "pref";
            } else {
                Assert.isTrue((this.m_componentSize == Sizes.MINIMUM ? 1 : 0) != 0);
                size = "min";
            }
            if (this.m_hasLowerSize) {
                size = "max(" + this.m_lowerSize.getSource(true, this.m_horizontal) + ";" + (String)size + ")";
            }
            if (this.m_hasUpperSize) {
                size = "min(" + this.m_upperSize.getSource(true, this.m_horizontal) + ";" + (String)size + ")";
            }
            return size;
        }
        Assert.isTrue((!this.isString() ? 1 : 0) != 0);
        Object source = "com.jgoodies.forms.layout.Sizes.bounded(";
        if (this.m_componentSize == Sizes.DEFAULT) {
            source = (String)source + "com.jgoodies.forms.layout.Sizes.DEFAULT";
        } else if (this.m_componentSize == Sizes.PREFERRED) {
            source = (String)source + "com.jgoodies.forms.layout.Sizes.PREFERRED";
        } else {
            Assert.isTrue((this.m_componentSize == Sizes.MINIMUM ? 1 : 0) != 0);
            source = (String)source + "com.jgoodies.forms.layout.Sizes.MINIMUM";
        }
        source = (String)source + ", ";
        source = (String)source + this.m_lowerSize.getSource(false, this.m_horizontal);
        source = (String)source + ", ";
        source = (String)source + this.m_upperSize.getSource(false, this.m_horizontal);
        source = (String)source + ")";
        return source;
    }

    public Size getSize() {
        if (this.m_componentSize == null) {
            return this.m_constantSize.getSize(this.m_horizontal);
        }
        Size size = this.m_componentSize;
        if (this.m_hasLowerSize && this.m_hasUpperSize) {
            return Sizes.bounded((Size)size, (Size)this.m_lowerSize.getSize(this.m_horizontal), (Size)this.m_upperSize.getSize(this.m_horizontal));
        }
        if (this.m_hasLowerSize) {
            return Sizes.bounded((Size)size, (Size)this.m_lowerSize.getSize(this.m_horizontal), null);
        }
        if (this.m_hasUpperSize) {
            return Sizes.bounded((Size)size, null, (Size)this.m_upperSize.getSize(this.m_horizontal));
        }
        return size;
    }

    public Size getComponentSize() {
        return this.m_componentSize;
    }

    public void setComponentSize(Size componentSize) {
        this.m_componentSize = componentSize;
    }

    public FormSizeConstantInfo getConstantSize() {
        return this.m_constantSize;
    }

    public void setConstantSize(FormSizeConstantInfo constantSize) {
        this.m_constantSize = constantSize;
        if (this.m_constantSize != null) {
            this.m_componentSize = null;
        }
    }

    public boolean hasLowerSize() {
        return this.m_hasLowerSize;
    }

    public void setLowerSize(boolean hasLowerSize) {
        this.m_hasLowerSize = hasLowerSize;
    }

    public FormSizeConstantInfo getLowerSize() {
        return this.m_lowerSize;
    }

    public void setLowerSize(FormSizeConstantInfo lowerSize) {
        this.m_lowerSize = lowerSize;
        this.m_hasLowerSize = this.m_lowerSize != null;
    }

    public boolean hasUpperSize() {
        return this.m_hasUpperSize;
    }

    public void setUpperSize(boolean hasUpperSize) {
        this.m_hasUpperSize = hasUpperSize;
    }

    public FormSizeConstantInfo getUpperSize() {
        return this.m_upperSize;
    }

    public void setUpperSize(FormSizeConstantInfo upperSize) {
        this.m_upperSize = upperSize;
        this.m_hasUpperSize = this.m_upperSize != null;
    }
}

