/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.session;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.business.api.session.ReloadingPolicy;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.business.internal.session.ReloadingPolicyImpl;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.tools.api.command.ui.RefreshFilter;
import org.eclipse.sirius.tools.api.command.ui.RefreshFilterManager;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.editor.ISiriusEditor;
import org.eclipse.sirius.ui.business.api.session.EditingSessionEvent;
import org.eclipse.sirius.ui.business.api.session.EditorNameAdapter;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.ui.business.internal.dialect.editor.DialectEditorCloser;
import org.eclipse.sirius.ui.business.internal.session.RestoreToLastSavePointListener;
import org.eclipse.sirius.ui.business.internal.session.SaveSessionWhenNoDialectEditorsListener;
import org.eclipse.sirius.ui.business.internal.session.SessionSaveable;
import org.eclipse.sirius.ui.tools.internal.util.SessionCallBackWithUI;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.part.FileEditorInput;

public class EditingSession
implements IEditingSession,
ISaveablesSource,
RefreshFilter {
    protected Saveable saveable;
    private final List<ISiriusEditor> editors = new ArrayList<ISiriusEditor>();
    private Map<ISiriusEditor, DialectEditorCloser> dialectEditorClosers = new HashMap<ISiriusEditor, DialectEditorCloser>();
    private NeedSaveOnCloseDetector needSaveOnCloseDetec = new NeedSaveOnCloseDetector();
    private boolean opened;
    private final Session session;
    private EditorNameAdapter editorNameAdapter;
    private RestoreToLastSavePointListener restoreToSavePointListener;
    private SaveSessionWhenNoDialectEditorsListener saveSessionListener;

    public EditingSession(Session session) {
        this.session = session;
        this.saveable = new SessionSaveable(session);
        this.editorNameAdapter = new EditorNameAdapter(this);
        session.setReloadingPolicy((ReloadingPolicy)new ReloadingPolicyImpl((UICallBack)new SessionCallBackWithUI()));
    }

    private void initListeners() {
        this.restoreToSavePointListener = new RestoreToLastSavePointListener(this.session);
        this.saveSessionListener = this.createSaveSessionWhenNoDialectEditorsListener(this.session);
        this.saveSessionListener.register();
    }

    protected SaveSessionWhenNoDialectEditorsListener createSaveSessionWhenNoDialectEditorsListener(Session theSession) {
        return new SaveSessionWhenNoDialectEditorsListener(this.session);
    }

    private void removeListeners() {
        if (this.restoreToSavePointListener != null) {
            this.restoreToSavePointListener.dispose();
            this.restoreToSavePointListener = null;
        }
        if (this.saveSessionListener != null) {
            this.saveSessionListener.unregister();
            this.saveSessionListener = null;
        }
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Collection<DialectEditor> getEditors() {
        return this.getSiriusEditors().stream().filter(editor -> editor instanceof DialectEditor).map(editor -> (DialectEditor)editor).collect(Collectors.toSet());
    }

    @Override
    public void attachEditor(ISiriusEditor siriusEditor) {
        if (!this.editors.contains(siriusEditor) && siriusEditor != null) {
            this.editors.add(siriusEditor);
            this.needSaveOnCloseDetec.reInit();
            this.reorderEditorsIfNeeded(siriusEditor);
            if (siriusEditor instanceof DialectEditor) {
                DialectEditor dialectEditor = (DialectEditor)siriusEditor;
                this.editorNameAdapter.registerEditor(dialectEditor);
                if (dialectEditor.getRepresentation() != null) {
                    this.dialectEditorClosers.put(dialectEditor, new DialectEditorCloser(this, dialectEditor));
                }
            }
        }
    }

    private void reorderEditorsIfNeeded(ISiriusEditor justAddedEditor) {
        ArrayList<ISiriusEditor> reorderedList = new ArrayList<ISiriusEditor>();
        IEditorReference[] editorReferences = null;
        IWorkbenchPage page = EclipseUIUtil.getActivePage();
        if (page != null) {
            editorReferences = page.getEditorReferences();
        }
        if (editorReferences != null) {
            for (IEditorReference ref : Arrays.asList(editorReferences)) {
                IEditorPart editor2 = ref.getEditor(false);
                IEditorInput refInput = null;
                try {
                    refInput = ref.getEditorInput();
                }
                catch (PartInitException partInitException) {}
                if (editor2 == null && justAddedEditor.getEditorInput() == refInput) {
                    reorderedList.add(justAddedEditor);
                    continue;
                }
                if (!this.editors.contains(editor2)) continue;
                reorderedList.add((ISiriusEditor)editor2);
            }
            if (this.editors.size() == reorderedList.size() && !Iterables.elementsEqual(this.editors, reorderedList)) {
                this.editors.clear();
                this.editors.addAll(reorderedList);
            }
        }
    }

    @Override
    public void detachEditor(ISiriusEditor dialectEditor) {
        if (dialectEditor instanceof DialectEditor) {
            this.editorNameAdapter.unregisterEditor((DialectEditor)dialectEditor);
        }
        this.editors.remove(dialectEditor);
        this.needSaveOnCloseDetec.reInit();
        DialectEditorCloser dialectEditorCloser = this.dialectEditorClosers.remove(dialectEditor);
        if (dialectEditorCloser != null) {
            dialectEditorCloser.dispose();
        }
    }

    @Override
    public void detachEditor(ISiriusEditor dialectEditor, boolean revertChanges) {
        boolean returnToSyncState = revertChanges && (this.getSiriusEditors().size() == 1 || this.closeAllDetected());
        this.detachEditor(dialectEditor);
        if (returnToSyncState) {
            this.restoreToSavePointListener.returnToSyncState();
        }
    }

    @Override
    public void closeEditors(boolean save, Collection<? extends ISiriusEditor> editorParts) {
        for (ISiriusEditor iSiriusEditor : new ArrayList<ISiriusEditor>(editorParts)) {
            this.closeEditor(iSiriusEditor, save);
        }
    }

    @Override
    public void closeEditors(boolean save, ISiriusEditor ... editorParts) {
        this.closeEditors(save, Arrays.asList(editorParts));
    }

    private void closeEditor(ISiriusEditor editor, boolean save) {
        if (editor instanceof DialectEditor && DialectUIManager.INSTANCE.canHandleEditor(editor)) {
            try {
                try {
                    this.detachEditor(editor);
                }
                catch (IllegalStateException e) {
                    SiriusEditPlugin.getPlugin().log(e);
                    DialectUIManager.INSTANCE.closeEditor(editor, save);
                }
            }
            finally {
                DialectUIManager.INSTANCE.closeEditor(editor, save);
            }
        } else if (!(editor instanceof DialectEditor)) {
            this.detachEditor(editor);
        } else {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)editor, save);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.editors.size() == 0;
    }

    @Override
    public boolean isLastOpenedEditor() {
        return this.editors.size() == 1;
    }

    @Override
    public boolean needToBeSavedOnClose(IEditorPart editor) {
        return this.needSaveOnCloseDetec.needToBeSavedOnClose(editor);
    }

    @Override
    public int promptToSaveOnClose() {
        int choice = 3;
        if (this.saveable != null && this.restoreToSavePointListener != null) {
            boolean stillOpenElsewhere = this.getSiriusEditors().size() > 1 && !this.closeAllDetected();
            boolean promptStandardDialog = !this.restoreToSavePointListener.isAllowedToReturnToSyncState();
            choice = SWTUtil.showSaveDialog((Object)this.session, (String)this.saveable.getName(), (boolean)true, (boolean)stillOpenElsewhere, (boolean)promptStandardDialog);
            if (choice == 2) {
                this.needSaveOnCloseDetec.reInit();
            }
        }
        return choice;
    }

    private boolean closeAllDetected() {
        return this.needSaveOnCloseDetec.closeAllDetected();
    }

    @Override
    public void close() {
        if (this.opened) {
            this.close(true);
        }
    }

    @Override
    public void close(boolean save) {
        if (this.opened) {
            if (!this.isEmpty()) {
                this.closeEditors(save, this.editors);
            }
            RefreshFilterManager.INSTANCE.removeRefreshFilter((RefreshFilter)this);
            this.removeListeners();
            this.opened = false;
        }
        this.closeOthersEditors(save);
    }

    private void closeOthersEditors(boolean save) {
        CloseOthersEditorsRunnable closeOthersEditorsRunnable = new CloseOthersEditorsRunnable(save);
        if (Display.getDefault().getThread() == Thread.currentThread()) {
            closeOthersEditorsRunnable.run();
        } else {
            Display.getDefault().asyncExec((Runnable)closeOthersEditorsRunnable);
        }
    }

    @Override
    public void open() {
        if (!this.opened) {
            RefreshFilterManager.INSTANCE.addRefreshFilter((RefreshFilter)this);
            this.initListeners();
            this.opened = true;
        }
    }

    @Override
    public boolean isOpen() {
        return this.opened;
    }

    @Override
    public boolean isSessionFor(IEditorInput editorInput) {
        boolean result = false;
        String key = this.keyFromInput(editorInput);
        if (key != null) {
            for (IEditorPart iEditorPart : this.editors) {
                if (!key.equals(this.keyFromInput(iEditorPart.getEditorInput()))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private String keyFromInput(IEditorInput input) {
        Object uri;
        String result = null;
        if (input instanceof URIEditorInput) {
            uri = ((URIEditorInput)input).getURI();
            URI deresolved = uri.deresolve(URI.createURI((String)"platform:/resource/"));
            String workspacePAth = "/" + deresolved.path();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePAth));
            if (file != null && file.isAccessible() && file.exists()) {
                String filePath = file.getLocation().toString();
                if (filePath.startsWith("/")) {
                    filePath = filePath.substring(1);
                }
                result = filePath;
            }
            if (result == null) {
                String path = uri.path();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                result = path;
            }
        }
        if (result == null && input instanceof IPathEditorInput) {
            result = ((IPathEditorInput)input).getPath().toString();
        }
        if (result == null && input instanceof FileEditorInput) {
            uri = ((FileEditorInput)input).getURI();
            String path = ((java.net.URI)uri).getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            result = path;
        }
        if (result == null) {
            result = input.toString();
        }
        return result;
    }

    @Override
    public DialectEditor getEditor(DRepresentation representation) {
        if (representation != null) {
            for (ISiriusEditor editorPart : this.editors) {
                if (!(editorPart instanceof DialectEditor) || !DialectUIManager.INSTANCE.isRepresentationManagedByEditor(representation, editorPart)) continue;
                return (DialectEditor)editorPart;
            }
        }
        return null;
    }

    @Override
    public boolean handleEditor(IEditorPart editor) {
        return this.editors.contains(editor);
    }

    public Collection<DRepresentation> getOpenedRepresantationsToRefresh() {
        ArrayList<DRepresentation> openedRepresantationsToRefresh = new ArrayList<DRepresentation>();
        for (DialectEditor dialectEditor : this.getEditors()) {
            DRepresentation dRepresentation = dialectEditor.getRepresentation();
            if (dRepresentation == null) continue;
            openedRepresantationsToRefresh.add(dRepresentation);
        }
        return openedRepresantationsToRefresh;
    }

    public boolean shouldRefresh(DRepresentation representation) {
        return this.getOpenedRepresantationsToRefresh().contains(representation);
    }

    public Saveable[] getSaveables() {
        Saveable[] saveableArray;
        if (this.saveable != null) {
            Saveable[] saveableArray2 = new Saveable[1];
            saveableArray = saveableArray2;
            saveableArray2[0] = this.saveable;
        } else {
            saveableArray = new Saveable[]{};
        }
        return saveableArray;
    }

    public Saveable[] getActiveSaveables() {
        return this.getSaveables();
    }

    @Override
    public void notify(EditingSessionEvent event) {
        this.saveSessionListener.notify(event);
    }

    @Override
    public Collection<ISiriusEditor> getSiriusEditors() {
        return Collections.unmodifiableList(this.editors);
    }

    private final class CloseOthersEditorsRunnable
    implements Runnable {
        private final boolean save;

        private CloseOthersEditorsRunnable(boolean save) {
            this.save = save;
        }

        @Override
        public void run() {
            IWorkbenchPage page = EclipseUIUtil.getActivePage();
            if (page != null) {
                IEditorReference[] editorReferences = page.getEditorReferences();
                ArrayList<IEditorReference> editorsToClose = new ArrayList<IEditorReference>();
                IEditorReference[] iEditorReferenceArray = editorReferences;
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editor = iEditorReferenceArray[n2];
                    try {
                        IEditorInput input = editor.getEditorInput();
                        IEditorPart editorPart = editor.getEditor(false);
                        if (this.isEditorAdaptableToSession(input)) {
                            editorsToClose.add(editor);
                        } else if (editorPart == null && input instanceof URIEditorInput && this.isInputAssociatedToClosingSession((URIEditorInput)input)) {
                            editorsToClose.add(editor);
                        }
                    }
                    catch (PartInitException partInitException) {}
                    ++n2;
                }
                if (!editorsToClose.isEmpty()) {
                    IEditorReference[] toClose = editorsToClose.toArray(new IEditorReference[editorsToClose.size()]);
                    page.closeEditors(toClose, this.save);
                }
            }
        }

        private boolean isEditorAdaptableToSession(IEditorInput input) {
            if (input != null) {
                Session adaptedSession = (Session)input.getAdapter(Session.class);
                return EditingSession.this.session == adaptedSession;
            }
            return false;
        }

        private boolean isInputAssociatedToClosingSession(URIEditorInput input) {
            boolean isInputAssociatedToClosingSession = false;
            if (input instanceof SessionEditorInput) {
                isInputAssociatedToClosingSession = ((SessionEditorInput)input).getSession(false) == EditingSession.this.session;
            } else if (EditingSession.this.session instanceof DAnalysisSession) {
                isInputAssociatedToClosingSession = Stream.concat(EditingSession.this.session.getAllSessionResources().stream(), EditingSession.this.session.getSrmResources().stream()).filter(resource -> resource.getURI() != null && resource.getURI().equals(input.getURI().trimFragment())).findFirst().isPresent();
            }
            return isInputAssociatedToClosingSession;
        }
    }

    private final class NeedSaveOnCloseDetector {
        private Set<IEditorPart> closingEditors = new HashSet<IEditorPart>();

        private NeedSaveOnCloseDetector() {
        }

        public boolean needToBeSavedOnClose(IEditorPart editor) {
            boolean needToBeSavedOnClose = EditingSession.this.isLastOpenedEditor();
            if (!needToBeSavedOnClose) {
                IPreferenceStore platformUIPrefStore = PlatformUI.getPreferenceStore();
                boolean closeAll = this.checkCloseAllEditor(editor);
                needToBeSavedOnClose = platformUIPrefStore.getBoolean("PROMPT_WHEN_SAVEABLE_STILL_OPEN") || closeAll;
            }
            return needToBeSavedOnClose;
        }

        public boolean closeAllDetected() {
            return !this.closingEditors.isEmpty() && this.closingEditors.size() == EditingSession.this.editors.size();
        }

        private boolean checkCloseAllEditor(IEditorPart editor) {
            if (EditingSession.this.editors.indexOf(editor) == 0) {
                this.reInit();
                this.closingEditors.add(editor);
            } else if (this.closingEditors.size() > 0) {
                this.closingEditors.add(editor);
            }
            return this.closeAllDetected();
        }

        public void reInit() {
            this.closingEditors.clear();
            this.closingEditors = new HashSet<IEditorPart>();
        }
    }
}

