/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.draw2d.figure;

import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transform;

public class CirclePlusDecoration
extends Ellipse
implements RotatableDecoration {
    private static final int RADIUS = 10;
    private Point location = new Point();
    private Transform transform = new Transform();
    private Point ovalCenter;
    private Dimension ovalSize;
    private double xScale = 1.0;
    private double yScale = 1.0;

    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.updatePoints();
            this.bounds = new Rectangle(this.location, new Dimension(0, 0));
            Point p = Point.SINGLETON;
            p.setLocation(this.ovalCenter);
            p.x += this.ovalSize.width / 2;
            p.y += this.ovalSize.height / 2;
            this.bounds.union(p);
            p.x -= this.ovalSize.width + 1;
            p.y -= this.ovalSize.height + 1;
            this.bounds.union(p);
            this.bounds.expand(this.getLineWidth() / 2, this.getLineWidth() / 2);
        }
        return this.bounds;
    }

    public void setScale(double x, double y) {
        this.ovalCenter = null;
        this.ovalSize = null;
        this.bounds = null;
        this.transform.setScale(x, y);
        this.xScale = x;
        this.yScale = y;
    }

    public void setLocation(Point p) {
        this.ovalCenter = null;
        this.ovalSize = null;
        this.bounds = null;
        this.location.setLocation(p);
        this.transform.setTranslation((double)p.x, (double)p.y);
        super.setLocation(p);
    }

    public void setReferencePoint(Point p) {
        this.ovalCenter = null;
        this.ovalSize = null;
        this.bounds = null;
        Point pt = Point.SINGLETON;
        pt.setLocation(p);
        pt.negate().translate(this.location);
        this.setRotation(Math.atan2(pt.y, pt.x));
    }

    public void setRotation(double angle) {
        this.ovalCenter = null;
        this.ovalSize = null;
        this.bounds = null;
        this.transform.setRotation(angle);
    }

    protected void updatePoints() {
        if (this.ovalSize == null) {
            this.ovalSize = new Dimension((int)this.xScale * 10 * 2, (int)this.yScale * 10 * 2);
        }
        if (this.ovalCenter == null) {
            this.ovalCenter = new Point(this.transform.getTransformed(new Point((int)(-this.xScale) * 10, 0)));
        }
    }

    public void paintFigure(Graphics graphics) {
        this.updatePoints();
        graphics.pushState();
        int oldLineWidth = graphics.getLineWidth();
        graphics.setLineWidth(this.getLineWidth());
        graphics.fillOval(this.ovalCenter.x - this.ovalSize.width / 2, this.ovalCenter.y - this.ovalSize.height / 2, this.ovalSize.width, this.ovalSize.height);
        graphics.drawLine(this.ovalCenter.x - this.ovalSize.width / 2, this.ovalCenter.y, this.ovalCenter.x + this.ovalSize.width / 2, this.ovalCenter.y);
        graphics.drawLine(this.ovalCenter.x, this.ovalCenter.y - this.ovalSize.width / 2, this.ovalCenter.x, this.ovalCenter.y + this.ovalSize.width / 2);
        graphics.setLineWidth(oldLineWidth);
        graphics.popState();
    }

    protected void paintBorder(Graphics graphics) {
        this.updatePoints();
        graphics.pushState();
        int oldLineWidth = graphics.getLineWidth();
        graphics.setLineWidth(this.getLineWidth());
        graphics.drawOval(this.ovalCenter.x - this.ovalSize.width / 2, this.ovalCenter.y - this.ovalSize.height / 2, this.ovalSize.width, this.ovalSize.height);
        graphics.setLineWidth(oldLineWidth);
        graphics.popState();
    }
}

