/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.messages;

import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemRemoteMessageException;

public class SystemOperationFailedException
extends SystemRemoteMessageException {
    private static final long serialVersionUID = 1L;

    public SystemOperationFailedException(Exception remoteException) {
        super(SystemOperationFailedException.getMyMessage("org.eclipse.rse.services", null, remoteException), remoteException);
    }

    public SystemOperationFailedException(String pluginId, String msg) {
        super(SystemOperationFailedException.getMyMessage(pluginId, msg, null), null);
    }

    public SystemOperationFailedException(String pluginId, Exception remoteException) {
        super(SystemOperationFailedException.getMyMessage(pluginId, null, remoteException), remoteException);
    }

    public SystemOperationFailedException(String pluginId, String userMessage, Exception remoteException) {
        super(SystemOperationFailedException.getMyMessage(pluginId, userMessage, remoteException), remoteException);
    }

    private static SystemMessage getMyMessage(String pluginId, String userMessage, Exception remoteException) {
        String msgTxt;
        String exceptionMessage = null;
        String secondLevel = null;
        if (remoteException != null) {
            Throwable cause;
            exceptionMessage = remoteException.getMessage();
            if (exceptionMessage == null) {
                exceptionMessage = remoteException.getClass().getName();
            }
            if ((cause = remoteException.getCause()) != null && (secondLevel = cause.getMessage()) == null && (secondLevel = cause.getClass().getName()).equals(exceptionMessage)) {
                secondLevel = null;
            }
        }
        if ((msgTxt = userMessage) == null) {
            msgTxt = NLS.bind((String)CommonMessages.MSG_OPERATION_FAILED, (Object)exceptionMessage);
        } else if (secondLevel == null) {
            secondLevel = exceptionMessage;
        } else {
            msgTxt = NLS.bind((String)CommonMessages.MSG_FAILURE_WITH_CAUSE, (Object)userMessage, (Object)exceptionMessage);
        }
        SimpleSystemMessage msg = new SimpleSystemMessage(pluginId, "RSEG1066", 4, msgTxt, secondLevel);
        return msg;
    }
}

