/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.security.widgets;

import com.ibm.icu.text.DateFormat;
import java.security.Key;
import java.security.cert.X509Certificate;
import org.eclipse.rse.internal.dstore.security.UniversalSecurityProperties;
import org.eclipse.rse.internal.dstore.security.util.GridUtil;
import org.eclipse.rse.internal.dstore.security.util.StringModifier;
import org.eclipse.rse.ui.SystemBaseForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CertificatePropertiesForm
extends SystemBaseForm {
    private Object _certificate;
    private String _alias;
    private boolean _advanced;

    public CertificatePropertiesForm(Shell shell, Object certificate, String alias) {
        this(shell, certificate, alias, false);
    }

    public CertificatePropertiesForm(Shell shell, Object certificate) {
        this(shell, certificate, false);
    }

    public CertificatePropertiesForm(Shell shell, Object certificate, String alias, boolean advanced) {
        super(shell, null);
        this._certificate = certificate;
        this._alias = alias;
        this._advanced = advanced;
    }

    public CertificatePropertiesForm(Shell shell, Object certificate, boolean advanced) {
        this(shell, certificate, null, advanced);
    }

    public Control createContents(Composite parent) {
        if (this._advanced) {
            return this.createAdvancedContents(parent);
        }
        return this.createSimpleContents(parent);
    }

    public Control createSimpleContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData data = GridUtil.createFill();
        data.widthHint = 450;
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)data);
        if (this._alias != null) {
            Label lblAlias = new Label(content, 0);
            lblAlias.setText(UniversalSecurityProperties.RESID_SECURITY_PROP_ALIAS_LBL);
            data = new GridData();
            data.horizontalIndent = 5;
            lblAlias.setLayoutData((Object)data);
            Label lblAliasValue = new Label(content, 0);
            lblAliasValue.setText(this._alias);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblAliasValue.setLayoutData((Object)data);
        }
        Label lblVersion = new Label(content, 0);
        lblVersion.setText(UniversalSecurityProperties.RESID_SECURITY_CERTIF_VERSION_LBL);
        data = new GridData();
        data.horizontalIndent = 5;
        lblVersion.setLayoutData((Object)data);
        Label lblVersionValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblVersionValue.setLayoutData((Object)data);
        Label lblIssuedTo = new Label(content, 0);
        lblIssuedTo.setText(UniversalSecurityProperties.RESID_SECURITY_ISSUED_TO_LBL);
        data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalIndent = 5;
        lblIssuedTo.setLayoutData((Object)data);
        Text lblIssuedToValue = new Text(content, 2120);
        data = new GridData(768);
        data.heightHint = 60;
        data.horizontalIndent = 5;
        lblIssuedToValue.setLayoutData((Object)data);
        Label lblIssuedBy = new Label(content, 0);
        lblIssuedBy.setText(UniversalSecurityProperties.RESID_SECURITY_ISSUED_BY_LBL);
        data = new GridData();
        data.horizontalIndent = 5;
        data.verticalAlignment = 1;
        lblIssuedBy.setLayoutData((Object)data);
        Text lblIssuedByValue = new Text(content, 2120);
        data = new GridData(768);
        data.horizontalIndent = 5;
        data.heightHint = 60;
        lblIssuedByValue.setLayoutData((Object)data);
        Label lblValidity = new Label(content, 0);
        lblValidity.setText(UniversalSecurityProperties.RESID_SECURITY_VALIDITY_LBL);
        data = new GridData();
        data.horizontalIndent = 5;
        lblValidity.setLayoutData((Object)data);
        Label lblValidityValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblValidityValue.setLayoutData((Object)data);
        Label lblAlgorithm = new Label(content, 0);
        lblAlgorithm.setText(UniversalSecurityProperties.RESID_SECURITY_ALGORITHM_LBL);
        data = new GridData();
        data.horizontalIndent = 5;
        lblAlgorithm.setLayoutData((Object)data);
        Label lblAlgorithmValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblAlgorithmValue.setLayoutData((Object)data);
        if (this._certificate instanceof X509Certificate) {
            lblVersionValue.setText(String.valueOf(((X509Certificate)this._certificate).getType()) + " V." + ((X509Certificate)this._certificate).getVersion());
            lblIssuedToValue.setText(((X509Certificate)this._certificate).getSubjectDN().getName());
            lblIssuedByValue.setText(((X509Certificate)this._certificate).getIssuerDN().getName());
            DateFormat df = DateFormat.getDateInstance((int)1);
            String validity = UniversalSecurityProperties.RESID_SECURITY_VALIDITY_PERIOD;
            validity = StringModifier.change(validity, "%1", df.format(((X509Certificate)this._certificate).getNotBefore()));
            validity = StringModifier.change(validity, "%2", df.format(((X509Certificate)this._certificate).getNotAfter()));
            lblValidityValue.setText(validity);
            lblAlgorithmValue.setText(((X509Certificate)this._certificate).getSigAlgName());
        } else if (this._certificate instanceof Key) {
            lblVersionValue.setText(((Key)this._certificate).getFormat());
            lblAlgorithmValue.setText(((Key)this._certificate).getAlgorithm());
        }
        return content;
    }

    public Control createAdvancedContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData data = GridUtil.createFill();
        data.widthHint = 600;
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)data);
        if (this._alias != null) {
            Label lblAlias = new Label(content, 0);
            lblAlias.setText(UniversalSecurityProperties.RESID_SECURITY_PROP_ALIAS_LBL);
            data = new GridData();
            data.horizontalIndent = 5;
            lblAlias.setLayoutData((Object)data);
            Label lblAliasValue = new Label(content, 0);
            lblAliasValue.setText(this._alias);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblAliasValue.setLayoutData((Object)data);
        }
        Label lblVersion = new Label(content, 0);
        lblVersion.setText(UniversalSecurityProperties.RESID_SECURITY_CERTIF_VERSION_LBL);
        data = new GridData();
        data.horizontalIndent = 5;
        lblVersion.setLayoutData((Object)data);
        Label lblVersionValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblVersionValue.setLayoutData((Object)data);
        Label lblIssuedTo = new Label(content, 0);
        lblIssuedTo.setText(UniversalSecurityProperties.RESID_SECURITY_ISSUED_TO_LBL);
        data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalIndent = 5;
        lblIssuedTo.setLayoutData((Object)data);
        Text lblIssuedToValue = new Text(content, 2120);
        data = new GridData(768);
        data.heightHint = 60;
        data.horizontalIndent = 5;
        lblIssuedToValue.setLayoutData((Object)data);
        Label lblIssuedBy = new Label(content, 0);
        lblIssuedBy.setText(UniversalSecurityProperties.RESID_SECURITY_ISSUED_BY_LBL);
        data = new GridData();
        data.horizontalIndent = 5;
        data.verticalAlignment = 1;
        lblIssuedBy.setLayoutData((Object)data);
        Text lblIssuedByValue = new Text(content, 2120);
        data = new GridData(768);
        data.horizontalIndent = 5;
        data.heightHint = 60;
        lblIssuedByValue.setLayoutData((Object)data);
        Label lblValidity = new Label(content, 0);
        lblValidity.setText(UniversalSecurityProperties.RESID_SECURITY_VALIDITY_LBL);
        data = new GridData();
        data.horizontalIndent = 5;
        lblValidity.setLayoutData((Object)data);
        Label lblValidityValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblValidityValue.setLayoutData((Object)data);
        Label lblAlgorithm = new Label(content, 0);
        lblAlgorithm.setText(UniversalSecurityProperties.RESID_SECURITY_ALGORITHM_LBL);
        data = new GridData();
        data.horizontalIndent = 5;
        lblAlgorithm.setLayoutData((Object)data);
        Label lblAlgorithmValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblAlgorithmValue.setLayoutData((Object)data);
        if (this._certificate instanceof X509Certificate) {
            lblVersionValue.setText(String.valueOf(((X509Certificate)this._certificate).getType()) + " V." + ((X509Certificate)this._certificate).getVersion());
            lblIssuedToValue.setText(((X509Certificate)this._certificate).getSubjectDN().getName());
            lblIssuedByValue.setText(((X509Certificate)this._certificate).getIssuerDN().getName());
            DateFormat df = DateFormat.getDateInstance((int)1);
            String validity = UniversalSecurityProperties.RESID_SECURITY_VALIDITY_PERIOD;
            validity = StringModifier.change(validity, "%1", df.format(((X509Certificate)this._certificate).getNotBefore()));
            validity = StringModifier.change(validity, "%2", df.format(((X509Certificate)this._certificate).getNotAfter()));
            lblValidityValue.setText(validity);
            lblAlgorithmValue.setText(((X509Certificate)this._certificate).getSigAlgName());
        } else if (this._certificate instanceof Key) {
            lblVersionValue.setText(((Key)this._certificate).getFormat());
            lblAlgorithmValue.setText(((Key)this._certificate).getAlgorithm());
        }
        return content;
    }
}

