/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBNamedElement;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.ddl.IDBSchemaVisitor;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.db.ddl.SchemaElementNotFoundException;
import org.eclipse.net4j.internal.db.ddl.DBField;
import org.eclipse.net4j.internal.db.ddl.DBIndex;
import org.eclipse.net4j.internal.db.ddl.DBSchemaElement;
import org.eclipse.net4j.spi.db.ddl.InternalDBField;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchema;
import org.eclipse.net4j.spi.db.ddl.InternalDBTable;

public class DBTable
extends DBSchemaElement
implements InternalDBTable {
    private static final long serialVersionUID = 1L;
    private IDBSchema schema;
    private List<IDBField> fields = new ArrayList<IDBField>();
    private List<IDBIndex> indices = new ArrayList<IDBIndex>();

    public DBTable(IDBSchema schema, String name) {
        super(name);
        this.schema = schema;
    }

    protected DBTable() {
    }

    @Override
    public IDBTable getWrapper() {
        return (IDBTable)super.getWrapper();
    }

    @Override
    public IDBSchemaElement.SchemaElementType getSchemaElementType() {
        return IDBSchemaElement.SchemaElementType.TABLE;
    }

    @Override
    public IDBSchema getSchema() {
        return this.schema;
    }

    @Override
    public IDBSchema getParent() {
        return this.getSchema();
    }

    @Override
    public IDBField addField(String name, DBType type) {
        return this.addField(name, type, -1, -1, false);
    }

    @Override
    public IDBField addField(String name, DBType type, boolean notNull) {
        return this.addField(name, type, -1, -1, notNull);
    }

    @Override
    public IDBField addField(String name, DBType type, int precision) {
        return this.addField(name, type, precision, -1, false);
    }

    @Override
    public IDBField addField(String name, DBType type, int precision, boolean notNull) {
        return this.addField(name, type, precision, -1, notNull);
    }

    @Override
    public IDBField addField(String name, DBType type, int precision, int scale) {
        return this.addField(name, type, precision, scale, false);
    }

    @Override
    public IDBField addField(String name, DBType type, int precision, int scale, boolean notNull) {
        this.assertUnlocked();
        if (this.getField(name) != null) {
            throw new DBException("Field exists: " + name);
        }
        int position = this.fields.size();
        DBField field = new DBField(this, name, type, precision, scale, notNull, position);
        this.fields.add(field);
        this.resetElements();
        return field;
    }

    @Override
    public void removeField(IDBField fieldToRemove) {
        this.assertUnlocked();
        boolean found = false;
        Iterator<IDBField> it = this.fields.iterator();
        while (it.hasNext()) {
            IDBField field = it.next();
            if (found) {
                ((InternalDBField)field).setPosition(field.getPosition() - 1);
                continue;
            }
            if (field != fieldToRemove) continue;
            it.remove();
            found = true;
        }
        this.resetElements();
    }

    @Override
    public IDBField getFieldSafe(String name) throws SchemaElementNotFoundException {
        IDBField field = this.getField(name);
        if (field == null) {
            throw new SchemaElementNotFoundException(this, IDBSchemaElement.SchemaElementType.FIELD, name);
        }
        return field;
    }

    @Override
    public IDBField getField(String name) {
        InternalDBSchema schema = (InternalDBSchema)this.getSchema();
        IDBNamedElement[] fields = this.getFields();
        return (IDBField)DBTable.findElement((InternalDBSchema)schema, (IDBNamedElement[])fields, (String)name);
    }

    @Override
    public IDBField getField(int position) {
        return this.fields.get(position);
    }

    @Override
    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public IDBField[] getFields() {
        return this.fields.toArray(new IDBField[this.fields.size()]);
    }

    @Override
    public IDBField[] getFields(String ... fieldNames) throws SchemaElementNotFoundException {
        ArrayList<IDBField> result = new ArrayList<IDBField>();
        String[] stringArray = fieldNames;
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            IDBField field = this.getFieldSafe(fieldName);
            result.add(field);
            ++n2;
        }
        return result.toArray(new IDBField[result.size()]);
    }

    @Override
    public boolean hasIndexFor(IDBField ... fields) {
        for (IDBIndex index : this.indices) {
            IDBField[] indexFields = index.getFields();
            if (!DBTable.startsWith(indexFields, fields)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IDBIndex addIndex(String name, IDBIndex.Type type, IDBField ... fields) {
        this.assertUnlocked();
        if (name == null) {
            int position = this.indices.size();
            name = ((InternalDBSchema)this.schema).createIndexName(this, type, fields, position);
        }
        if (this.getIndex(name) != null) {
            throw new DBException("Index exists: " + name);
        }
        if (type == IDBIndex.Type.PRIMARY_KEY) {
            IDBIndex[] iDBIndexArray = this.getIndices();
            int n = iDBIndexArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDBIndex index = iDBIndexArray[n2];
                if (index.getType() == IDBIndex.Type.PRIMARY_KEY) {
                    throw new DBException("Primary key exists: " + index);
                }
                ++n2;
            }
        }
        DBIndex index = new DBIndex(this, name, type, fields);
        this.indices.add(index);
        this.resetElements();
        return index;
    }

    @Override
    public IDBIndex addIndex(String name, IDBIndex.Type type, String ... fieldNames) {
        return this.addIndex(name, type, this.getFields(fieldNames));
    }

    @Override
    public IDBIndex addIndexEmpty(String name, IDBIndex.Type type) {
        return this.addIndex(name, type, NO_FIELDS);
    }

    @Override
    public IDBIndex addIndex(IDBIndex.Type type, IDBField ... fields) {
        return this.addIndex(null, type, fields);
    }

    @Override
    public IDBIndex addIndex(IDBIndex.Type type, String ... fieldNames) {
        IDBField[] fields = this.getFields(fieldNames);
        return this.addIndex(type, fields);
    }

    @Override
    public IDBIndex addIndexEmpty(IDBIndex.Type type) {
        return this.addIndex(type, NO_FIELDS);
    }

    @Override
    public void removeIndex(IDBIndex indexToRemove) {
        this.assertUnlocked();
        if (this.indices.remove(indexToRemove)) {
            this.resetElements();
        }
    }

    @Override
    public IDBIndex getIndexSafe(String name) throws SchemaElementNotFoundException {
        IDBIndex index = this.getIndex(name);
        if (index == null) {
            throw new SchemaElementNotFoundException(this, IDBSchemaElement.SchemaElementType.INDEX, name);
        }
        return index;
    }

    @Override
    public IDBIndex getIndex(String name) {
        InternalDBSchema schema = (InternalDBSchema)this.getSchema();
        IDBNamedElement[] indices = this.getIndices();
        return (IDBIndex)DBTable.findElement((InternalDBSchema)schema, (IDBNamedElement[])indices, (String)name);
    }

    @Override
    public IDBIndex getIndex(int position) {
        return this.indices.get(position);
    }

    @Override
    public int getIndexCount() {
        return this.indices.size();
    }

    @Override
    public IDBIndex[] getIndices() {
        return this.indices.toArray(new IDBIndex[this.indices.size()]);
    }

    @Override
    public IDBIndex getPrimaryKeyIndex() {
        for (IDBIndex index : this.indices) {
            if (index.getType() != IDBIndex.Type.PRIMARY_KEY) continue;
            return index;
        }
        return null;
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public void remove() {
        this.schema.removeTable(this.getName());
    }

    @Override
    public String sqlInsert() {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getName());
        builder.append(" VALUES (");
        int i = 0;
        while (i < this.fields.size()) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append("?");
            ++i;
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public String toString() {
        String name = super.toString();
        IDBSchema schema = this.getSchema();
        if (schema != null && schema.isQualifiedTableNames()) {
            name = String.valueOf(DBUtil.quoted(schema.getName())) + '.' + name;
        }
        return name;
    }

    @Override
    protected void collectElements(List<IDBSchemaElement> elements) {
        elements.addAll(this.fields);
        elements.addAll(this.indices);
    }

    @Override
    protected void doAccept(IDBSchemaVisitor visitor) {
        visitor.visit(this);
    }

    private void assertUnlocked() {
        ((InternalDBSchema)this.schema).assertUnlocked();
    }

    private static boolean startsWith(IDBField[] indexFields, IDBField[] fields) {
        int length = fields.length;
        if (length <= indexFields.length) {
            int i = 0;
            while (i < length) {
                IDBField field = fields[i];
                if (field != indexFields[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

