/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class Parameters {
    private static final String NONE = "<NONE>";

    public abstract Parameters shallow();

    public abstract String get(String var1, String var2);

    public abstract void putAll(Map<String, String> var1);

    public abstract void put(String var1, String var2);

    public String get(String key) {
        return this.get(key, null);
    }

    public String expand(String value) {
        if (value == null) {
            return null;
        }
        int p0 = 0;
        int p1;
        while ((p1 = value.indexOf("${", p0)) >= 0) {
            int p2 = value.indexOf(125, p1);
            if (p2 < 0) {
                return value;
            }
            String subst = this.get(value.substring(p1 + 2, p2), "");
            value = String.valueOf(value.substring(0, p1)) + subst + value.substring(p2 + 1);
            p0 = p1 + subst.length();
        }
        return value;
    }

    public int getInt(String key, int defaultValue) {
        String value = this.get(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.get(key);
        return value == null ? defaultValue : "true".equalsIgnoreCase(value);
    }

    public String[] getStringArray(String key) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        int c = 0;
        int p = value.indexOf(44, c);
        while (p >= 0 && c < value.length()) {
            String v = value.substring(c, p);
            if (v.length() > 0) {
                values.add(v);
            }
            c = p + 1;
            p = value.indexOf(44, c);
        }
        if (c < value.length()) {
            values.add(value.substring(c));
        }
        return values.toArray(new String[0]);
    }

    public static final class Deep
    extends Parameters {
        private Parameters parent;
        private Map<String, String> base;
        private Map<String, String> materialized;

        public Deep(Parameters parent, Map<String, String> map) {
            this.parent = parent;
            this.base = new HashMap<String, String>(map);
            this.materialized = new HashMap<String, String>();
        }

        public Deep(Parameters parent, Parameters map) {
            this(parent, ((Deep)map).base);
        }

        public Deep(Map<String, String> map) {
            this(null, map);
        }

        @Override
        public String get(String key, String defaultValue) {
            String value = this.materialized.get(key);
            if (value == null) {
                value = this.base.get(key);
                if (value != null) {
                    value = this.expand(value);
                } else if (this.parent != null) {
                    value = this.parent.get(key);
                }
                if (value == null) {
                    value = Parameters.NONE;
                }
                this.materialized.put(key, value);
            }
            return value == Parameters.NONE ? defaultValue : value;
        }

        @Override
        public void putAll(Map<String, String> params) {
            this.base.putAll(params);
        }

        @Override
        public void put(String key, String value) {
            this.base.put(key, value);
        }

        @Override
        public Parameters shallow() {
            return new Parameters(){

                @Override
                public String get(String key, String defaultValue) {
                    String value = (String)base.get(key);
                    if (value == null) {
                        return defaultValue;
                    }
                    return this.expand(value);
                }

                @Override
                public Parameters shallow() {
                    return this;
                }

                @Override
                public void putAll(Map<String, String> params) {
                    base.putAll(params);
                }

                @Override
                public void put(String key, String value) {
                    base.put(key, value);
                }
            };
        }
    }
}

