/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction.AbstractJavaCorrectionPropsoal;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.graphics.Image;

public class NewDefaultConstructorCorrectionProposal
extends AbstractJavaCorrectionPropsoal {
    private ITypeBinding typeBinding;

    public NewDefaultConstructorCorrectionProposal(IInvocationContext invocationContext, ITypeBinding typeBinding, String displayString, int relevance, Image image) {
        super(invocationContext, displayString, relevance, image);
        this.typeBinding = typeBinding;
    }

    @Override
    public void addEdits(TextFileChange textChange) throws CoreException {
        CompilationUnit astRoot = this.invocationContext.getASTRoot();
        AST ast = astRoot.getAST();
        ASTRewrite rewriter = ASTRewrite.create((AST)ast);
        ASTNode typeDeclaration = astRoot.findDeclaringNode((IBinding)this.typeBinding);
        MethodDeclaration methodDeclaration = ast.newMethodDeclaration();
        SimpleName newNameNode = ast.newSimpleName(this.typeBinding.getName());
        methodDeclaration.setConstructor(true);
        methodDeclaration.modifiers().addAll(ast.newModifiers(1));
        methodDeclaration.setName(newNameNode);
        Block body = ast.newBlock();
        String placeHolder = CodeGeneration.getMethodBodyContent((ICompilationUnit)this.invocationContext.getCompilationUnit(), (String)this.typeBinding.getName(), (String)newNameNode.getIdentifier(), (boolean)true, (String)"", (String)String.valueOf('\n'));
        if (placeHolder != null) {
            ASTNode todoNode = rewriter.createStringPlaceholder(placeHolder, 41);
            body.statements().add(todoNode);
        }
        methodDeclaration.setBody(body);
        ChildListPropertyDescriptor property = ((AbstractTypeDeclaration)typeDeclaration).getBodyDeclarationsProperty();
        List members = (List)typeDeclaration.getStructuralProperty((StructuralPropertyDescriptor)property);
        ListIterator membersIterator = members.listIterator();
        int insertAt = 0;
        while (membersIterator.hasPrevious()) {
            ASTNode astNode = (ASTNode)membersIterator.previous();
            if (!(astNode instanceof MethodDeclaration) || !((MethodDeclaration)astNode).isConstructor()) continue;
            insertAt = membersIterator.previousIndex() + 1;
        }
        ListRewrite listRewriter = rewriter.getListRewrite(typeDeclaration, property);
        listRewriter.insertAt((ASTNode)methodDeclaration, insertAt, null);
        textChange.addEdit(rewriter.rewriteAST());
    }
}

