/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.webapplication.internal.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.j2ee.common.internal.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.internal.model.translator.webapplication.WebAppTranslator;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebAppResource;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public class WebAppResourceImpl
extends XMLResourceImpl
implements WebAppResource {
    public WebAppResourceImpl(URI uri, Renderer aRenderer) {
        super(uri, aRenderer);
    }

    public WebAppResourceImpl(Renderer aRenderer) {
        super(aRenderer);
    }

    @Override
    public WebApp getWebApp() {
        return (WebApp)this.getRootObject();
    }

    @Override
    public String getJ2EE_1_2_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
    }

    @Override
    public String getJ2EE_1_2_SystemID() {
        return "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd";
    }

    @Override
    public String getJ2EE_Alt_1_2_SystemID() {
        return "http://java.sun.com/j2ee/dtds/web-app_2.2.dtd";
    }

    @Override
    public String getJ2EE_1_3_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    }

    @Override
    public String getJ2EE_1_3_SystemID() {
        return "http://java.sun.com/dtd/web-app_2_3.dtd";
    }

    @Override
    public String getJ2EE_Alt_1_3_SystemID() {
        return "http://java.sun.com/dtd/web-app_2.3.dtd";
    }

    @Override
    public boolean isWeb2_2() {
        return this.getModuleVersionID() == 22;
    }

    @Override
    public boolean isWeb2_3() {
        return this.getModuleVersionID() == 23;
    }

    @Override
    public boolean isWeb2_4() {
        return this.getModuleVersionID() == 24;
    }

    public String getDoctype() {
        switch (this.getJ2EEVersionID()) {
            case 12: 
            case 13: {
                return "web-app";
            }
        }
        return null;
    }

    @Override
    public int getType() {
        return 4;
    }

    public Translator getRootTranslator() {
        return WebAppTranslator.INSTANCE;
    }

    @Override
    public int getJ2EEVersionID() {
        switch (this.getModuleVersionID()) {
            case 22: {
                return 12;
            }
            case 23: {
                return 13;
            }
            case 24: {
                return 14;
            }
        }
        return 14;
    }

    @Override
    public void setModuleVersionID(int id) {
        super.setVersionID(id);
        switch (id) {
            case 25: {
                super.setDoctypeValues(null, null);
                this.primSetVersionID(25);
                break;
            }
            case 24: {
                super.setDoctypeValues(null, null);
                this.primSetVersionID(24);
                break;
            }
            case 23: {
                super.setDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
                break;
            }
            case 22: {
                super.setDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
            }
        }
        this.syncVersionOfRootObject();
    }

    @Override
    public void setJ2EEVersionID(int id) {
        switch (id) {
            case 50: {
                this.primSetDoctypeValues(null, null);
                this.primSetVersionID(25);
                break;
            }
            case 14: {
                this.primSetDoctypeValues(null, null);
                this.primSetVersionID(24);
                break;
            }
            case 13: {
                this.primSetDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
                this.primSetVersionID(23);
                break;
            }
            case 12: {
                this.primSetDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
                this.primSetVersionID(22);
            }
        }
        this.syncVersionOfRootObject();
    }

    @Override
    protected int getDefaultVersionID() {
        return 24;
    }

    @Override
    protected void syncVersionOfRootObject() {
        WebApp app = this.getWebApp();
        if (app == null) {
            return;
        }
        String version = app.getVersion();
        String newVersion = this.getModuleVersionString();
        if (!newVersion.equals(version)) {
            app.setVersion(newVersion);
        }
    }
}

