/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaManyToManyRelationship;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaMappingRelationship;
import org.eclipse.jpt.jpa.core.internal.context.java.GenericJavaMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaMappingJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.resource.java.OwnableRelationshipMappingAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericJavaManyToManyRelationship
extends AbstractJavaMappingRelationship<JavaManyToManyMapping>
implements JavaManyToManyRelationship {
    protected final SpecifiedMappedByRelationshipStrategy mappedByStrategy = this.buildMappedByStrategy();
    protected final JavaSpecifiedJoinTableRelationshipStrategy joinTableStrategy = this.buildJoinTableStrategy();

    public GenericJavaManyToManyRelationship(JavaManyToManyMapping parent) {
        super(parent);
        this.strategy = this.buildStrategy();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.mappedByStrategy.synchronizeWithResourceModel(monitor);
        this.joinTableStrategy.synchronizeWithResourceModel(monitor);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.mappedByStrategy.update(monitor);
        this.joinTableStrategy.update(monitor);
    }

    @Override
    protected SpecifiedRelationshipStrategy buildStrategy() {
        if (this.mappedByStrategy.getMappedByAttribute() != null) {
            return this.mappedByStrategy;
        }
        return this.joinTableStrategy;
    }

    @Override
    public SpecifiedMappedByRelationshipStrategy getMappedByStrategy() {
        return this.mappedByStrategy;
    }

    @Override
    public boolean strategyIsMappedBy() {
        return this.strategy == this.mappedByStrategy;
    }

    @Override
    public void setStrategyToMappedBy() {
        this.mappedByStrategy.addStrategy();
        this.joinTableStrategy.removeStrategy();
        this.updateStrategy();
    }

    @Override
    public boolean mayBeMappedBy(AttributeMapping mapping) {
        return mapping.getKey() == "manyToMany";
    }

    protected SpecifiedMappedByRelationshipStrategy buildMappedByStrategy() {
        return new GenericJavaMappedByRelationshipStrategy(this);
    }

    @Override
    public JavaSpecifiedJoinTableRelationshipStrategy getJoinTableStrategy() {
        return this.joinTableStrategy;
    }

    @Override
    public boolean strategyIsJoinTable() {
        return this.strategy == this.joinTableStrategy;
    }

    @Override
    public void setStrategyToJoinTable() {
        this.mappedByStrategy.removeStrategy();
        this.updateStrategy();
    }

    @Override
    public boolean mayHaveDefaultJoinTable() {
        return this.getMappedByStrategy().getMappedByAttribute() == null;
    }

    protected JavaSpecifiedJoinTableRelationshipStrategy buildJoinTableStrategy() {
        return new GenericJavaMappingJoinTableRelationshipStrategy(this);
    }

    @Override
    public OwnableRelationshipMappingAnnotation getMappingAnnotation() {
        return ((JavaManyToManyMapping)this.getMapping()).getMappingAnnotation();
    }

    @Override
    public OwnableRelationshipMappingAnnotation getMappingAnnotationForUpdate() {
        return ((JavaManyToManyMapping)this.getMapping()).getAnnotationForUpdate();
    }

    @Override
    public boolean isOwner() {
        return this.mappedByStrategy.getMappedByAttribute() == null;
    }

    @Override
    public boolean isOwnedBy(RelationshipMapping mapping) {
        return this.mappedByStrategy.relationshipIsOwnedBy(mapping);
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.mappedByStrategy.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return this.joinTableStrategy.getCompletionProposals(pos);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.mappedByStrategy.validate(messages, reporter);
        this.joinTableStrategy.validate(messages, reporter);
    }
}

