/*******************************************************************************
 * Copyright (c) 2011, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0, which accompanies this distribution
 * and is available at https://www.eclipse.org/legal/epl-2.0/.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.jaxb.core.internal.resource.jaxbprops;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.jaxb.core.internal.resource.AbstractJaxbFileResourceModel;
import org.eclipse.jpt.jaxb.core.resource.jaxbprops.JaxbPropertiesResource;

/**
 * JAXB index
 */
public class JaxbPropertiesResourceImpl
	extends AbstractJaxbFileResourceModel<Properties>
	implements JaxbPropertiesResource
{
	public JaxbPropertiesResourceImpl(IFile file) {
		super(file);
	}

	@Override
	protected Properties buildState() {
		return new Properties();
	}

	@Override
	protected void reload() {
		this.state.clear();
		super.reload();
	}

	@Override
	protected void load(InputStream stream) throws IOException {
		this.state.load(stream);
	}

	public String getProperty(String propertyName) {
		return this.state.getProperty(propertyName);
	}

	public JptResourceType getResourceType() {
		return RESOURCE_TYPE;
	}
}
