/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.net4j.util.WrappedException;

public class LoadCommitInfosIndication
extends CDOServerReadIndication {
    private CDOBranch branch;
    private long startTime;
    private long endTime;

    public LoadCommitInfosIndication(CDOServerProtocol protocol) {
        super(protocol, (short)40);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        this.branch = in.readBoolean() ? in.readCDOBranch() : null;
        this.startTime = in.readXLong();
        this.endTime = in.readXLong();
    }

    @Override
    protected void responding(final CDODataOutput out) throws IOException {
        try {
            InternalCDOCommitInfoManager manager = this.getRepository().getCommitInfoManager();
            manager.getCommitInfos(this.branch, this.startTime, this.endTime, new CDOCommitInfoHandler(){

                public void handleCommitInfo(CDOCommitInfo commitInfo) {
                    try {
                        out.writeBoolean(true);
                        out.writeXLong(commitInfo.getPreviousTimeStamp());
                        if (LoadCommitInfosIndication.this.branch == null) {
                            out.writeCDOBranch(commitInfo.getBranch());
                        }
                        out.writeXLong(commitInfo.getTimeStamp());
                        out.writeString(commitInfo.getUserID());
                        out.writeString(commitInfo.getComment());
                        CDOBranchUtil.writeBranchPointOrNull((CDODataOutput)out, (CDOBranchPoint)commitInfo.getMergeSource());
                    }
                    catch (IOException ex) {
                        throw WrappedException.wrap((Exception)ex);
                    }
                }
            });
        }
        catch (RuntimeException ex) {
            Exception unwrapped = WrappedException.unwrap((Exception)ex);
            if (unwrapped instanceof IOException) {
                throw (IOException)unwrapped;
            }
            throw ex;
        }
        out.writeBoolean(false);
    }
}

