/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.UUID;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.io.FileOutputStream;
import org.burningwave.core.io.FileSystemItem;

public class Objects {
    public static Objects create() {
        return new Objects();
    }

    public String getIdOrUUIDIfNull(Object target) {
        try {
            return target.getClass().getName() + "@" + System.identityHashCode(target);
        }
        catch (NullPointerException exc) {
            if (target != null) {
                throw exc;
            }
            return UUID.randomUUID().toString();
        }
    }

    public String getId(Object target) {
        return target.getClass().getName() + "@" + System.identityHashCode(target);
    }

    public String getStandardId(Object target) {
        return target.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(target));
    }

    public String getCurrentId(Object target) {
        return target.getClass().getName() + "@" + System.identityHashCode(target) + "_" + System.currentTimeMillis();
    }

    public String getClassId(Class<?> targetClass) {
        return targetClass.getName() + "@" + System.identityHashCode(targetClass.getClass());
    }

    public int toInt(Object object) {
        return object instanceof Integer ? ((Integer)object).intValue() : Integer.valueOf(object.toString()).intValue();
    }

    public long toLong(Object object) {
        return object instanceof Long ? (Long)object : Long.valueOf(object.toString());
    }

    public boolean toBoolean(Object object) {
        return object instanceof Boolean ? (Boolean)object : Boolean.valueOf(object.toString());
    }

    public <S> void serialize(S object, OutputStream outputStream) {
        try (ObjectOutputStream out = new ObjectOutputStream(outputStream);){
            out.writeObject(object);
        }
        catch (Throwable exc) {
            StaticComponentContainer.Driver.throwException(exc);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <S extends Serializable> S deserialize(InputStream inputStream) {
        try (ObjectInputStream in = new ObjectInputStream(inputStream);){
            Serializable serializable = (Serializable)in.readObject();
            return (S)serializable;
        }
        catch (Throwable exc) {
            return (S)((Serializable)StaticComponentContainer.Driver.throwException(exc));
        }
    }

    public <S extends Serializable> FileSystemItem serializeToPath(S object, String absolutePath) {
        try (FileOutputStream outputStream = FileOutputStream.create(absolutePath);){
            this.serialize(object, outputStream);
        }
        catch (Throwable exc) {
            StaticComponentContainer.Driver.throwException(exc);
        }
        return FileSystemItem.ofPath(absolutePath);
    }

    public <S extends Serializable> S deserializeFromPath(String absolutePath) {
        return FileSystemItem.ofPath(absolutePath).toObject();
    }
}

