/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.util;

import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import org.apache.wsil.util.WSDLDocument;

public class WSDLDocumentIdentifier {
    public static boolean isInterfaceDocument(WSDLDocument wsdlDocument) {
        Definition definition = wsdlDocument.getDefinitions();
        return WSDLDocumentIdentifier.hasMessageElement(definition) && WSDLDocumentIdentifier.hasPortTypeElement(definition) && WSDLDocumentIdentifier.hasBindingElement(definition);
    }

    public static boolean isBindingInterfaceDocument(WSDLDocument wsdlDocument) {
        Definition definition = wsdlDocument.getDefinitions();
        return WSDLDocumentIdentifier.hasBindingElement(definition);
    }

    public static boolean isImplementationDocument(WSDLDocument wsdlDocument) {
        Definition definition = wsdlDocument.getDefinitions();
        return WSDLDocumentIdentifier.hasImportElement(definition) && WSDLDocumentIdentifier.hasServiceElement(definition);
    }

    public static boolean isCompleteDocument(WSDLDocument wsdlDocument) {
        Definition definition = wsdlDocument.getDefinitions();
        return WSDLDocumentIdentifier.hasMessageElement(definition) && WSDLDocumentIdentifier.hasPortTypeElement(definition) && WSDLDocumentIdentifier.hasBindingElement(definition) && WSDLDocumentIdentifier.hasServiceElement(definition);
    }

    private static boolean hasMessageElement(Definition definition) {
        for (Message x : definition.getMessages().values()) {
            if (x.isUndefined()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasPortTypeElement(Definition definition) {
        for (PortType x : definition.getPortTypes().values()) {
            if (x.isUndefined()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasBindingElement(Definition definition) {
        for (Binding x : definition.getBindings().values()) {
            if (x.isUndefined()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasImportElement(Definition definition) {
        return !definition.getImports().isEmpty();
    }

    private static boolean hasServiceElement(Definition definition) {
        return !definition.getServices().isEmpty();
    }
}

