/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import java.io.IOException;
import org.eclipse.wst.css.core.internal.Logger;
import org.eclipse.wst.css.core.internal.document.CSSRuleImpl;
import org.eclipse.wst.css.core.internal.provisional.adapters.IModelProvideAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSImportRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.css.core.internal.util.CSSLinkConverter;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.css.core.internal.util.URLModelProviderCSS;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class CSSImportRuleImpl
extends CSSRuleImpl
implements ICSSImportRule {
    private boolean fDirty = true;
    private ICSSStyleSheet fStyleSheet;

    public CSSImportRuleImpl() {
    }

    public CSSImportRuleImpl(CSSImportRuleImpl that) {
        super(that);
    }

    @Override
    public ICSSNode cloneNode(boolean deep) {
        CSSImportRuleImpl cloned = new CSSImportRuleImpl(this);
        if (deep) {
            this.cloneChildNodes(cloned, deep);
        }
        return cloned;
    }

    void closeStyleSheet() {
        if (this.fStyleSheet != null) {
            ICSSStyleSheet sheet = this.fStyleSheet;
            this.fStyleSheet = null;
            sheet.getModel().removeStyleListener(this.getOwnerDocument().getModel());
            IModelProvideAdapter adapter = (IModelProvideAdapter)this.getAdapterFor(IModelProvideAdapter.class);
            if (adapter != null) {
                adapter.modelRemoved(sheet.getModel());
            }
            sheet.getModel().releaseFromRead();
        }
    }

    @Override
    public String getHref() {
        return CSSUtil.extractUriContents(this.getAttribute("href"));
    }

    @Override
    public MediaList getMedia() {
        ICSSNode media = this.getFirstChild();
        if (media != null && media instanceof MediaList) {
            return (MediaList)((Object)media);
        }
        return null;
    }

    @Override
    public short getNodeType() {
        return 3;
    }

    @Override
    public CSSStyleSheet getStyleSheet() {
        if (this.fDirty) {
            IStructuredModel newModel;
            IModelProvideAdapter adapter;
            block11: {
                block10: {
                    block9: {
                        this.closeStyleSheet();
                        if (this.getHref() != null && this.getHref().length() > 0) break block9;
                        this.fDirty = false;
                        return null;
                    }
                    ICSSModel baseModel = this.getOwnerDocument().getModel();
                    if (this.getOwnerDocument().getModel().getStyleSheetType() == "embeddedCSS") {
                        baseModel = ((IDOMNode)this.getOwnerDocument().getModel().getOwnerDOMNode()).getModel();
                    }
                    adapter = (IModelProvideAdapter)this.getAdapterFor(IModelProvideAdapter.class);
                    URLModelProviderCSS provider = new URLModelProviderCSS();
                    newModel = provider.getModelForRead(baseModel, this.getHref());
                    this.fDirty = false;
                    if (newModel != null) break block10;
                    return null;
                }
                if (newModel instanceof ICSSModel) break block11;
                newModel.releaseFromRead();
                return null;
            }
            try {
                if (adapter != null) {
                    adapter.modelProvided(newModel);
                }
                this.fStyleSheet = (ICSSStyleSheet)((ICSSModel)newModel).getDocument();
                if (this.fStyleSheet != null) {
                    this.fStyleSheet.getModel().addStyleListener(this.getOwnerDocument().getModel());
                }
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        return this.fStyleSheet;
    }

    @Override
    public short getType() {
        return 3;
    }

    @Override
    public void refreshStyleSheet() {
        if (!this.fDirty) {
            this.closeStyleSheet();
            this.fDirty = true;
            this.notify(1, this.getAttributeNode("href"), null, null, this.getStartOffset());
        }
    }

    void releaseRule() {
        if (this.fStyleSheet != null) {
            ICSSStyleSheet sheet = this.fStyleSheet;
            this.fStyleSheet = null;
            sheet.getModel().removeStyleListener(this.getOwnerDocument().getModel());
            IModelProvideAdapter adapter = (IModelProvideAdapter)this.getAdapterFor(IModelProvideAdapter.class);
            if (adapter != null) {
                adapter.modelReleased(sheet.getModel());
            }
            sheet.getModel().releaseFromRead();
        }
    }

    @Override
    public void setHref(String href) throws DOMException {
        this.fDirty = true;
        this.setAttribute("href", CSSLinkConverter.addFunc(href));
    }
}

