/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui.dialogs.color;

import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.ColorInfo;

public class ColorsGridComposite
extends Canvas {
    private int m_cellWidth = 25;
    private int m_cellHeight = 25;
    private boolean m_showNames;
    private int m_maxNameWidth = Integer.MAX_VALUE;
    private int m_colorWidth;
    private ColorInfo[] m_colors;
    private int m_columns = 16;
    private int m_rows;
    private boolean m_captured;
    private ColorInfo m_currentColorUnderMouse;

    public ColorsGridComposite(Composite parent, int style) {
        super(parent, 0x240000);
        this.setBackground(this.getDisplay().getSystemColor(25));
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ColorsGridComposite.this.onPaint(e);
            }
        });
        this.addMouseListeners();
    }

    private void addMouseListeners() {
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (!ColorsGridComposite.this.m_captured) {
                    ColorInfo colorUnderMouse = ColorsGridComposite.this.getColorUnderMouse(e);
                    ColorsGridComposite.this.setNewColorUnderMouse(colorUnderMouse);
                }
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                ColorsGridComposite.this.setNewColorUnderMouse(null);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){
            private ColorInfo m_color;

            public void mouseDown(MouseEvent e) {
                this.capture(true);
                this.m_color = ColorsGridComposite.this.getColorUnderMouse(e);
            }

            public void mouseUp(MouseEvent e) {
                this.capture(false);
                if (ColorsGridComposite.this.getClientArea().contains(e.x, e.y)) {
                    Event event = new Event();
                    event.data = this.m_color;
                    ColorsGridComposite.this.notifyListeners(13, event);
                }
            }

            private void capture(boolean capture) {
                ColorsGridComposite.this.setCapture(capture);
                ColorsGridComposite.this.m_captured = capture;
            }
        });
    }

    public ColorInfo[] getColors() {
        return this.m_colors;
    }

    public void setColors(ColorInfo[] colors) {
        this.m_colors = colors;
        this.updateGrid();
    }

    public void setColumns(int columns) {
        this.m_columns = columns;
        this.updateGrid();
    }

    public void setCellWidth(int cellWidth) {
        this.m_cellWidth = cellWidth;
        this.updateGrid();
    }

    public void setCellHeight(int cellHeight) {
        this.m_cellHeight = cellHeight;
        this.updateGrid();
    }

    public void showNames(int colorWidth) {
        this.m_showNames = true;
        this.m_colorWidth = colorWidth;
    }

    public void setMaxNameWidth(int maxNameWidth) {
        this.m_maxNameWidth = maxNameWidth;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.m_showNames) {
            int maxNameWidth = 0;
            GC gc = new GC((Drawable)this);
            try {
                int i = 0;
                while (i < this.m_colors.length) {
                    ColorInfo colorInfo = this.m_colors[i];
                    maxNameWidth = Math.max(maxNameWidth, gc.stringExtent((String)colorInfo.m_name).x);
                    ++i;
                }
                maxNameWidth = Math.min(maxNameWidth, this.m_maxNameWidth);
            }
            finally {
                gc.dispose();
            }
            this.m_cellWidth = this.m_colorWidth + maxNameWidth + 5;
        }
        return new Point(this.m_cellWidth * this.m_columns, this.m_cellHeight * this.m_rows);
    }

    private void onPaint(PaintEvent e) {
        GC paintGC = e.gc;
        Rectangle paintRect = new Rectangle(e.x, e.y, e.width, e.height);
        Image backImage = new Image((Device)this.getDisplay(), e.width, e.height);
        GC gc = new GC((Drawable)backImage);
        gc.setBackground(this.getBackground());
        gc.fillRectangle(0, 0, e.width, e.height);
        try {
            int border = 3;
            int index = 0;
            while (index < this.m_colors.length) {
                ColorInfo colorInfo = this.m_colors[index];
                Rectangle cellRect = this.getCellRectForIndex(index);
                if (paintRect.intersects(cellRect)) {
                    int x = cellRect.x;
                    int y = cellRect.y;
                    x -= e.x;
                    y -= e.y;
                    if (this.m_showNames) {
                        if (colorInfo.m_rgb != null) {
                            ColorsGridComposite.drawColorCell(gc, x + border, y + border, this.m_colorWidth - 2 * border, this.m_cellHeight - 2 * border, colorInfo);
                        }
                        Point extent = gc.textExtent(colorInfo.m_name);
                        int x0 = x + this.m_colorWidth;
                        int y0 = y + (this.m_cellHeight - extent.y) / 2;
                        gc.setForeground(this.getForeground());
                        gc.drawText(colorInfo.m_name, x0, y0, true);
                    } else {
                        ColorsGridComposite.drawColorCell(gc, x + border, y + border, this.m_cellWidth - 2 * border, this.m_cellHeight - 2 * border, colorInfo);
                    }
                    if (colorInfo == this.m_currentColorUnderMouse) {
                        gc.setForeground(this.getDisplay().getSystemColor(18));
                        gc.drawRectangle(x, y, cellRect.width - 1, cellRect.height - 1);
                    }
                }
                ++index;
            }
            paintGC.drawImage(backImage, e.x, e.y);
        }
        finally {
            gc.dispose();
            backImage.dispose();
        }
    }

    public static void drawColorCell(GC gc, int x, int y, int w, int h, ColorInfo colorInfo) {
        Display display = Display.getCurrent();
        Color oldBackground = gc.getBackground();
        Color color = new Color((Device)display, colorInfo.m_rgb);
        try {
            gc.setBackground(color);
            gc.fillRectangle(x, y, w, h);
        }
        finally {
            color.dispose();
            gc.setBackground(oldBackground);
        }
        gc.setForeground(display.getSystemColor(15));
        gc.drawLine(x, y, x + w - 1, y);
        gc.drawLine(x, y, x, y + h - 1);
    }

    private ColorInfo getColorUnderMouse(MouseEvent e) {
        int row = e.y / this.m_cellHeight;
        int column = e.x / this.m_cellWidth;
        int index = row * this.m_columns + column;
        return index < this.m_colors.length ? this.m_colors[index] : null;
    }

    private void setNewColorUnderMouse(ColorInfo colorUnderMouse) {
        if (this.m_currentColorUnderMouse != colorUnderMouse) {
            Event event = new Event();
            event.data = colorUnderMouse;
            this.notifyListeners(14, event);
            ColorInfo oldColorUnderMouse = this.m_currentColorUnderMouse;
            this.m_currentColorUnderMouse = colorUnderMouse;
            this.redrawColorCell(oldColorUnderMouse);
            this.redrawColorCell(this.m_currentColorUnderMouse);
        }
    }

    private void redrawColorCell(ColorInfo colorInfo) {
        Rectangle cell = this.getCellRectForColor(colorInfo);
        if (cell != null) {
            this.redraw(cell.x, cell.y, cell.width, cell.height, false);
        }
    }

    private Rectangle getCellRectForColor(ColorInfo colorInfo) {
        if (colorInfo == null) {
            return null;
        }
        int index = ArrayUtils.indexOf((Object[])this.m_colors, (Object)colorInfo);
        return this.getCellRectForIndex(index);
    }

    private Rectangle getCellRectForIndex(int index) {
        int column = index % this.m_columns;
        int row = index / this.m_columns;
        Rectangle cellRect = new Rectangle(this.m_cellWidth * column, this.m_cellHeight * row, this.m_cellWidth, this.m_cellHeight);
        return cellRect;
    }

    private void updateGrid() {
        if (this.m_colors != null && this.m_columns != 0) {
            this.m_rows = this.m_colors.length / this.m_columns + (this.m_colors.length % this.m_columns != 0 ? 1 : 0);
            this.redraw();
        }
    }
}

