/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.helper;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;

public final class RepresentationHelper {
    private RepresentationHelper() {
    }

    public static void updateChangeId(DRepresentationDescriptor representationDescriptor) {
        representationDescriptor.setChangeId(Long.valueOf(System.currentTimeMillis()).toString());
    }

    public static boolean areRepresentationsIdentical(DRepresentationDescriptor representationDescriptor1, DRepresentationDescriptor representationDescriptor2) {
        String changeId1 = representationDescriptor1.getChangeId();
        String changeId2 = representationDescriptor2.getChangeId();
        return changeId1 == null || changeId2 == null || !changeId1.equals(changeId2);
    }

    public static AnnotationEntry getOrCreateAnnotation(String source, DRepresentation representation, EObject eObject) {
        AnnotationEntry annotation = (AnnotationEntry)new DRepresentationQuery(representation).getAnnotation(source, eObject).get();
        if (annotation == null && eObject != null) {
            annotation = DescriptionFactory.eINSTANCE.createAnnotationEntry();
            annotation.setSource(source);
            annotation.setData(eObject);
            representation.getOwnedAnnotationEntries().add((Object)annotation);
        }
        return annotation;
    }
}

