/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.presentation;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditorPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class WorkspaceAndPluginsResourceDialog
extends ElementTreeSelectionDialog {
    private List<String> extensions;

    public WorkspaceAndPluginsResourceDialog(Shell parent, boolean allowMultiple, List<String> extensions) {
        super(parent, WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (ITreeContentProvider)new DeferredWorkbenchContentProvider());
        this.extensions = new ArrayList<String>(extensions);
        this.setAllowMultiple(allowMultiple);
        if (allowMultiple) {
            this.setTitle(SiriusEditorPlugin.INSTANCE.getString("titleSelectFiles"));
        } else {
            this.setTitle(SiriusEditorPlugin.INSTANCE.getString("titleSelectAFile"));
        }
        this.setInput(new WorkbenchProxyObject());
        this.addFilter(new FileExtensionFilter());
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new TreeViewer(new Tree(parent, style)){

            public boolean isExpandable(Object element) {
                if (element instanceof WorkbenchProxyObject && ((WorkbenchProxyObject)element).getContainedObject() instanceof ITargetDefinition) {
                    return true;
                }
                return super.isExpandable(element);
            }
        };
    }

    public List<String> getPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        Object[] result = this.getResult();
        if (result != null) {
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                String path;
                Object obj = objectArray[n2];
                if (obj instanceof IFile) {
                    paths.add(((IFile)obj).getFullPath().toString());
                } else if (obj instanceof WorkbenchProxyObject && (path = ((WorkbenchProxyObject)obj).getFilePath()) != null) {
                    paths.add(path);
                }
                ++n2;
            }
        }
        return paths;
    }

    public static String openDialogForImages(Shell shell) {
        ArrayList<String> extensions = new ArrayList<String>();
        ImageFileFormat[] imageFileFormatArray = ImageFileFormat.VALUES;
        int n = ImageFileFormat.VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFileFormat iff = imageFileFormatArray[n2];
            extensions.add(iff.getName());
            ++n2;
        }
        WorkspaceAndPluginsResourceDialog dialog = new WorkspaceAndPluginsResourceDialog(shell, false, extensions);
        dialog.open();
        List<String> paths = dialog.getPaths();
        if (paths.size() > 0) {
            return paths.get(0);
        }
        return null;
    }

    private static class CustomWorkbenchAdapter
    implements IDeferredWorkbenchAdapter {
        private CustomWorkbenchAdapter() {
        }

        public String getLabel(Object object) {
            return ((WorkbenchProxyObject)object).getLabel();
        }

        public Object[] getChildren(Object element) {
            return ((WorkbenchProxyObject)element).getChildren();
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            TargetBundle[] targetBundles;
            ITargetDefinition targetDefinition = (ITargetDefinition)((WorkbenchProxyObject)object).getContainedObject();
            if (!targetDefinition.isResolved()) {
                targetDefinition.resolve(monitor);
            }
            if ((targetBundles = targetDefinition.getAllBundles()) != null) {
                TargetBundle[] targetBundleArray = targetBundles;
                int n = targetBundles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file;
                    TargetBundle tb = targetBundleArray[n2];
                    if (monitor.isCanceled()) break;
                    URI location = tb.getBundleInfo().getLocation();
                    if (location != null && (file = new File(location)).getName().toLowerCase().endsWith(".jar")) {
                        try {
                            collector.add((Object)new WorkbenchProxyObject(new ZipFile(file), null), monitor);
                        }
                        catch (IOException iOException) {}
                    }
                    ++n2;
                }
            }
            collector.done();
        }

        public boolean isContainer() {
            return false;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            ImageDescriptor imageDescriptor = null;
            Object containedObject = ((WorkbenchProxyObject)object).getContainedObject();
            String sharedImagesString = null;
            if (containedObject instanceof ITargetDefinition) {
                sharedImagesString = "IMG_OBJ_ELEMENTS";
            } else if (containedObject instanceof ZipFile) {
                sharedImagesString = "IMG_OBJ_PROJECT";
            } else if (containedObject instanceof ZipEntry) {
                String entryName = ((ZipEntry)containedObject).getName();
                entryName = entryName.substring(entryName.lastIndexOf(File.separator) + File.separator.length());
                imageDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(entryName);
            }
            if (sharedImagesString != null) {
                imageDescriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(sharedImagesString);
            }
            return imageDescriptor;
        }

        public Object getParent(Object o) {
            return null;
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }
    }

    private static class DeferredWorkbenchContentProvider
    extends WorkbenchContentProvider {
        DeferredTreeContentManager manager;

        private DeferredWorkbenchContentProvider() {
        }

        public Object[] getChildren(Object element) {
            WorkbenchProxyObject wpo;
            if (element instanceof WorkbenchProxyObject && (wpo = (WorkbenchProxyObject)element).getContainedObject() instanceof ITargetDefinition) {
                return this.manager.getChildren((Object)wpo);
            }
            return super.getChildren(element);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            super.inputChanged(viewer, oldInput, newInput);
            this.manager = new DeferredTreeContentManager((AbstractTreeViewer)viewer);
        }
    }

    private class FileExtensionFilter
    extends ViewerFilter {
        private FileExtensionFilter() {
        }

        public boolean select(Viewer theViewer, Object parentElement, Object element) {
            if (WorkspaceAndPluginsResourceDialog.this.extensions == null || WorkspaceAndPluginsResourceDialog.this.extensions.size() == 0 || WorkspaceAndPluginsResourceDialog.this.extensions.contains("*")) {
                return true;
            }
            IResource resource = null;
            if (element instanceof IResource) {
                resource = (IResource)element;
            } else if (element instanceof IAdaptable) {
                resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
            }
            boolean isValid = true;
            if (resource != null && !resource.isDerived()) {
                isValid = this.validateResource(resource);
            } else if (element instanceof WorkbenchProxyObject) {
                WorkbenchProxyObject wpo = (WorkbenchProxyObject)element;
                isValid = wpo.isChecked() ? wpo.isValid() : this.validateWorkbenchProxyObject(wpo);
            }
            return isValid;
        }

        private boolean validateResource(IResource resource) {
            boolean isValid = false;
            if (resource instanceof IContainer) {
                try {
                    IResource[] members;
                    IResource[] iResourceArray = members = ((IContainer)resource).members();
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource member = iResourceArray[n2];
                        isValid = this.validateResource(member);
                        if (!isValid) {
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException coreException) {}
            } else if (resource.getType() == 1) {
                for (String ext : WorkspaceAndPluginsResourceDialog.this.extensions) {
                    if (!ext.equalsIgnoreCase(resource.getFileExtension())) continue;
                    isValid = true;
                    break;
                }
            }
            return isValid;
        }

        private boolean validateWorkbenchProxyObject(WorkbenchProxyObject wpo) {
            boolean isValid = false;
            String fileExtension = wpo.getFileExtension();
            if (fileExtension != null) {
                for (String ext : WorkspaceAndPluginsResourceDialog.this.extensions) {
                    if (!fileExtension.equalsIgnoreCase(ext)) continue;
                    isValid = true;
                    break;
                }
            } else {
                Object[] objectArray = wpo.getChildren();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    isValid = this.validateWorkbenchProxyObject((WorkbenchProxyObject)obj);
                    if (!isValid) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
            wpo.setChecked(true);
            wpo.setValid(isValid);
            return isValid;
        }
    }

    private static class WorkbenchProxyObject
    implements IAdaptable {
        private Object containedObject;
        private String pluginPath;
        private boolean root;
        private boolean checked;
        private boolean valid = true;

        WorkbenchProxyObject() {
            this.containedObject = null;
            this.root = true;
            this.checked = true;
        }

        WorkbenchProxyObject(Object object, String pluginName) {
            this.pluginPath = pluginName;
            this.containedObject = object;
            this.root = false;
            this.checked = false;
        }

        public Object getContainedObject() {
            return this.containedObject;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }

        public Object[] getChildren() {
            Object[] result = new Object[]{};
            if (this.root) {
                ITargetPlatformService service = (ITargetPlatformService)PlatformUI.getWorkbench().getService(ITargetPlatformService.class);
                ITargetDefinition td = null;
                if (service != null) {
                    try {
                        ITargetHandle handle = service.getWorkspaceTargetHandle();
                        if (handle != null) {
                            td = handle.getTargetDefinition();
                        }
                    }
                    catch (CoreException coreException) {}
                }
                if (td != null) {
                    WorkbenchProxyObject wpoTargetDefinition = new WorkbenchProxyObject(td, null);
                    wpoTargetDefinition.setChecked(true);
                    result = new Object[]{ResourcesPlugin.getWorkspace().getRoot(), wpoTargetDefinition};
                } else {
                    result = new Object[]{ResourcesPlugin.getWorkspace().getRoot()};
                }
            } else if (this.containedObject instanceof ZipFile) {
                ArrayList<WorkbenchProxyObject> children = new ArrayList<WorkbenchProxyObject>();
                Enumeration<? extends ZipEntry> entries = ((ZipFile)this.containedObject).entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    if (zipEntry.isDirectory()) continue;
                    children.add(new WorkbenchProxyObject(zipEntry, this.getLabel()));
                }
                result = children.toArray();
            }
            return result;
        }

        public String getLabel() {
            String result = "";
            if (this.containedObject instanceof ITargetDefinition) {
                result = "Plugins";
            } else if (this.containedObject instanceof ZipFile) {
                result = ((ZipFile)this.containedObject).getName();
                int startPosition = result.lastIndexOf(File.separator) + File.separator.length();
                int endPosition = result.lastIndexOf("_");
                if (endPosition <= startPosition) {
                    endPosition = result.length() - 4;
                }
                result = result.substring(startPosition, endPosition);
            } else if (this.containedObject instanceof ZipEntry) {
                result = ((ZipEntry)this.containedObject).getName();
            }
            return result;
        }

        public String getFilePath() {
            if (this.containedObject instanceof ZipEntry) {
                String path = ((ZipEntry)this.containedObject).getName();
                return "/" + this.pluginPath + "/" + path;
            }
            return null;
        }

        public String getFileExtension() {
            String path;
            int lastDot;
            if (this.containedObject instanceof ZipEntry && (lastDot = (path = ((ZipEntry)this.containedObject).getName()).lastIndexOf(".")) > path.lastIndexOf(File.separator)) {
                return path.substring(lastDot + 1);
            }
            return null;
        }

        public Object getAdapter(Class adapter) {
            CustomWorkbenchAdapter obj = null;
            if (adapter == IWorkbenchAdapter.class || adapter == IDeferredWorkbenchAdapter.class) {
                obj = new CustomWorkbenchAdapter();
            }
            return obj;
        }
    }
}

