/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.php.internal.ui.editor.configuration.StructuredDocumentDamagerRepairer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.wst.sse.core.internal.text.rules.SimpleStructuredTypedRegion;
import org.eclipse.wst.sse.ui.internal.provisional.style.StructuredPresentationReconciler;

public class PHPStructuredPresentationReconciler
extends StructuredPresentationReconciler {
    private Map<String, IPresentationRepairer> fRepairers;
    private static final Set<String> fTypeSet = new HashSet<String>();

    static {
        fTypeSet.add("org.eclipse.wst.css.STYLE");
        fTypeSet.add("org.eclipse.wst.html.SCRIPT");
    }

    ITypedRegion getWholeRegion(ITypedRegion[] wholePartitions, ITypedRegion originalRegion) {
        if (fTypeSet.contains(originalRegion.getType())) {
            int i = 0;
            int jumpto = -1;
            while (i < wholePartitions.length) {
                ITypedRegion r = wholePartitions[i];
                if (wholePartitions[i].getType().equals(originalRegion.getType())) {
                    jumpto = this.getFollowingCSS(wholePartitions, i, originalRegion.getType());
                    r = new SimpleStructuredTypedRegion(r.getOffset(), wholePartitions[jumpto].getOffset() + wholePartitions[jumpto].getLength() - r.getOffset(), originalRegion.getType());
                    if (originalRegion.getOffset() >= r.getOffset() && originalRegion.getOffset() + originalRegion.getLength() <= r.getOffset() + r.getLength()) {
                        return r;
                    }
                    i = jumpto + 2;
                    continue;
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected TextPresentation createPresentation(IRegion damage, IDocument document) {
        try {
            int validLength = Math.min(damage.getLength(), document.getLength() - damage.getOffset());
            if (this.fRepairers == null || this.fRepairers.isEmpty()) {
                TextPresentation presentation = new TextPresentation(damage, 1);
                presentation.setDefaultStyleRange(new StyleRange(damage.getOffset(), validLength, null, null));
                return presentation;
            }
            ITypedRegion[] partitions = TextUtilities.computePartitioning((IDocument)document, (String)this.getDocumentPartitioning(), (int)damage.getOffset(), (int)validLength, (boolean)false);
            if (this.containSpecialType(partitions)) {
                if (partitions != null && partitions.length > 0) {
                    ITypedRegion newRegion;
                    int start = damage.getOffset();
                    int length = validLength;
                    ITypedRegion[] wholePartitions = TextUtilities.computePartitioning((IDocument)document, (String)this.getDocumentPartitioning(), (int)0, (int)document.getLength(), (boolean)false);
                    ITypedRegion startTypedRegion = partitions[0];
                    ITypedRegion endTypedRegion = partitions[partitions.length - 1];
                    if ("org.eclipse.php.PHP_DEFAULT".equals(startTypedRegion.getType()) && partitions.length >= 2) {
                        startTypedRegion = partitions[1];
                    }
                    if ((newRegion = this.getWholeRegion(wholePartitions, startTypedRegion)) != null) {
                        start = newRegion.getOffset();
                        length = endTypedRegion.getOffset() + endTypedRegion.getLength() - start;
                    }
                    if ("org.eclipse.php.PHP_DEFAULT".equals(endTypedRegion.getType()) && partitions.length >= 2) {
                        endTypedRegion = partitions[partitions.length - 2];
                    }
                    if ((newRegion = this.getWholeRegion(wholePartitions, endTypedRegion)) != null) {
                        length = newRegion.getOffset() + newRegion.getLength() - start;
                    }
                    if (start != damage.getOffset() || length != validLength) {
                        partitions = TextUtilities.computePartitioning((IDocument)document, (String)this.getDocumentPartitioning(), (int)start, (int)length, (boolean)false);
                    }
                }
                if (partitions == null) {
                    return null;
                }
                LinkedList<StyleRange> fRangeSet = new LinkedList<StyleRange>();
                int jumpto = -1;
                int i = 0;
                while (i < partitions.length) {
                    IPresentationRepairer repairer;
                    ITypedRegion r = partitions[i];
                    if (fTypeSet.contains(r.getType()) && i + 2 < partitions.length && "org.eclipse.php.PHP_DEFAULT".equals(partitions[i + 1].getType()) && r.getType().equals(partitions[i + 2].getType())) {
                        if (i > jumpto) {
                            jumpto = this.getFollowingCSS(partitions, i, r.getType());
                            repairer = this.getRepairer((r = new SimpleStructuredTypedRegion(r.getOffset(), partitions[jumpto].getOffset() + partitions[jumpto].getLength() - r.getOffset(), r.getType())).getType());
                            if (repairer != null) {
                                presentation = new TextPresentation(damage, 1000);
                                repairer.createPresentation(presentation, r);
                                iterator = presentation.getAllStyleRangeIterator();
                                while (iterator.hasNext()) {
                                    styleRange = (StyleRange)iterator.next();
                                    if (styleRange.start < r.getOffset() || styleRange.start + styleRange.length > r.getOffset() + r.getLength()) continue;
                                    int j = i + 1;
                                    while (j < jumpto) {
                                        ITypedRegion typedRegion = partitions[j];
                                        if (styleRange.start < typedRegion.getOffset() && styleRange.start + styleRange.length > typedRegion.getOffset() + typedRegion.getLength()) {
                                            int end = styleRange.start + styleRange.length;
                                            styleRange.length = typedRegion.getOffset() - styleRange.start;
                                            fRangeSet.add(styleRange);
                                            styleRange = new StyleRange(typedRegion.getOffset() + typedRegion.getLength(), end - (typedRegion.getOffset() + typedRegion.getLength()), styleRange.foreground, styleRange.background, styleRange.fontStyle);
                                        } else {
                                            if (styleRange.start < typedRegion.getOffset() && styleRange.start + styleRange.length > typedRegion.getOffset()) {
                                                styleRange.length = typedRegion.getOffset() - styleRange.start;
                                                break;
                                            }
                                            if (styleRange.start >= typedRegion.getOffset() && styleRange.start + styleRange.length <= typedRegion.getOffset() + typedRegion.getLength()) {
                                                styleRange = null;
                                                break;
                                            }
                                            if (styleRange.start > typedRegion.getOffset() && styleRange.start < typedRegion.getOffset() + typedRegion.getLength() && styleRange.start + styleRange.length > typedRegion.getOffset() + typedRegion.getLength()) {
                                                styleRange.length = styleRange.start + styleRange.length - (typedRegion.getOffset() + typedRegion.getLength());
                                                styleRange.start = typedRegion.getOffset() + typedRegion.getLength();
                                            } else if (styleRange.start + styleRange.length < typedRegion.getOffset()) break;
                                        }
                                        j += 2;
                                    }
                                    if (styleRange == null) continue;
                                    fRangeSet.add(styleRange);
                                }
                            }
                        }
                    } else if ((i > jumpto || i < jumpto && !r.getType().equals(partitions[jumpto].getType())) && (repairer = this.getRepairer(r.getType())) != null) {
                        presentation = new TextPresentation(damage, 1000);
                        repairer.createPresentation(presentation, r);
                        iterator = presentation.getAllStyleRangeIterator();
                        while (iterator.hasNext()) {
                            styleRange = (StyleRange)iterator.next();
                            fRangeSet.add(styleRange);
                        }
                    }
                    ++i;
                }
                if (fRangeSet.isEmpty()) {
                    return null;
                }
                Collections.sort(fRangeSet, new Comparator<StyleRange>(){

                    @Override
                    public int compare(StyleRange o1, StyleRange o2) {
                        return o1.start - o2.start;
                    }
                });
                ArrayList<StyleRange> fRanges = new ArrayList<StyleRange>();
                StyleRange[] rangeArray = fRangeSet.toArray(new StyleRange[fRangeSet.size()]);
                StyleRange lastRange = rangeArray[0];
                fRanges.add(lastRange);
                int i2 = 1;
                while (i2 < rangeArray.length) {
                    StyleRange styleRange = rangeArray[i2];
                    if (styleRange.start != lastRange.start || styleRange.length != lastRange.length) {
                        fRanges.add(styleRange);
                        lastRange = styleRange;
                    }
                    ++i2;
                }
                TextPresentation presentation = new TextPresentation(damage, 1000);
                presentation = new TextPresentation(damage, fRanges.size());
                for (StyleRange styleRange : fRanges) {
                    if (styleRange.start + styleRange.length <= damage.getOffset()) continue;
                    if (styleRange.start <= damage.getOffset() && styleRange.start + styleRange.length > damage.getOffset() && styleRange.start + styleRange.length <= damage.getOffset() + validLength) {
                        int rangeEnd = styleRange.start + styleRange.length;
                        styleRange.start = damage.getOffset();
                        styleRange.length = rangeEnd - damage.getOffset();
                        this.addStyleRange(presentation, styleRange);
                        continue;
                    }
                    if (styleRange.start >= damage.getOffset() && styleRange.start < damage.getOffset() + validLength && styleRange.start + styleRange.length > damage.getOffset() + validLength) {
                        styleRange.length = damage.getOffset() + validLength - styleRange.start;
                        this.addStyleRange(presentation, styleRange);
                        continue;
                    }
                    if (styleRange.start < damage.getOffset() || styleRange.start + styleRange.length > damage.getOffset() + validLength) continue;
                    this.addStyleRange(presentation, styleRange);
                }
                return presentation;
            }
            TextPresentation presentation = new TextPresentation(damage, 1000);
            List<ITypedRegion> damagedPartitions = this.findDamagedPartitions(partitions, damage);
            if (damagedPartitions.size() == 1) {
                ITypedRegion r = damagedPartitions.get(0);
                IPresentationRepairer repairer = this.getRepairer(damagedPartitions.get(0).getType());
                if (repairer != null) {
                    TextPresentation newPresentation;
                    if (r.getType().equals("org.eclipse.php.PHP_DEFAULT") && repairer instanceof StructuredDocumentDamagerRepairer && (newPresentation = ((StructuredDocumentDamagerRepairer)repairer).getPresentation(r, damage)) != null) {
                        presentation = newPresentation;
                    }
                    repairer.createPresentation(presentation, r);
                }
            } else {
                int i = 0;
                while (i < damagedPartitions.size()) {
                    ITypedRegion r = damagedPartitions.get(i);
                    IPresentationRepairer repairer = this.getRepairer(r.getType());
                    if (repairer != null) {
                        repairer.createPresentation(presentation, r);
                    }
                    ++i;
                }
            }
            return presentation;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private List<ITypedRegion> findDamagedPartitions(ITypedRegion[] partitions, IRegion damage) {
        ArrayList<ITypedRegion> damagedPartitions = new ArrayList<ITypedRegion>();
        int damageEnd = damage.getOffset() + damage.getLength();
        int i = 0;
        while (i < partitions.length) {
            ITypedRegion p = partitions[i];
            int pEnd = p.getOffset() + p.getLength();
            if (damage.getOffset() >= p.getOffset() && damage.getOffset() <= pEnd) {
                damagedPartitions.add(p);
                if (damageEnd < pEnd) {
                    break;
                }
            } else {
                if (damage.getOffset() < p.getOffset() && damageEnd <= pEnd) {
                    damagedPartitions.add(p);
                    break;
                }
                if (damage.getOffset() < p.getOffset() && damageEnd > pEnd) {
                    damagedPartitions.add(p);
                }
            }
            ++i;
        }
        return damagedPartitions;
    }

    private boolean containSpecialType(ITypedRegion[] partitions) {
        int i = 0;
        while (i < partitions.length) {
            ITypedRegion r = partitions[i];
            if (fTypeSet.contains(r.getType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void addStyleRange(TextPresentation presentation, StyleRange styleRange) {
        if (styleRange.length > 0) {
            presentation.addStyleRange(styleRange);
        }
    }

    private int getFollowingCSS(ITypedRegion[] partitions, int i, String type) {
        int result = i++;
        while (i < partitions.length) {
            if (i + 1 >= partitions.length || !partitions[i].getType().equals("org.eclipse.php.PHP_DEFAULT") || !partitions[i + 1].getType().equals(type)) break;
            result += 2;
            i += 2;
        }
        return result;
    }

    public void setRepairer(IPresentationRepairer repairer, String contentType) {
        super.setRepairer(repairer, contentType);
        Assert.isNotNull((Object)contentType);
        if (this.fRepairers == null) {
            this.fRepairers = new HashMap<String, IPresentationRepairer>();
        }
        if (repairer == null) {
            this.fRepairers.remove(contentType);
        } else {
            this.fRepairers.put(contentType, repairer);
        }
    }
}

