/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.snippets;

import java.util.Map;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.services.snippets.IXMLSnippetContext;
import org.eclipse.lemminx.utils.DOMUtils;

public class ProcessingInstructionSnippetContext
implements IXMLSnippetContext {
    public static IXMLSnippetContext DEFAULT_CONTEXT = new ProcessingInstructionSnippetContext();

    @Override
    public boolean isMatch(ICompletionRequest request, Map<String, String> model) {
        DOMNode node = request.getNode();
        int offset = request.getOffset();
        if ((node.isComment() || node.isDoctype() || node.isProlog() || node.isProcessingInstruction()) && offset < node.getEnd()) {
            return false;
        }
        if (node.getParentNode() != null && node.getParentNode().isDoctype()) {
            return false;
        }
        DOMDocument document = request.getXMLDocument();
        DOMElement documentElement = document.getDocumentElement();
        if (document.isDTD() || DOMUtils.isXSD(document) || DOMUtils.isRelaxNG(document)) {
            return false;
        }
        if (document.isBeforeProlog(offset)) {
            return false;
        }
        if (documentElement != null && documentElement.hasTagName()) {
            return offset <= documentElement.getStart();
        }
        return true;
    }
}

